# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbThrottlingSettings(Model):
    """Specifies resource limits for the migration.

    :param min_free_cpu: The percentage of CPU time that the migrator will try
     to avoid using, from 0 to 100
    :type min_free_cpu: int
    :param min_free_memory_mb: The number of megabytes of RAM that the
     migrator will try to avoid using
    :type min_free_memory_mb: int
    :param max_parallelism: The maximum number of work items (e.g. collection
     copies) that will be processed in parallel
    :type max_parallelism: int
    """

    _attribute_map = {
        'min_free_cpu': {'key': 'minFreeCpu', 'type': 'int'},
        'min_free_memory_mb': {'key': 'minFreeMemoryMb', 'type': 'int'},
        'max_parallelism': {'key': 'maxParallelism', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(MongoDbThrottlingSettings, self).__init__(**kwargs)
        self.min_free_cpu = kwargs.get('min_free_cpu', None)
        self.min_free_memory_mb = kwargs.get('min_free_memory_mb', None)
        self.max_parallelism = kwargs.get('max_parallelism', None)
