# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AutomaticOSUpgradePolicy(Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :param enable_automatic_os_upgrade: Whether OS upgrades should
     automatically be applied to scale set instances in a rolling fashion when
     a newer version of the image becomes available. Default value is false.
    :type enable_automatic_os_upgrade: bool
    :param disable_automatic_rollback: Whether OS image rollback feature
     should be disabled. Default value is false.
    :type disable_automatic_rollback: bool
    """

    _attribute_map = {
        'enable_automatic_os_upgrade': {'key': 'enableAutomaticOSUpgrade', 'type': 'bool'},
        'disable_automatic_rollback': {'key': 'disableAutomaticRollback', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(AutomaticOSUpgradePolicy, self).__init__(**kwargs)
        self.enable_automatic_os_upgrade = kwargs.get('enable_automatic_os_upgrade', None)
        self.disable_automatic_rollback = kwargs.get('disable_automatic_rollback', None)
