# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Essentials(Model):
    """This object contains normalized fields across different monitor service and
    also contains state related fields.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar severity: Severity of alert Sev0 being highest and Sev3 being
     lowest. Possible values include: 'Sev0', 'Sev1', 'Sev2', 'Sev3', 'Sev4'
    :vartype severity: str or ~azure.mgmt.alertsmanagement.models.Severity
    :ivar signal_type: Log based alert or metric based alert. Possible values
     include: 'Metric', 'Log', 'Unknown'
    :vartype signal_type: str or
     ~azure.mgmt.alertsmanagement.models.SignalType
    :ivar alert_state: Alert object state, which is modified by the user.
     Possible values include: 'New', 'Acknowledged', 'Closed'
    :vartype alert_state: str or
     ~azure.mgmt.alertsmanagement.models.AlertState
    :ivar monitor_condition: Represents rule condition(Fired/Resolved)
     maintained by monitor service depending on the state of the state.
     Possible values include: 'Fired', 'Resolved'
    :vartype monitor_condition: str or
     ~azure.mgmt.alertsmanagement.models.MonitorCondition
    :param target_resource: Target ARM resource, on which alert got created.
    :type target_resource: str
    :param target_resource_name: Name of the target ARM resource name, on
     which alert got created.
    :type target_resource_name: str
    :param target_resource_group: Resource group of target ARM resource, on
     which alert got created.
    :type target_resource_group: str
    :param target_resource_type: Resource type of target ARM resource, on
     which alert got created.
    :type target_resource_type: str
    :ivar monitor_service: Monitor service on which the rule(monitor) is set.
     Possible values include: 'Application Insights', 'ActivityLog
     Administrative', 'ActivityLog Security', 'ActivityLog Recommendation',
     'ActivityLog Policy', 'ActivityLog Autoscale', 'Log Analytics', 'Nagios',
     'Platform', 'SCOM', 'ServiceHealth', 'SmartDetector', 'VM Insights',
     'Zabbix'
    :vartype monitor_service: str or
     ~azure.mgmt.alertsmanagement.models.MonitorService
    :ivar alert_rule: Rule(monitor) which fired alert instance. Depending on
     the monitor service,  this would be ARM id or name of the rule.
    :vartype alert_rule: str
    :ivar source_created_id: Unique Id created by monitor service for each
     alert instance. This could be used to track the issue at the monitor
     service, in case of Nagios, Zabbix, SCOM etc.
    :vartype source_created_id: str
    :ivar smart_group_id: Unique Id of the smart group
    :vartype smart_group_id: str
    :ivar smart_grouping_reason: Verbose reason describing the reason why this
     alert instance is added to a smart group
    :vartype smart_grouping_reason: str
    :ivar start_date_time: Creation time(ISO-8601 format) of alert instance.
    :vartype start_date_time: datetime
    :ivar last_modified_date_time: Last modification time(ISO-8601 format) of
     alert instance.
    :vartype last_modified_date_time: datetime
    :ivar monitor_condition_resolved_date_time: Resolved time(ISO-8601 format)
     of alert instance. This will be updated when monitor service resolves the
     alert instance because of the rule condition is not met.
    :vartype monitor_condition_resolved_date_time: datetime
    :ivar last_modified_user_name: User who last modified the alert, in case
     of monitor service updates user would be 'system', otherwise name of the
     user.
    :vartype last_modified_user_name: str
    """

    _validation = {
        'severity': {'readonly': True},
        'signal_type': {'readonly': True},
        'alert_state': {'readonly': True},
        'monitor_condition': {'readonly': True},
        'monitor_service': {'readonly': True},
        'alert_rule': {'readonly': True},
        'source_created_id': {'readonly': True},
        'smart_group_id': {'readonly': True},
        'smart_grouping_reason': {'readonly': True},
        'start_date_time': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'monitor_condition_resolved_date_time': {'readonly': True},
        'last_modified_user_name': {'readonly': True},
    }

    _attribute_map = {
        'severity': {'key': 'severity', 'type': 'str'},
        'signal_type': {'key': 'signalType', 'type': 'str'},
        'alert_state': {'key': 'alertState', 'type': 'str'},
        'monitor_condition': {'key': 'monitorCondition', 'type': 'str'},
        'target_resource': {'key': 'targetResource', 'type': 'str'},
        'target_resource_name': {'key': 'targetResourceName', 'type': 'str'},
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'target_resource_type': {'key': 'targetResourceType', 'type': 'str'},
        'monitor_service': {'key': 'monitorService', 'type': 'str'},
        'alert_rule': {'key': 'alertRule', 'type': 'str'},
        'source_created_id': {'key': 'sourceCreatedId', 'type': 'str'},
        'smart_group_id': {'key': 'smartGroupId', 'type': 'str'},
        'smart_grouping_reason': {'key': 'smartGroupingReason', 'type': 'str'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
        'monitor_condition_resolved_date_time': {'key': 'monitorConditionResolvedDateTime', 'type': 'iso-8601'},
        'last_modified_user_name': {'key': 'lastModifiedUserName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Essentials, self).__init__(**kwargs)
        self.severity = None
        self.signal_type = None
        self.alert_state = None
        self.monitor_condition = None
        self.target_resource = kwargs.get('target_resource', None)
        self.target_resource_name = kwargs.get('target_resource_name', None)
        self.target_resource_group = kwargs.get('target_resource_group', None)
        self.target_resource_type = kwargs.get('target_resource_type', None)
        self.monitor_service = None
        self.alert_rule = None
        self.source_created_id = None
        self.smart_group_id = None
        self.smart_grouping_reason = None
        self.start_date_time = None
        self.last_modified_date_time = None
        self.monitor_condition_resolved_date_time = None
        self.last_modified_user_name = None
