#-*- coding:utf-8 -*-

#  Pybik -- A 3 dimensional magic cube game.
#  Copyright © 2009, 2011-2014  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.



import os, sys

N_ = lambda s: s

AUTHOR = 'B. Clausius'
CONTACT_EMAIL = 'barcc@gmx.de'
COPYRIGHT = 'Copyright © 2009-2014,  B. Clausius'
LICENSE_NAME = 'GPL-3+'
PACKAGE = 'pybik'
# Name of the application, probably should not be translated.
APPNAME = N_('Pybik')
VERSION = '1.1.1'
WEBSITE = 'https://launchpad.net/pybik/'
DOWNLOADS = 'https://launchpad.net/pybik/+download'
CONTACT_FILEBUG = 'https://bugs.launchpad.net/pybik/+filebug'


# The following two lines are replaced by setup.py
data_dir = os.path.join(os.path.dirname(os.path.dirname(__file__)), 'data')
appdata_dir = data_dir

LOCALE_DIR   = os.path.join(data_dir, 'locale')
QT_LOCALE_DIR = os.path.join(sys.prefix, 'share', 'qt4', 'translations')
PIXMAP_DIR   = os.path.join(data_dir, 'pixmaps')
IMAGE_FILE   = os.path.join(PIXMAP_DIR, PACKAGE+'.png')
LICENSE_FILE = os.path.join(appdata_dir, 'GPL-3')
MODELS_DIR   = os.path.join(appdata_dir, 'models')
SCRIPT_DIR   = os.path.join(appdata_dir, 'plugins')
UI_DIR       = os.path.join(appdata_dir, 'ui')
TESTDATA_DIR = os.path.join(appdata_dir, 'tests')

def get_testdatafiles():
    return [f for f in os.listdir(TESTDATA_DIR) if not f.endswith('~')]
    
def get_config_home():
    return os.environ.get('XDG_CONFIG_HOME', '') or os.path.expanduser("~/.config")
def get_data_home():
    return os.environ.get('XDG_DATA_HOME', '') or os.path.expanduser("~/.local/share")
    
USER_CONFIG_DIR    = os.path.join(get_config_home(), PACKAGE)
USER_SETTINGS_FILE = os.path.join(USER_CONFIG_DIR, 'settings.conf')
USER_VERSION_FILE  = os.path.join(USER_CONFIG_DIR, 'version')
USER_SCRIPT_DIR    = os.path.join(get_data_home(), PACKAGE, 'plugins')

SHORT_DESCRIPTION = N_("3D Rubik's cube game")
LONG_DESCRIPTION = N_(
    'Pybik is an interactive, graphical, single player puzzle about the cube invented by'
    ' Ernő Rubik. Besides the cube the program can handle towers and bricks (non cubic'
    ' puzzles). Pybik also has solvers, pretty patterns and a collection of various'
    ' moves. The cube can be manipulated with the mouse or keyboard. You can change the'
    ' colors or images on the faces of the cube.'
)

LICENSE_INFO = N_(
            'This program is free software: you can redistribute it and/or modify '
            'it under the terms of the GNU General Public License as published by '
            'the Free Software Foundation, either version 3 of the License, or '
            '(at your option) any later version.\n\n'

            'This program is distributed in the hope that it will be useful, '
            'but WITHOUT ANY WARRANTY; without even the implied warranty of '
            'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the '
            'GNU General Public License for more details.')
LICENSE_FURTHER = N_(
# Text between "<" and ">" is expanded to a link by the program and should not be modified.
# Text between "<LINK|>" and "<|>" is the translatable text for the link.
            'Read the full text of the <text:FULL_LICENSE_TEXT|>GNU General Public License'
            '<|> or see <http://www.gnu.org/licenses/>.')
LICENSE_NOT_FOUND = N_(
            'You should have received a copy of the GNU General Public License'
            ' along with this program.  If not, see <http://www.gnu.org/licenses/>.')

def get_filebug_text():
    return _(
    # "Wishlist" is used on Launchpad for Importance, so this word should probably not be translated
    'If you find any bugs in Pybik or have a suggestion for an improvement then please '
    'submit a <{CONTACT_FILEBUG}|>bug report<|>. '
    'In the latter case you can mark the bug report as "Wishlist".'
    ).format(CONTACT_FILEBUG=CONTACT_FILEBUG)

TRANSLATION_TEXT = N_(
    'Translations are managed by the '
    '<https://translations.launchpad.net/+groups/launchpad-translators|>'
    'Launchpad translation group<|>.\n\n'
    'If you want help to translate Pybik to your language you can do it through '
    'the <https://translations.launchpad.net/pybik|>web interface<|>.\n\n'
    'Read more about <https://help.launchpad.net/Translations|>"Translating with Launchpad"<|> '
    'and <https://help.launchpad.net/Translations/StartingToTranslate|>"Starting to translate"<|>.')

def splitlines(description):
    line = None
    for word in description.split():
        if line is None:
            line = word
        elif len(line) + 1 + len(word) > 78:
            yield line
            line = word
        else:
            line = ' '.join((line, word))
    if line is not None:
        yield line
        
def wrap(text, sep='\n'):
    if type(text) in [list, tuple]:
        text, lines = text
    else:
        lines = None
    text = sep.join(splitlines(text))
    if lines:
        text += sep + sep + sep.join(lines)
    return text
    

