# dbinit.py - db and table creation test
#
# Copyright (C) 2001 Federico Di Gregorio  <fog@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTIBILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# -*- Mode: pyhton -*-

print "Table creation test"

# build the CREATE command string
dbinit_op = 'CREATE TABLE '+TABLE+'('
for j in range(len(TABLE_COLUMNS)):
    dbinit_op = dbinit_op + TABLE_COLUMNS[j] + ' ' + TABLE_TYPES[j] + ', '
dbinit_op = dbinit_op[:-2] + ')'

o = dba.connect(DSN)

# create table test
print "     a. Creating table...",
try:
    c = o.cursor()
    c.execute(dbinit_op)
    o.commit()
    ok("YES")
except dba.ProgrammingError, err:
    ko("ERROR")
    print err

# drop table test
print "     b. Dropping table...",
try:
    c = o.cursor()
    c.execute("DROP TABLE "+TABLE)
    o.commit()
    ok("YES")
except dba.ProgrammingError, err:
    ko("ERROR")
    print err

# another drop should raise an exception
print "     c. Dropping table again...",
try:
    c = o.cursor()
    c.execute("DROP TABLE "+TABLE)
    o.commit()
    ko("ERROR (missing exception)")
except dba.ProgrammingError, err:
    ok("YES (got exception)")

# create an existing table, test is passed if the drivers
# raise a ProgrammingError exception
print "     d. Creating existing table...",
try:
    c = o.cursor()
    c.execute(dbinit_op)
    o.commit()
    c.execute(dbinit_op)
    o.commit()
    ko("ERROR (missing exception)")
except dba.ProgrammingError, err:
    ok("YES (got exception)")

