#include <stdio.h>
#include <X11/Xlib.h>
#include <unistd.h>
#include <signal.h>

static char *progname = "plotmtv_signaller";
static char *display_name = "";
static Display *mydisplay;
static int screen;
static Window rtwindow;

static void Usr1SignalHandler()
{
	int ret;
	Screen *scr;
	XKeyEvent theEvent;
	fprintf(stdout,"plotmtv_signaller: Caught USR1 signal.\n");
	theEvent.type = KeyPress;
	fprintf(stdout,"plotmtv_signaller: Now sending X event (to parent, hopefully!)...\n");
	scr = ScreenOfDisplay(mydisplay,DefaultScreen(mydisplay));
	ret=XSendEvent(mydisplay,rtwindow,/*False*/True,EventMaskOfScreen(scr)/*0*//*KeyPressMask*/,(XEvent*)&theEvent);
	if (ret==0) fprintf(stderr,"*** XSendEvent: Conversion to wire protocol failed.\n");
	fprintf(stdout,"Event sent to window %ld.\n",(long)rtwindow);
	signal(SIGUSR1,Usr1SignalHandler);
}

main()
{
	int i;
	FILE *fp;
	char filename[80];
	unsigned long int windowid;
	if (!(mydisplay = XOpenDisplay(display_name))) {
		(void) fprintf(stderr,"\n%s:Could not open X11 display '%s'\n",
					   progname,XDisplayName(display_name));
		return(0);
	}
	screen = DefaultScreen(mydisplay);

	
	sprintf(filename,"/tmp/plotmtv%d.windowid",(int)getppid());
	fp = fopen(filename,"r");
	if (!fp) {
		fprintf(stderr,"*** plotmtv_signaller: could not open '%s' for reading.\n",filename);
		exit(1);
	}
	fscanf(fp,"%ld",&windowid);
	fclose(fp);
	remove(filename);
	rtwindow = (Window)windowid;
	signal(SIGUSR1,Usr1SignalHandler);
	for (i=0; i<30000; i++) sleep(30000);
	exit(0);
}
