dnl
dnl $Id$
dnl config.m4 for extension maxdb

PHP_ARG_WITH(maxdb, for maxdb support,
[  --with-maxdb[=DIR]        Include MaxDB support. DIR is SQLDBC base.])

if test "$PHP_MAXDB" != "no"; then

  if test "$PHP_MAXDB" = "yes"; then
    for I in SQLDBC_C.h SQLDBC_Types.h
    do
      if test -r /usr/include/maxdb/$I; then
        SQLDBC_SDK_DIR=/usr/include/maxdb
      elif test -r /usr/include/$I; then
        SQLDBC_SDK_DIR=/usr/include
      elif test -r /usr/incl/$I; then
        SQLDBC_SDK_DIR=/usr/incl
      else
        AC_MSG_ERROR(Please reinstall SQLDBC sdk. File $I not found)
      fi
    done
    if test -r /usr/lib/libSQLDBC_C.so; then
      SQLDBC_SHL_DIR=/usr/lib
    else
      AC_MSG_ERROR(Please reinstall SQLDBC. Library libSQLDBC_C not found)
    fi
  else
    SQLDBC_SDK_DIR=$PHP_MAXDB/sdk/sqldbc/incl
    SQLDBC_SHL_DIR=$PHP_MAXDB/lib
  fi

  if test -r $SQLDBC_SHL_DIR/libSQLDBC_C.so; then
    SQLDBC_LIB_DIR=$SQLDBC_SHL_DIR
  else
    AC_MSG_ERROR(Please reinstall SQLDBC. Library libSQLDBC_C not found)
  fi  

  if test ! -r "$SQLDBC_SDK_DIR/SQLDBC_C.h"; then
    AC_MSG_ERROR(Please reinstall SQLDBC sdk. File SQLDBC_C.h not found)
  fi

  if test ! -r "$SQLDBC_SDK_DIR/SQLDBC_Types.h"; then
    AC_MSG_ERROR(Please reinstall SQLDBC sdk. File SQLDBC_Types.h not found)
  fi

  awk 'BEGIN { version_okay = 0 } /^#define SQLDBC_CHeaderVersion \"SQLDBC_C.H[[:blank:]]*[[:digit:]]+\.[[:digit:]]+\.[[:digit:]]+[[:blank:]]*BUILD[[:blank:]]*[[:digit:]]+.*\"$/ { 
    split($4, a, "."); 
    split($6, b, "-");
    if (a[[1]]<7 || (a[[1]]>=7 && a[[2]]<5) || (a[[1]]==7 && a[[2]]==5 && a[[3]]==0 && b[[1]]<19)) {
      version = $4 " " $5 " " $6;
    } else {
      version_okay = 1;
    }
  } END {
    if (!version_okay) {
      printf ("\n");
      print $4;
      if (version) {
        printf ("Wrong version of SQLDBC sdk found \"%s.\n", version);
      } else {
        printf ("Cannot find the version of SQLDBC sdk.\n");
      }
      print "The version of SQLDBC-SDK must be at least 7.5.0 Build 019.\n";
      print "The MaxDB PHP extension needs to link with MaxDB'\''s common database";
      print "interface SQLDBC. The MaxDB PHP extension does _not_ include the";
      print "MaxDB SQLDBC sdk! If it isn'\''t already installed you can download";
      print "it from the MSQL homepage.\n";
      exit 1;
    }
  }' $SQLDBC_SDK_DIR/SQLDBC_C.h
  
  if test $? -ne 0; then
    AC_MSG_ERROR(Not a correct SQLDBC sdk)
  fi

  PHP_ADD_INCLUDE($SQLDBC_SDK_DIR)

  PHP_ADD_LIBRARY_WITH_PATH(SQLDBC_C, $SQLDBC_SHL_DIR, MAXDB_SHARED_LIBADD)

  PHP_NEW_EXTENSION(maxdb, php_maxdb.c, $ext_shared)
  PHP_SUBST(MAXDB_SHARED_LIBADD)
fi












