// smpte.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// class for storing information about SMPTE options

#ifndef MXV_SMPTE_H
#ifdef __GNUG__
#pragma interface
#endif
#define MXV_SMPTE_H

class SMPTE {
public:
	enum Format {
		Film=1, PAL_SECAM=2, NTSC_Color=4,
		NTSC_DropFrame=8, Frame_30=16, DropFrame_30=32
	};
public:
	static void setFormat(Format fmt) { current_Format = fmt; }
	static Format currentFormat() { return current_Format; }
	static const char* formatNames();
	static double frames(double time);
private:
	static double framesPerSecond();
	static Format current_Format;
	static double frames_PerSecond[];
	virtual void dontAllowInstantiation()=0;
};

#endif
