// query_templates.h

#ifndef QUERY_TEMPLATES_H
#define QUERY_TEMPLATES_H

#include "localdefs.h"
#include "queryvalue.h"
#include "settergetter.h"

template <class Type>
class Query : public QueryNumber {
	typedef QueryNumber Super;
public:
	Query(const char *lbl, SetterGetter<Type>* sg,
	      const Range& range, boolean displayRange)
		: QueryNumber(lbl, &CharCheck::numsOnly),
		setterGetter(sg), bounds(range),
		displayBounds(displayRange) {}
	virtual ~Query();
	redefined const char* get() const;
	redefined QueryType type();
	redefined const Range& range() { return bounds; }
protected:
	redefined boolean checkAndSet(const char *);
protected:
	SetterGetter<Type>* setterGetter;
	const Range bounds;
	boolean displayBounds;
};

template <class Type>
inline QueryValue*
createQuery(
		const char* label,
		Type* ptr,
		const Range& range,
		boolean displayRange
           ) {
	return new Query<Type>(
			label,
			createSetterGetter(ptr),
			range,
			displayRange);
}

#ifndef __GNUG__

template <class Status, class Type>
inline QueryValue* createQuery(
				const char* label,
				Status (*setter)(Type),
				Type (*getter)(),
				const Range &range,
				boolean displayRange
                    ) {
	return new Query<Type>(
			label,
			createSetterGetter(setter, getter),
			range,
			displayRange);
}


template <class Object, class Status, class Type>
inline QueryValue* createQuery(
				const char* label,
				Object* o,
				Status (Object::*setter)(Type),
				Type (Object::*getter)() const,
				const Range &range,
				boolean displayRange
                    ) {
	return new Query<Type>(
			label,
			createSetterGetter(o, setter, getter),
			range,
			displayRange);
}

template <class Object, class Type>
inline QueryValue* createVoidQuery(
				const char* label,
				Object* o,
				void (Object::*setter)(Type),
				Type (Object::*getter)() const,
				const Range &range,
				boolean displayRange
                    ) {
	return new Query<Type>(
			label,
			new MethodVoidSetterGetter<Object, Type>(
					o,
					setter,
					getter
			),
			range,
			displayRange);
}

#endif /* __GNUG__ */

#ifdef __GNUG__
#include "query_templates.C"
#endif

#endif

