// compressor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// class for compressing and uncompressing sound samples

#ifndef COMPRESSOR_H
#define COMPRESSOR_H

class Compressor {
public:
	static short fromMuLaw(unsigned char);
	static unsigned char toMuLaw(short);
	static short fromALaw(unsigned char);
	static unsigned char toALaw(short);
private:
	static const short ulaw2LinearTable[256];
	static const unsigned char linear2UlawTable[8192];
	static const short alaw2LinearTable[256];
	static const unsigned char linear2AlawTable[8192];
private:
    virtual void dontAllowInstantiation()=0;
};

#endif
