#ifndef __COMP_GUESS_DLG_H
#define __COMP_GUESS_DLG_H
/*-------------------------------------------------------------------------
 * Copyright (c) 2000 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * comp_guess_dlg
 *
 * Synopsis:
 *    Computer player guess display dialog.
 *
 * $Id: comp_guess_dlg.h,v 1.1 2000/10/15 15:36:15 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to 
 * Free Software Foundation, Inc. 
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
/*! \file comp_guess_dlg.h
 
  \brief Display the computer guess information

  When the computer guesses, the player has a chance to say whether or
  not the computer is correct.  This dialog displays the computer's guess,
  and asks the user if it is correct.

  \author Kenneth W. Sodemann <stufflehead@bigfoot.com>
  $Revision: 1.1 $
  $Date: 2000/10/15 15:36:15 $
*/

#include "operators.h"

/*! \fn gint execute_comp_guess_dlg (GtkWidget     *parent,
                                     gint           card1,
                                     gint           card2,
                                     operator_type  op,
                                     gint           answer)

  \brief Execute the computer guess dialog box

  When the computer guesses, it may be right, and it may be wrong. 
  Display the guess to the human player, and ask them if they think
  the computer is correct or not.

  \param parent
  The parent window of this dialog

  \param card1
  Face value of card1

  \param card2
  Face value of card2

  \param op
  The current operator

  \param answer
  The computer player's "guess"

  \return
  A value indicating which button was used to close the dialog box.

  \retval 0
  The user closed the dialog box using the "Yes" button.

  \retval 1
  The user closed the dialog box using the "No" button.

  \retval -1
  The user closed the dialog box using the window manager.
*/
gint execute_comp_guess_dlg (GtkWidget     *parent,
                             gint           card1,
                             gint           card2,
                             operator_type  op,
                             gint           answer);
#endif
