/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class TextOutputHandler
extends HandlerBase
implements OutputDocumentHandler {
    private Writer writer;
    private boolean keepOpen;

    public TextOutputHandler() {
    }

    public TextOutputHandler(Writer writer) {
        this.writer = writer;
    }

    public DocumentHandler init(Destination dest, AttributeList atts) throws IOException {
        String mediaType = atts.getValue("media-type");
        if (mediaType == null) {
            mediaType = "text/plain";
        }
        this.writer = dest.getWriter(mediaType, atts.getValue("encoding"));
        this.keepOpen = dest.keepOpen();
        return this;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                if (this.keepOpen) {
                    this.writer.flush();
                } else {
                    this.writer.close();
                }
                this.writer = null;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] cbuf, int off, int len) throws SAXException {
        try {
            this.writer.write(cbuf, off, len);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

