/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.NodeIterator;
import com.jclark.xsl.om.XSLException;

class MergeNodeIterator
implements NodeIterator {
    private NodeIterator[] iters;
    private Node[] nodes;
    private int length;

    MergeNodeIterator(NodeIterator[] iters, int length) throws XSLException {
        this.length = length;
        this.iters = iters;
        this.nodes = new Node[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Node tem;
            if (i != j) {
                iters[j] = iters[i];
            }
            if ((tem = iters[j].next()) == null) continue;
            this.nodes[j++] = tem;
        }
        this.length = j;
        this.buildHeap();
    }

    private final void heapify(int i) {
        while (true) {
            int left;
            int right;
            if ((right = (left = i << 1 | 1) + 1) < this.length) {
                if (this.compare(left, right) <= 0) {
                    if (this.compare(left, i) > 0) break;
                    this.exchange(left, i);
                    i = left;
                    continue;
                }
                if (this.compare(right, i) > 0) break;
                this.exchange(right, i);
                i = right;
                continue;
            }
            if (left >= this.length || this.compare(left, i) > 0) break;
            this.exchange(left, i);
            i = left;
        }
    }

    private final void exchange(int i, int j) {
        Object tem = this.nodes[i];
        this.nodes[i] = this.nodes[j];
        this.nodes[j] = tem;
        tem = this.iters[i];
        this.iters[i] = this.iters[j];
        this.iters[j] = tem;
    }

    private final int compare(int i, int j) {
        return this.nodes[i].compareTo(this.nodes[j]);
    }

    private void buildHeap() {
        for (int i = this.length / 2 - 1; i >= 0; --i) {
            this.heapify(i);
        }
    }

    public Node next() throws XSLException {
        if (this.length == 0) {
            return null;
        }
        Node max = this.nodes[0];
        do {
            Node tem;
            if ((tem = this.iters[0].next()) == null) {
                if (--this.length == 0) break;
                this.nodes[0] = this.nodes[this.length];
                this.iters[0] = this.iters[this.length];
            } else {
                this.nodes[0] = tem;
            }
            this.heapify(0);
        } while (max.equals(this.nodes[0]));
        return max;
    }
}

