/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.dom;

import com.jclark.xsl.dom.AttributeNode;
import com.jclark.xsl.dom.ContainerNode;
import com.jclark.xsl.dom.NullNodeIterator;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XSLException;
import org.w3c.dom.NamedNodeMap;

class ElementNode
extends ContainerNode {
    private Name name;
    private AttributeNode[] attributeNodes = null;

    ElementNode(org.w3c.dom.Node domNode, ContainerNode parent, int childIndex) {
        super(domNode, parent, childIndex);
        String qName;
        org.w3c.dom.Node domAttribute;
        int i;
        NamedNodeMap domAttributes = domNode.getAttributes();
        int len = domAttributes.getLength();
        if (len == 0) {
            return;
        }
        this.attributeNodes = new AttributeNode[len];
        int firstPrefixIndex = -1;
        block7: for (i = 0; i < len; ++i) {
            domAttribute = domAttributes.item(i);
            qName = domAttribute.getNodeName();
            switch (qName.indexOf(58)) {
                case -1: {
                    if (qName.equals("xmlns")) {
                        String uri = domAttribute.getNodeValue();
                        if (uri.length() == 0) {
                            this.prefixMap = this.prefixMap.unbindDefault();
                            continue block7;
                        }
                        this.prefixMap = this.prefixMap.bindDefault(uri);
                        continue block7;
                    }
                    this.attributeNodes[i] = new AttributeNode(this.root.nameTable.createName(domAttribute.getNodeName()), domAttribute, this, i - len - 1);
                    continue block7;
                }
                case 3: {
                    if (qName.equals("xml:space")) {
                        String value = domAttribute.getNodeValue();
                        if ("preserve".equals(value)) {
                            this.preserveSpace = true;
                        } else if ("default".equals(value)) {
                            this.preserveSpace = false;
                        }
                    }
                    if (firstPrefixIndex >= 0) continue block7;
                    firstPrefixIndex = i;
                    continue block7;
                }
                case 5: {
                    if (qName.startsWith("xmlns")) {
                        this.prefixMap = this.prefixMap.bind(qName.substring(6), domAttribute.getNodeValue());
                        continue block7;
                    }
                }
                default: {
                    if (firstPrefixIndex >= 0) continue block7;
                    firstPrefixIndex = i;
                }
            }
        }
        if (firstPrefixIndex >= 0) {
            for (i = firstPrefixIndex; i < len; ++i) {
                if (this.attributeNodes[i] != null || (qName = (domAttribute = domAttributes.item(i)).getNodeName()).startsWith("xmlns") && (qName.length() == 5 || qName.charAt(5) == ':')) continue;
                try {
                    this.attributeNodes[i] = new AttributeNode(this.prefixMap.expandAttributeName(domAttribute.getNodeName(), null), domAttribute, this, i - len - 1);
                    continue;
                }
                catch (XSLException e) {
                    // empty catch block
                }
            }
        }
    }

    public byte getType() {
        return 0;
    }

    public Name getName() {
        if (this.name == null) {
            String qName = this.domNode.getNodeName();
            try {
                this.name = this.prefixMap.expandElementTypeName(qName, null);
            }
            catch (XSLException e) {
                this.name = this.root.nameTable.createName(qName);
            }
        }
        return this.name;
    }

    public String getAttributeValue(Name name) {
        if (this.attributeNodes == null) {
            return null;
        }
        for (int i = 0; i < this.attributeNodes.length; ++i) {
            if (this.attributeNodes[i] == null || !name.equals(this.attributeNodes[i].name)) continue;
            return this.attributeNodes[i].getData();
        }
        return null;
    }

    public Node getAttribute(Name name) {
        if (this.attributeNodes == null) {
            return null;
        }
        for (int i = 0; i < this.attributeNodes.length; ++i) {
            if (this.attributeNodes[i] == null || !name.equals(this.attributeNodes[i].name)) continue;
            return this.attributeNodes[i];
        }
        return null;
    }

    public SafeNodeIterator getAttributes() {
        if (this.attributeNodes == null) {
            return NullNodeIterator.getInstance();
        }
        return new AttributesIterator();
    }

    public boolean getPreserveSpace() {
        return this.preserveSpace || !this.root.loadContext.getStripSource(this.getName());
    }

    class AttributesIterator
    implements SafeNodeIterator {
        int i = 0;

        AttributesIterator() {
        }

        public Node next() {
            while (this.i < ElementNode.this.attributeNodes.length) {
                AttributeNode attributeNode = ElementNode.this.attributeNodes[this.i++];
                if (attributeNode == null) continue;
                return attributeNode;
            }
            return null;
        }
    }
}

