package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

abstract class ConvertibleExpr {
  abstract ConvertibleStringExpr makeStringExpr();
  abstract ConvertibleBooleanExpr makeBooleanExpr();
  abstract ConvertibleVariantExpr makeVariantExpr();
  
  ConvertibleNodeSetExpr makeNodeSetExpr() throws ParseException {
    throw new ParseException("value of expression cannot be converted to a node-set");
  }

  ConvertibleNumberExpr makeNumberExpr() {
    return makeStringExpr().makeNumberExpr();
  }

  ConvertibleBooleanExpr makePredicateExpr() {
    return makeBooleanExpr();
  }

}
