package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;
import java.net.URL;

public interface ExprContext {
  int getPosition() throws XSLException;
  int getLastPosition() throws XSLException;
  Variant getGlobalVariableValue(Name name) throws XSLException;
  Variant getLocalVariableValue(Name name) throws XSLException;
  ExtensionContext getExtensionContext(String namespace) throws XSLException;
  Variant getSystemProperty(Name name);
  Node getCurrent(Node contextNode);
  NodeIterator getDocument(URL baseURL, String uriRef) throws XSLException;
  Node getTree(Variant v) throws XSLException;
}
