/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbcext;


import java.sql.Connection;
import java.sql.SQLException;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;



/**
 * Data source implementation for SAP DB.
 */
public class DataSourceSapDB
    extends DataSourceSapDBBase
    implements DataSource, Referenceable
               
{
    public Connection getConnection()
        throws SQLException
    {
        return openPhysicalConnection();
    }

    public Connection getConnection(String username, String password)
        throws SQLException
    {
        return openPhysicalConnection(username, password);
    }
    
    public Reference getReference() throws NamingException
    {
        return createReference(getClass().getName());
    }
}
