/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import java.sql.*;

import com.sap.dbtech.util.*;
/**
 *
 */
public class UnicodeStreamTranslator
    extends StreamTranslator
{
    /**
     * UnicodeStreamTranslator constructor comment.
     * @param mode int
     * @param ioType int
     * @param dataType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    protected UnicodeStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos, 
            boolean readOnly, 
            boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos, readOnly, autoIncr);
        characterDatatypePostfix = " UNICODE";
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public java.io.InputStream getAsciiStream (
        SQLParamController controller,
        StructuredMem mem,
        StructuredMem longData) throws SQLException
    {
        java.io.Reader reader = this.getCharacterStream (controller, mem, longData);
        if (reader == null) {
            return null;
        }
        return new ReaderInputStream (reader, false);
    }
    /**
     *
     * @return Object
     */
    public Object getObject (
        SQLParamController controller,
        StructuredMem mem)
            throws SQLException
    {
        Object result;

        result = this.getString(controller, mem);
        return result;
    }
    /**
     * creates a new java.io.Reader from a LONG UNICODE value
     *
     * @param controller
     *
     * @param mem
     *
     * @param longData
     *
     * @return
     *
     * @exception SQLException
     */
    public java.io.Reader getCharacterStream (
        SQLParamController controller,
        StructuredMem mem,
        StructuredMem longData) throws SQLException
    {
        java.io.Reader result = null;
        AbstractGetval getval;
        byte [] descriptor;

        if (!this.isNull (controller, mem)) {
            descriptor = mem.getBytes (this.bufpos, this.logicalLength);
            if (com.sap.dbtech.jdbc.DriverSapDB.isJDBC20) {
                getval = new GetvalUnicodeClob (controller.getConnectionSapDB (), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
            }
            else {
                getval = new GetvalUnicode (controller.getConnectionSapDB (), descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
            }
            result = getval.getCharacterStream ();
        }
        return result;
    }
        /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public java.sql.Clob getClob (
        SQLParamController controller,
        StructuredMem mem,
        StructuredMem longData) throws SQLException
    {
        GetvalUnicodeClob result = null;
        byte [] descriptor;

        if (!this.isNull (controller, mem)) {
          descriptor = mem.getBytes (this.bufpos, this.logicalLength);
          result = new GetvalUnicodeClob (controller.getConnectionSapDB (),
                descriptor, longData, this.isUnicodeColumn(), this.isPackectEncodingUnicode());
        }
        return result;
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public Object transAsciiStreamForInput (
        java.io.InputStream stream, int length) throws SQLException
    {
        if (stream == null) {
            return null;
        }
        java.io.Reader reader = new java.io.InputStreamReader (stream);
        return this.transCharacterStreamForInput (reader, length);
    }
    /**
     *
     * @return java.io.InputStream
     * @exception java.sql.SQLException The exception description.
     */
    public Object transCharacterStreamForInput (
        java.io.Reader reader, int length) throws SQLException
    {
        if (reader == null) {
            return null;
        }
        else {
            return new PutvalUnicode (reader, length, bufpos);
        }
    }
    /**
     *
     * @param val java.lang.String
     */
    public Object transStringForInput (String val)
        throws SQLException
    {
        if (val == null) {
            return null;
        } else {
			return new PutvalUnicode(val.toCharArray(), bufpos);
        }               
    }
   boolean isPackectEncodingUnicode() {
       return true;
   }

}
