/*
 * Copyright (C) The MX4J Contributors.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package test.mx4j.tools.connector;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;

import junit.framework.TestCase;
import mx4j.tools.connector.rmi.iiop.IIOPConnector;
import mx4j.tools.connector.rmi.jrmp.JRMPConnector;

/**
 * @version $Revision: 1.3 $
 */
public class RMIConnectorTest extends TestCase
{
   public RMIConnectorTest(String s)
   {
      super(s);
   }

   public void testJRMPConnectorSerialization() throws Exception
   {
      JRMPConnector connector = new JRMPConnector();

      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);

      oos.writeObject(connector);
   }

   public void testIIOPConnectorSerialization() throws Exception
   {
      IIOPConnector connector = new IIOPConnector();

      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ObjectOutputStream oos = new ObjectOutputStream(baos);

      oos.writeObject(connector);
   }
}
