/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphTransferable;
import org.jgraph.graph.ParentMap;

public class GraphTransferHandler
extends TransferHandler {
    protected Object out;
    protected Object in;
    protected int inCount = 0;

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (dataFlavorArray[i] != GraphTransferable.dataFlavor) continue;
            return true;
        }
        return false;
    }

    public Transferable createTransferableForGraph(JGraph jGraph) {
        return this.createTransferable(jGraph);
    }

    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof JGraph) {
            JGraph jGraph = (JGraph)jComponent;
            GraphModel graphModel = jGraph.getModel();
            if (!jGraph.isSelectionEmpty()) {
                return this.createTransferable(jGraph, jGraph.getDescendants(jGraph.order(jGraph.getSelectionCells())));
            }
        }
        return null;
    }

    protected Transferable createTransferable(JGraph jGraph, Object[] objectArray) {
        Object[] objectArray2 = jGraph.getDescendants(jGraph.order(objectArray));
        ParentMap parentMap = ParentMap.create(jGraph.getModel(), objectArray2, false, true);
        ConnectionSet connectionSet = ConnectionSet.create(jGraph.getModel(), objectArray2, false);
        Map map = GraphConstants.createAttributes(objectArray2, jGraph.getGraphLayoutCache());
        Rectangle2D rectangle2D = jGraph.getCellBounds(jGraph.getSelectionCells());
        rectangle2D = new AttributeMap.SerializableRectangle2D(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.out = objectArray2;
        return this.create(jGraph, objectArray2, map, rectangle2D, connectionSet, parentMap);
    }

    protected GraphTransferable create(JGraph jGraph, Object[] objectArray, Map map, Rectangle2D rectangle2D, ConnectionSet connectionSet, ParentMap parentMap) {
        return new GraphTransferable(objectArray, map, rectangle2D, connectionSet, parentMap);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (jComponent instanceof JGraph && transferable instanceof GraphTransferable) {
            JGraph jGraph = (JGraph)jComponent;
            if (n == 2) {
                Object[] objectArray = ((GraphTransferable)transferable).getCells();
                jGraph.getGraphLayoutCache().remove(objectArray);
            }
            jGraph.getUI().updateHandle();
            jGraph.getUI().setInsertionLocation(null);
        }
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        try {
            if (jComponent instanceof JGraph) {
                JGraph jGraph = (JGraph)jComponent;
                GraphModel graphModel = jGraph.getModel();
                GraphLayoutCache graphLayoutCache = jGraph.getGraphLayoutCache();
                if (transferable.isDataFlavorSupported(GraphTransferable.dataFlavor) && jGraph.isEnabled()) {
                    int n;
                    Point point = jGraph.getUI().getInsertionLocation();
                    Object object = transferable.getTransferData(GraphTransferable.dataFlavor);
                    GraphTransferable graphTransferable = (GraphTransferable)object;
                    Object[] objectArray = graphTransferable.getCells();
                    boolean bl = true;
                    for (n = 0; n < objectArray.length && bl; ++n) {
                        bl = bl && graphModel.contains(objectArray[n]);
                    }
                    this.inCount = this.in == objectArray ? ++this.inCount : (bl ? 1 : 0);
                    this.in = objectArray;
                    if (point != null && this.in == this.out && jGraph.getUI().getHandle() != null) {
                        n = jGraph.getUI().getDropAction() == 1 ? 2 : 0;
                        jGraph.getUI().getHandle().mouseReleased(new MouseEvent(jComponent, 0, 0L, n, point.x, point.y, 1, false));
                        return false;
                    }
                    Rectangle2D rectangle2D = graphTransferable.getBounds();
                    Hashtable hashtable = graphTransferable.getAttributeMap();
                    ConnectionSet connectionSet = graphTransferable.getConnectionSet();
                    ParentMap parentMap = graphTransferable.getParentMap();
                    if (!bl || point == null || jGraph.getUI().getDropAction() == 1) {
                        double d = 0.0;
                        double d2 = 0.0;
                        if (hashtable != null) {
                            if (point != null && rectangle2D != null) {
                                Point2D point2D = jGraph.fromScreen(jGraph.snap((Point2D)point.clone()));
                                d = point2D.getX() - rectangle2D.getX();
                                d2 = point2D.getY() - rectangle2D.getY();
                            } else {
                                d = (double)this.inCount * jGraph.getGridSize();
                                d2 = (double)this.inCount * jGraph.getGridSize();
                            }
                        }
                        this.handleExternalDrop(jGraph, objectArray, hashtable, connectionSet, parentMap, d, d2);
                        return jGraph.getUI().getDropAction() == 2 && !bl;
                    }
                    if (point != null) {
                        Point2D point2D = jGraph.fromScreen(jGraph.snap(new Point(point)));
                        if (rectangle2D != null && hashtable != null) {
                            double d = point2D.getX() - rectangle2D.getX();
                            double d3 = point2D.getY() - rectangle2D.getY();
                            AttributeMap.translate(hashtable.values(), d, d3);
                        } else if (rectangle2D == null) {
                            double d = 2.0 * jGraph.getGridSize();
                            hashtable = new Hashtable();
                            Hashtable hashtable2 = new Hashtable();
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!graphModel.isEdge(objectArray[i]) && !graphModel.isPort(objectArray[i])) {
                                    Rectangle2D rectangle2D2 = jGraph.getCellBounds(objectArray[i]);
                                    if (rectangle2D2 == null) {
                                        rectangle2D2 = GraphConstants.getBounds(graphModel.getAttributes(objectArray[i]));
                                    }
                                    if (rectangle2D2 != null) {
                                        rectangle2D2 = (Rectangle2D)rectangle2D2.clone();
                                    }
                                    Hashtable hashtable3 = new Hashtable();
                                    Object object2 = graphModel.getParent(objectArray[i]);
                                    if (rectangle2D2 == null) {
                                        rectangle2D2 = new Rectangle2D.Double(point.getX(), point.getY(), d / 2.0, d);
                                        GraphConstants.setResize(hashtable3, true);
                                        point.setLocation(point.getX() + d, point.getY() + d);
                                        jGraph.snap(point);
                                    } else if (object2 == null || !hashtable.keySet().contains(graphModel.getParent(objectArray[i]))) {
                                        CellView cellView = jGraph.getGraphLayoutCache().getMapping(objectArray[i], false);
                                        if (cellView != null && !cellView.isLeaf()) {
                                            double d4 = point.getX() - rectangle2D2.getX();
                                            double d5 = point.getY() - rectangle2D2.getY();
                                            GraphLayoutCache.translateViews(new CellView[]{cellView}, d4, d5);
                                        } else {
                                            rectangle2D2.setFrame(point.getX(), point.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                                        }
                                        point.setLocation(point.getX() + d, point.getY() + d);
                                        jGraph.snap(point);
                                    }
                                    GraphConstants.setBounds(hashtable3, rectangle2D2);
                                    hashtable.put(objectArray[i], hashtable3);
                                    continue;
                                }
                                hashtable.put(objectArray[i], hashtable2);
                            }
                        }
                        graphLayoutCache.edit(hashtable, null, null, null);
                    }
                    jGraph.setSelectionCells(DefaultGraphModel.getTopmostCells(graphModel, objectArray));
                    return false;
                }
                return this.importDataImpl(jComponent, transferable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    protected void handleExternalDrop(JGraph jGraph, Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, double d, double d2) {
        Object object;
        Iterator iterator = connectionSet.connections();
        while (iterator.hasNext()) {
            object = (ConnectionSet.Connection)iterator.next();
            if (parentMap.getChangedNodes().contains(((ConnectionSet.Connection)object).getPort()) || jGraph.getModel().contains(((ConnectionSet.Connection)object).getPort())) continue;
            iterator.remove();
        }
        object = jGraph.cloneCells(objectArray);
        jGraph.getGraphLayoutCache().insertClones(objectArray, (Map)object, map, connectionSet, parentMap, d, d2);
    }

    protected boolean importDataImpl(JComponent jComponent, Transferable transferable) {
        return false;
    }
}

