import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import cz.autel.dmi.*;
import javax.swing.border.*;

/*
 * Example for using HIGLayout.
 * @author dmi@autel.cz
 */
public class HIGExample1 extends JFrame {
	ActionListener demo1Action = new ActionListener() {
		public void actionPerformed(ActionEvent ev) {
			Demo2Dialog f = new Demo2Dialog();
			f.pack();
			f.setVisible(true);				
		}
	};
	ActionListener demo2Action = new ActionListener() {
		public void actionPerformed(ActionEvent ev) {
			Demo1Dialog f = new Demo1Dialog(false);
			f.pack();
			f.setVisible(true);				
		}
	};
	ActionListener demo3Action = new ActionListener() {
		public void actionPerformed(ActionEvent ev) {
			Demo1Dialog f = new Demo1Dialog(true);
			f.pack();
			f.setVisible(true);				
		}
	};
	ActionListener exitAction = new ActionListener() {
		public void actionPerformed(ActionEvent ev) {
			exit();
		}
	};
	static void exit() {
		System.out.println("Thank You for using HIGLayout. Send comments to Daniel Michalik (dmi@autel.cz)");
		System.exit(0);		
	}
	HIGExample1() {
		JPanel p = new JPanel();
		int widths[] = {12,0,11,0,11};
		int heights[] = {12,0,11,0,11,0,23,0,11};

		HIGLayout l = new HIGLayout(widths, heights);
		l.setRowWeight(7,1);
		l.setColumnWeight(3,1);
		HIGConstraints c = new HIGConstraints();
		p.setLayout(l);
		JButton demo1Btn = new JButton("Show");
		demo1Btn.addActionListener(demo1Action);
		JButton demo2Btn = new JButton("Show");
		demo2Btn.addActionListener(demo2Action);
		JButton demo3Btn = new JButton("Show");
		demo3Btn.addActionListener(demo3Action);
		JButton exitBtn = new JButton("Exit");		
		exitBtn.addActionListener(exitAction);
		p.add(new JLabel("Simple dialog box with JLabel, JTextArea and 3 JButtons."), c.rc(2,2));
		p.add(demo1Btn, c.rc(2,4,"lr"));
		p.add(new JLabel("Dialog box with JCheckBoxes, JRadioButtons and JComboBoxes."), c.rc(4,2));
		p.add(demo2Btn, c.rc(4,4,"lr"));
		p.add(new JLabel("The same dialog box with corrections applied."), c.rc(6,2));		
		p.add(demo3Btn, c.rc(6,4,"lr"));
		p.add(exitBtn, c.rc(8,4));
		getContentPane().add(p,BorderLayout.CENTER);
	} 
	
	public static void main(String args[]) {
		HIGExample1 f = new HIGExample1();
//		Demo1Dialog f = new Demo1Dialog(false);
//		Demo2Dialog f = new Demo2Dialog();
		f.pack();
		f.setVisible(true);
		f.addWindowListener( new WindowAdapter() {
			public void windowClosing(WindowEvent ev) {
				exit();
			} } );
	}

}
