/* smartkeyfile.c generated by valac 0.14.2, the Vala compiler
 * generated from smartkeyfile.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 **/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <config.h>


#define FSO_FRAMEWORK_TYPE_SMART_KEY_FILE (fso_framework_smart_key_file_get_type ())
#define FSO_FRAMEWORK_SMART_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFile))
#define FSO_FRAMEWORK_SMART_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFileClass))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE))
#define FSO_FRAMEWORK_SMART_KEY_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFileClass))

typedef struct _FsoFrameworkSmartKeyFile FsoFrameworkSmartKeyFile;
typedef struct _FsoFrameworkSmartKeyFileClass FsoFrameworkSmartKeyFileClass;
typedef struct _FsoFrameworkSmartKeyFilePrivate FsoFrameworkSmartKeyFilePrivate;
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION (fso_framework_smart_key_file_section_get_type ())
#define FSO_FRAMEWORK_SMART_KEY_FILE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION, FsoFrameworkSmartKeyFileSection))
#define FSO_FRAMEWORK_SMART_KEY_FILE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION, FsoFrameworkSmartKeyFileSectionClass))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION))
#define FSO_FRAMEWORK_IS_SMART_KEY_FILE_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION))
#define FSO_FRAMEWORK_SMART_KEY_FILE_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION, FsoFrameworkSmartKeyFileSectionClass))

typedef struct _FsoFrameworkSmartKeyFileSection FsoFrameworkSmartKeyFileSection;
typedef struct _FsoFrameworkSmartKeyFileSectionClass FsoFrameworkSmartKeyFileSectionClass;
typedef struct _FsoFrameworkSmartKeyFileSectionPrivate FsoFrameworkSmartKeyFileSectionPrivate;

struct _FsoFrameworkSmartKeyFile {
	GObject parent_instance;
	FsoFrameworkSmartKeyFilePrivate * priv;
};

struct _FsoFrameworkSmartKeyFileClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkSmartKeyFilePrivate {
	GKeyFile* kf;
	gboolean loaded;
	gchar* filename;
};

struct _FsoFrameworkSmartKeyFileSection {
	GObject parent_instance;
	FsoFrameworkSmartKeyFileSectionPrivate * priv;
};

struct _FsoFrameworkSmartKeyFileSectionClass {
	GObjectClass parent_class;
};

struct _FsoFrameworkSmartKeyFileSectionPrivate {
	FsoFrameworkSmartKeyFile* kf;
	gchar* section;
};


static gpointer fso_framework_smart_key_file_parent_class = NULL;
static GHashTable* fso_framework_smart_key_file_instances;
static GHashTable* fso_framework_smart_key_file_instances = NULL;
static gchar** fso_framework_smart_key_file_location_prefix;
static gint fso_framework_smart_key_file_location_prefix_length1;
static gchar** fso_framework_smart_key_file_location_prefix = NULL;
static gint fso_framework_smart_key_file_location_prefix_length1 = 0;
static gint _fso_framework_smart_key_file_location_prefix_size_ = 0;
static gpointer fso_framework_smart_key_file_section_parent_class = NULL;

GType fso_framework_smart_key_file_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_SMART_KEY_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE, FsoFrameworkSmartKeyFilePrivate))
enum  {
	FSO_FRAMEWORK_SMART_KEY_FILE_DUMMY_PROPERTY
};
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_new (void);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_construct (GType object_type);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_defaultKeyFile (void);
FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_createFromConfig (const gchar* filename);
gchar* fso_framework_utility_programName (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
gboolean fso_framework_file_handling_isPresent (const gchar* filename);
gboolean fso_framework_smart_key_file_loadFromFile (FsoFrameworkSmartKeyFile* self, const gchar* filename);
gchar* fso_framework_smart_key_file_stringValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, const gchar* defaultvalue);
gdouble fso_framework_smart_key_file_doubleValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gdouble defaultvalue);
gint fso_framework_smart_key_file_intValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gint defaultvalue);
gboolean fso_framework_smart_key_file_boolValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gboolean defaultvalue);
gchar** fso_framework_smart_key_file_stringListValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gchar** defaultvalue, int defaultvalue_length1, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gboolean fso_framework_smart_key_file_hasSection (FsoFrameworkSmartKeyFile* self, const gchar* section);
GList* fso_framework_smart_key_file_sectionsWithPrefix (FsoFrameworkSmartKeyFile* self, const gchar* prefix);
static void _g_list_free__g_free0_ (GList* self);
gboolean fso_framework_smart_key_file_hasKey (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key);
GList* fso_framework_smart_key_file_keysWithPrefix (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* prefix);
void fso_framework_smart_key_file_write (FsoFrameworkSmartKeyFile* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* section, const gchar* key, gconstpointer value);
static void fso_framework_smart_key_file_markDirty (FsoFrameworkSmartKeyFile* self);
void fso_framework_file_handling_write (const gchar* contents, const gchar* filename, gboolean create);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
gchar* fso_framework_utility_machineConfigurationDir (void);
static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void fso_framework_smart_key_file_finalize (GObject* obj);
GType fso_framework_smart_key_file_section_get_type (void) G_GNUC_CONST;
#define FSO_FRAMEWORK_SMART_KEY_FILE_SECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION, FsoFrameworkSmartKeyFileSectionPrivate))
enum  {
	FSO_FRAMEWORK_SMART_KEY_FILE_SECTION_DUMMY_PROPERTY
};
static FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_new (FsoFrameworkSmartKeyFile* kf, const gchar* section);
static FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_construct (GType object_type, FsoFrameworkSmartKeyFile* kf, const gchar* section);
FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_openSection (FsoFrameworkSmartKeyFile* kf, const gchar* section);
static void fso_framework_smart_key_file_section_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_construct (GType object_type) {
	FsoFrameworkSmartKeyFile * self = NULL;
	GKeyFile* _tmp0_;
	self = (FsoFrameworkSmartKeyFile*) g_object_new (object_type, NULL);
	_tmp0_ = g_key_file_new ();
	_g_key_file_free0 (self->priv->kf);
	self->priv->kf = _tmp0_;
	return self;
}


FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_new (void) {
	return fso_framework_smart_key_file_construct (FSO_FRAMEWORK_TYPE_SMART_KEY_FILE);
}


FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_defaultKeyFile (void) {
	FsoFrameworkSmartKeyFile* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	FsoFrameworkSmartKeyFile* _tmp2_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp3_;
	_tmp0_ = fso_framework_utility_programName ();
	_tmp1_ = _tmp0_;
	_tmp2_ = fso_framework_smart_key_file_createFromConfig (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


/**
     * Load keyfile into memory, searching in several well-known locations.
     *
     * @returns key file, if found. null, otherwise.
     **/
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


FsoFrameworkSmartKeyFile* fso_framework_smart_key_file_createFromConfig (const gchar* filename) {
	FsoFrameworkSmartKeyFile* result = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_ = NULL;
	FsoFrameworkSmartKeyFile* _tmp7_;
	FsoFrameworkSmartKeyFile* smk;
	FsoFrameworkSmartKeyFile* _tmp8_;
	FsoFrameworkSmartKeyFile* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GHashTable* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	FsoFrameworkSmartKeyFile* _tmp32_;
	FsoFrameworkSmartKeyFile* _tmp33_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = fso_framework_smart_key_file_instances;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (fso_framework_smart_key_file_instances);
		fso_framework_smart_key_file_instances = _tmp3_;
	}
	_tmp4_ = fso_framework_smart_key_file_instances;
	_tmp5_ = filename;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((FsoFrameworkSmartKeyFile*) _tmp6_);
	smk = _tmp7_;
	_tmp8_ = smk;
	if (_tmp8_ != NULL) {
		result = smk;
		return result;
	}
	_tmp9_ = fso_framework_smart_key_file_new ();
	_g_object_unref0 (smk);
	smk = _tmp9_;
	_tmp10_ = fso_framework_smart_key_file_location_prefix;
	_tmp10__length1 = fso_framework_smart_key_file_location_prefix_length1;
	{
		gchar** prefix_collection = NULL;
		gint prefix_collection_length1 = 0;
		gint _prefix_collection_size_ = 0;
		gint prefix_it = 0;
		prefix_collection = _tmp10_;
		prefix_collection_length1 = _tmp10__length1;
		for (prefix_it = 0; prefix_it < _tmp10__length1; prefix_it = prefix_it + 1) {
			gchar* _tmp11_;
			gchar* prefix = NULL;
			_tmp11_ = g_strdup (prefix_collection[prefix_it]);
			prefix = _tmp11_;
			{
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* location;
				const gchar* _tmp19_;
				gboolean _tmp20_ = FALSE;
				FsoFrameworkSmartKeyFile* _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				_tmp12_ = prefix;
				_tmp13_ = filename;
				_tmp14_ = string_to_string (_tmp13_);
				_tmp15_ = g_strconcat (_tmp14_, ".conf", NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_build_filename (_tmp12_, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				_g_free0 (_tmp16_);
				location = _tmp18_;
				_tmp19_ = location;
				_tmp20_ = fso_framework_file_handling_isPresent (_tmp19_);
				if (!_tmp20_) {
					_g_free0 (location);
					_g_free0 (prefix);
					continue;
				}
				_tmp21_ = smk;
				_tmp22_ = location;
				_tmp23_ = fso_framework_smart_key_file_loadFromFile (_tmp21_, _tmp22_);
				if (_tmp23_) {
					GHashTable* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					FsoFrameworkSmartKeyFile* _tmp27_;
					FsoFrameworkSmartKeyFile* _tmp28_;
					_tmp24_ = fso_framework_smart_key_file_instances;
					_tmp25_ = filename;
					_tmp26_ = g_strdup (_tmp25_);
					_tmp27_ = smk;
					_tmp28_ = _g_object_ref0 (_tmp27_);
					g_hash_table_insert (_tmp24_, _tmp26_, _tmp28_);
					result = smk;
					_g_free0 (location);
					_g_free0 (prefix);
					return result;
				}
				_g_free0 (location);
				_g_free0 (prefix);
			}
		}
	}
	_tmp29_ = fso_framework_smart_key_file_instances;
	_tmp30_ = filename;
	_tmp31_ = g_strdup (_tmp30_);
	_tmp32_ = smk;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	g_hash_table_insert (_tmp29_, _tmp31_, _tmp33_);
	result = smk;
	return result;
}


/**
     * Load keyfile into memory.
     *
     * @returns true, if successful. false, otherwise.
     */
gboolean fso_framework_smart_key_file_loadFromFile (FsoFrameworkSmartKeyFile* self, const gchar* filename) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp1_ = self->priv->loaded;
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = filename;
		_tmp3_ = self->priv->filename;
		_tmp0_ = g_strcmp0 (_tmp2_, _tmp3_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		g_error ("smartkeyfile.vala:116: %s", "Can't load keyfile from different file after once loaded");
	}
	_tmp5_ = filename;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp6_;
	{
		GKeyFile* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->priv->kf;
		_tmp8_ = filename;
		g_key_file_load_from_file (_tmp7_, _tmp8_, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	self->priv->loaded = TRUE;
	result = TRUE;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


gchar* fso_framework_smart_key_file_stringValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, const gchar* defaultvalue) {
	gchar* result = NULL;
	gchar* value = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (defaultvalue != NULL, NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_string (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch9_g_key_file_error;
			}
			_g_free0 (value);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (value);
		value = _tmp4_;
	}
	goto __finally9;
	__catch9_g_key_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = defaultvalue;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (value);
		value = _tmp6_;
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (value);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp7_ = value;
	_tmp8_ = string_strip (_tmp7_);
	result = _tmp8_;
	_g_free0 (value);
	return result;
}


gdouble fso_framework_smart_key_file_doubleValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gdouble defaultvalue) {
	gdouble result = 0.0;
	gdouble value = 0.0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (section != NULL, 0.0);
	g_return_val_if_fail (key != NULL, 0.0);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_double (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch10_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0.0;
		}
		value = _tmp4_;
	}
	goto __finally10;
	__catch10_g_key_file_error:
	{
		GError* e = NULL;
		gdouble _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = defaultvalue;
		value = _tmp5_;
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0.0;
	}
	result = value;
	return result;
}


gint fso_framework_smart_key_file_intValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gint defaultvalue) {
	gint result = 0;
	gint value = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (section != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		gint _tmp4_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_integer (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch11_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		value = _tmp4_;
	}
	goto __finally11;
	__catch11_g_key_file_error:
	{
		GError* e = NULL;
		gint _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = defaultvalue;
		value = _tmp5_;
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = value;
	return result;
}


gboolean fso_framework_smart_key_file_boolValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gboolean defaultvalue) {
	gboolean result = FALSE;
	gboolean value = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = g_key_file_get_boolean (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch12_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		value = _tmp4_;
	}
	goto __finally12;
	__catch12_g_key_file_error:
	{
		GError* e = NULL;
		gboolean _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = defaultvalue;
		value = _tmp5_;
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = value;
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gchar** fso_framework_smart_key_file_stringListValue (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key, gchar** defaultvalue, int defaultvalue_length1, int* result_length1) {
	gchar** result = NULL;
	gchar** value = NULL;
	gint value_length1 = 0;
	gint _value_size_ = 0;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gsize _tmp3_;
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gint __tmp5__size_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp4_ = g_key_file_get_string_list (_tmp0_, _tmp1_, _tmp2_, &_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp3_;
		__tmp5__size_ = _tmp5__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch13_g_key_file_error;
			}
			value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
		value = _tmp5_;
		value_length1 = _tmp5__length1;
		_value_size_ = value_length1;
	}
	goto __finally13;
	__catch13_g_key_file_error:
	{
		GError* e = NULL;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar** _tmp7_;
		gint _tmp7__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = defaultvalue;
		_tmp6__length1 = defaultvalue_length1;
		_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup8 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
		_tmp7__length1 = _tmp6__length1;
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
		value = _tmp7_;
		value_length1 = _tmp7__length1;
		_value_size_ = value_length1;
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = value;
	_tmp8__length1 = value_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}


gboolean fso_framework_smart_key_file_hasSection (FsoFrameworkSmartKeyFile* self, const gchar* section) {
	gboolean result = FALSE;
	GKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (section != NULL, FALSE);
	_tmp0_ = self->priv->kf;
	_tmp1_ = section;
	_tmp2_ = g_key_file_has_group (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


GList* fso_framework_smart_key_file_sectionsWithPrefix (FsoFrameworkSmartKeyFile* self, const gchar* prefix) {
	GList* result = NULL;
	GList* list;
	GKeyFile* _tmp0_;
	gsize _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** groups;
	gint groups_length1;
	gint _groups_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	_tmp0_ = self->priv->kf;
	_tmp2_ = g_key_file_get_groups (_tmp0_, &_tmp1_);
	groups = _tmp2_;
	groups_length1 = _tmp1_;
	_groups_size_ = groups_length1;
	_tmp3_ = groups;
	_tmp3__length1 = groups_length1;
	{
		gchar** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp3_;
		group_collection_length1 = _tmp3__length1;
		for (group_it = 0; group_it < _tmp3__length1; group_it = group_it + 1) {
			gchar* _tmp4_;
			gchar* group = NULL;
			_tmp4_ = g_strdup (group_collection[group_it]);
			group = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = prefix;
				if (_tmp5_ == NULL) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = group;
					_tmp7_ = g_strdup (_tmp6_);
					list = g_list_append (list, _tmp7_);
				} else {
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp8_ = group;
					_tmp9_ = prefix;
					_tmp10_ = g_str_has_prefix (_tmp8_, _tmp9_);
					if (_tmp10_) {
						const gchar* _tmp11_;
						gchar* _tmp12_;
						_tmp11_ = group;
						_tmp12_ = g_strdup (_tmp11_);
						list = g_list_append (list, _tmp12_);
					}
				}
				_g_free0 (group);
			}
		}
	}
	result = list;
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean fso_framework_smart_key_file_hasKey (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* key) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (section != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = g_key_file_has_key (_tmp0_, _tmp1_, _tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch14_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		result = _tmp4_;
		return result;
	}
	goto __finally14;
	__catch14_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally14:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return FALSE;
}


GList* fso_framework_smart_key_file_keysWithPrefix (FsoFrameworkSmartKeyFile* self, const gchar* section, const gchar* prefix) {
	GList* result = NULL;
	GList* list;
	gchar** keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (section != NULL, NULL);
	list = NULL;
	{
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		gsize _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint __tmp4__size_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp3_ = g_key_file_get_keys (_tmp0_, _tmp1_, &_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp2_;
		__tmp4__size_ = _tmp4__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch15_g_key_file_error;
			}
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free__g_free0_0 (list);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		keys = _tmp4_;
		keys_length1 = _tmp4__length1;
		_keys_size_ = keys_length1;
	}
	goto __finally15;
	__catch15_g_key_file_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = list;
		_g_error_free0 (e);
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally15:
	if (_inner_error_ != NULL) {
		keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		__g_list_free__g_free0_0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = keys;
	_tmp5__length1 = keys_length1;
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp5_;
		key_collection_length1 = _tmp5__length1;
		for (key_it = 0; key_it < _tmp5__length1; key_it = key_it + 1) {
			gchar* _tmp6_;
			gchar* key = NULL;
			_tmp6_ = g_strdup (key_collection[key_it]);
			key = _tmp6_;
			{
				const gchar* _tmp7_;
				_tmp7_ = prefix;
				if (_tmp7_ == NULL) {
					const gchar* _tmp8_;
					gchar* _tmp9_;
					_tmp8_ = key;
					_tmp9_ = g_strdup (_tmp8_);
					list = g_list_append (list, _tmp9_);
				} else {
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					_tmp10_ = key;
					_tmp11_ = prefix;
					_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
					if (_tmp12_) {
						const gchar* _tmp13_;
						gchar* _tmp14_;
						_tmp13_ = key;
						_tmp14_ = g_strdup (_tmp13_);
						list = g_list_append (list, _tmp14_);
					}
				}
				_g_free0 (key);
			}
		}
	}
	result = list;
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void fso_framework_smart_key_file_write (FsoFrameworkSmartKeyFile* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* section, const gchar* key, gconstpointer value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	if (t_type == G_TYPE_INT) {
		GKeyFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gconstpointer _tmp3_;
		_tmp0_ = self->priv->kf;
		_tmp1_ = section;
		_tmp2_ = key;
		_tmp3_ = value;
		g_key_file_set_integer (_tmp0_, _tmp1_, _tmp2_, (gint) _tmp3_);
		fso_framework_smart_key_file_markDirty (self);
	} else {
		if (t_type == G_TYPE_STRING) {
			GKeyFile* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gconstpointer _tmp7_;
			_tmp4_ = self->priv->kf;
			_tmp5_ = section;
			_tmp6_ = key;
			_tmp7_ = value;
			g_key_file_set_string (_tmp4_, _tmp5_, _tmp6_, (const gchar*) _tmp7_);
			fso_framework_smart_key_file_markDirty (self);
		} else {
			g_assert_not_reached ();
		}
	}
}


static void fso_framework_smart_key_file_markDirty (FsoFrameworkSmartKeyFile* self) {
	GKeyFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->kf;
	_tmp1_ = g_key_file_to_data (_tmp0_, NULL, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->filename;
	fso_framework_file_handling_write (_tmp2_, _tmp3_, TRUE);
	_g_free0 (_tmp2_);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void fso_framework_smart_key_file_class_init (FsoFrameworkSmartKeyFileClass * klass) {
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar* _tmp11_ = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_ = NULL;
	fso_framework_smart_key_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkSmartKeyFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = fso_framework_smart_key_file_finalize;
	_tmp0_ = fso_framework_smart_key_file_location_prefix;
	_tmp0__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp1_ = g_strdup ("./");
	_vala_array_add1 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp1_);
	_tmp2_ = fso_framework_smart_key_file_location_prefix;
	_tmp2__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp3_ = g_get_home_dir ();
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat (_tmp4_, "/.", NULL);
	_vala_array_add2 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp5_);
	_tmp6_ = fso_framework_smart_key_file_location_prefix;
	_tmp6__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp7_ = g_strdup (SYSCONFDIR);
	_vala_array_add3 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp7_);
	_tmp8_ = fso_framework_smart_key_file_location_prefix;
	_tmp8__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp9_ = g_build_filename ("freesmartphone", NULL);
	_vala_array_add4 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp9_);
	_tmp10_ = fso_framework_smart_key_file_location_prefix;
	_tmp10__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp11_ = fso_framework_utility_machineConfigurationDir ();
	_vala_array_add5 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp11_);
	_tmp12_ = fso_framework_smart_key_file_location_prefix;
	_tmp12__length1 = fso_framework_smart_key_file_location_prefix_length1;
	_tmp13_ = g_build_filename (SYSCONFDIR, "freesmartphone", "conf", "default", NULL);
	_vala_array_add6 (&fso_framework_smart_key_file_location_prefix, &fso_framework_smart_key_file_location_prefix_length1, &_fso_framework_smart_key_file_location_prefix_size_, _tmp13_);
}


static void fso_framework_smart_key_file_instance_init (FsoFrameworkSmartKeyFile * self) {
	self->priv = FSO_FRAMEWORK_SMART_KEY_FILE_GET_PRIVATE (self);
	self->priv->kf = NULL;
	self->priv->loaded = FALSE;
}


static void fso_framework_smart_key_file_finalize (GObject* obj) {
	FsoFrameworkSmartKeyFile * self;
	self = FSO_FRAMEWORK_SMART_KEY_FILE (obj);
	_g_key_file_free0 (self->priv->kf);
	_g_free0 (self->priv->filename);
	G_OBJECT_CLASS (fso_framework_smart_key_file_parent_class)->finalize (obj);
}


/**
 * SmartKeyFile
 */
GType fso_framework_smart_key_file_get_type (void) {
	static volatile gsize fso_framework_smart_key_file_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_smart_key_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkSmartKeyFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_smart_key_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkSmartKeyFile), 0, (GInstanceInitFunc) fso_framework_smart_key_file_instance_init, NULL };
		GType fso_framework_smart_key_file_type_id;
		fso_framework_smart_key_file_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkSmartKeyFile", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_smart_key_file_type_id__volatile, fso_framework_smart_key_file_type_id);
	}
	return fso_framework_smart_key_file_type_id__volatile;
}


static FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_construct (GType object_type, FsoFrameworkSmartKeyFile* kf, const gchar* section) {
	FsoFrameworkSmartKeyFileSection * self = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (section != NULL, NULL);
	self = (FsoFrameworkSmartKeyFileSection*) g_object_new (object_type, NULL);
	_tmp0_ = kf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->kf);
	self->priv->kf = _tmp1_;
	_tmp2_ = section;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->section);
	self->priv->section = _tmp3_;
	return self;
}


static FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_new (FsoFrameworkSmartKeyFile* kf, const gchar* section) {
	return fso_framework_smart_key_file_section_construct (FSO_FRAMEWORK_TYPE_SMART_KEY_FILE_SECTION, kf, section);
}


FsoFrameworkSmartKeyFileSection* fso_framework_smart_key_file_section_openSection (FsoFrameworkSmartKeyFile* kf, const gchar* section) {
	FsoFrameworkSmartKeyFileSection* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (section != NULL, NULL);
	_tmp0_ = kf;
	_tmp1_ = section;
	_tmp2_ = fso_framework_smart_key_file_hasSection (_tmp0_, _tmp1_);
	if (_tmp2_) {
		FsoFrameworkSmartKeyFile* _tmp3_;
		const gchar* _tmp4_;
		FsoFrameworkSmartKeyFileSection* _tmp5_;
		_tmp3_ = kf;
		_tmp4_ = section;
		_tmp5_ = fso_framework_smart_key_file_section_new (_tmp3_, _tmp4_);
		result = _tmp5_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static void fso_framework_smart_key_file_section_class_init (FsoFrameworkSmartKeyFileSectionClass * klass) {
	fso_framework_smart_key_file_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FsoFrameworkSmartKeyFileSectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = fso_framework_smart_key_file_section_finalize;
}


static void fso_framework_smart_key_file_section_instance_init (FsoFrameworkSmartKeyFileSection * self) {
	self->priv = FSO_FRAMEWORK_SMART_KEY_FILE_SECTION_GET_PRIVATE (self);
}


static void fso_framework_smart_key_file_section_finalize (GObject* obj) {
	FsoFrameworkSmartKeyFileSection * self;
	self = FSO_FRAMEWORK_SMART_KEY_FILE_SECTION (obj);
	_g_object_unref0 (self->priv->kf);
	_g_free0 (self->priv->section);
	G_OBJECT_CLASS (fso_framework_smart_key_file_section_parent_class)->finalize (obj);
}


/**
 * SmartKeyFileSection
 */
GType fso_framework_smart_key_file_section_get_type (void) {
	static volatile gsize fso_framework_smart_key_file_section_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_smart_key_file_section_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkSmartKeyFileSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_smart_key_file_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkSmartKeyFileSection), 0, (GInstanceInitFunc) fso_framework_smart_key_file_section_instance_init, NULL };
		GType fso_framework_smart_key_file_section_type_id;
		fso_framework_smart_key_file_section_type_id = g_type_register_static (G_TYPE_OBJECT, "FsoFrameworkSmartKeyFileSection", &g_define_type_info, 0);
		g_once_init_leave (&fso_framework_smart_key_file_section_type_id__volatile, fso_framework_smart_key_file_section_type_id);
	}
	return fso_framework_smart_key_file_section_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



