/* -*- C++ -*-
 * Copyright (C) 2005,2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/cache/tag.h>
#include <ept/cache/debtags/vocabulary.h>
#include <stdexcept>

#ifndef EPT_CACHE_DEBTAGS_TAG_TCC
#define EPT_CACHE_DEBTAGS_TAG_TCC

namespace ept {
namespace t {
namespace cache {

static inline std::string constget(const std::map<std::string, std::string>& m,
                                   const std::string& key)
{
    std::map<std::string, std::string>::const_iterator i = m.find(key);
	if (i == m.end())
		return std::string();
	else
		return i->second;
}

template<typename C>
std::string Facet<C>::name() const
{
	if (valid())
		return m_tags->facetName(m_id);
	throw std::out_of_range( "No name for this facet" );
}
template<typename C>
std::string Facet<C>::name(const std::string& d) const
{
	return valid() ? m_tags->facetName(m_id) : d;
}

template<typename C>
std::string Facet<C>::shortDescription() const
{
	if (valid())
		return constget(m_tags->facetData(m_id), "_SD_");
	throw std::out_of_range( "No short description for this facet" );
}
template<typename C>
std::string Facet<C>::shortDescription(const std::string& d) const
{
	return valid() ? constget(m_tags->facetData(m_id), "_SD_") : d;
}

template<typename C>
std::string Facet<C>::longDescription() const
{
	if (valid())
		return constget(m_tags->facetData(m_id), "Description");
	throw std::out_of_range( "No long description for this facet" );
}
template<typename C>
std::string Facet<C>::longDescription(const std::string& d) const
{
	return valid() ? constget(m_tags->facetData(m_id), "Description") : d;
}

template<typename C>
bool Facet<C>::hasTag(const std::string& name) const
{
	if (!valid())
		throw std::out_of_range( "hasTag() called on an invalid facet" );
	return m_tags->hasTag(this->name() + "::" + name);
}

template<typename C>
std::set< Tag<C> > Facet<C>::tags() const
{
	if (!valid())
		throw std::out_of_range( "tags() called on an invalid facet" );
	return m_tags->tags(m_id);
}


template<typename C>
Facet<C> Tag<C>::facet() const
{
	if (valid())
		return m_tags->facetByTag(m_id);
	throw std::out_of_range( "No facet for this tag" );
}

template<typename C>
std::string Tag<C>::name() const
{
	if (valid())
		return m_tags->tagShortName(m_id);
	throw std::out_of_range( "No name for this tag" );
}
template<typename C>
std::string Tag<C>::name(const std::string& d) const
{
	return valid() ? m_tags->tagShortName(m_id) : d;
}

template<typename C>
std::string Tag<C>::fullname() const
{
	if (valid())
		return m_tags->tagName(m_id);
	throw std::out_of_range( "No full name for this facet" );
}
template<typename C>
std::string Tag<C>::fullname(const std::string& d) const
{
	return valid() ? m_tags->tagName(m_id) : d;
}

template<typename C>
std::string Tag<C>::shortDescription() const
{
	if (valid())
		return constget(m_tags->tagData(m_id), "_SD_");
	throw std::out_of_range( "No short description for this tag" );
}
template<typename C>
std::string Tag<C>::shortDescription(const std::string& d) const
{
	return valid() ? constget(m_tags->tagData(m_id), "_SD_") : d;
}

template<typename C>
std::string Tag<C>::longDescription() const
{
	if (valid())
		return constget(m_tags->tagData(m_id), "Description");
	throw std::out_of_range( "No long description for this tag" );
}
template<typename C>
std::string Tag<C>::longDescription(const std::string& d) const
{
	return valid() ? constget(m_tags->tagData(m_id), "Description") : d;
}

}
}
}

#endif

// vim:set ts=3 sw=3:
