/*

    Decimation class
    Copyright (C) 2000-2001 Jussi Laako

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>

#include "dsp/Decimator.hh"

/*#include "Dec2Filter.h"
#include "Dec4Filter.h"
#include "Dec8Filter.h"*/
#include "Dec2Filter2.h"
#include "Dec4Filter2.h"
#include "Dec8Filter2.h"
/*#include "Dec2Filter3.h"
#include "Dec4Filter3.h"
#include "Dec8Filter3.h"*/


clDecimator::clDecimator ()
{
    lBufferSize = 0l;
    fpDecBuf = NULL;
    dpDecBuf = NULL;
}


clDecimator::~clDecimator ()
{
    Uninitialize();
}


bool clDecimator::Initialize (long lDecFact, long lNewBufSize, 
    const float *fpNullPtr)
{
    long lRemFact;
    
    lSubRounds = 0l;
    lRemFact = lDecFact;
    do {
        if ((lRemFact / 8l) >= 1l) lpSubFactors[lSubRounds] = 8l;
        else if ((lRemFact / 4l) >= 1l) lpSubFactors[lSubRounds] = 4l;
        else lpSubFactors[lSubRounds] = 2l;
        lRemFact /= lpSubFactors[lSubRounds];
        switch (lpSubFactors[lSubRounds])
        {
            case 2l:
                fpGains[lSubRounds] = fDec2FilterGain;
                FIRBank[lSubRounds].FIRAllocate(fpDec2FilterCoeffs, 
                    lDec2FilterLen);
                break;
            case 4l:
                fpGains[lSubRounds] = fDec4FilterGain;
                FIRBank[lSubRounds].FIRAllocate(fpDec4FilterCoeffs,
                    lDec4FilterLen);
                break;
            case 8l:
                fpGains[lSubRounds] = fDec8FilterGain;
                FIRBank[lSubRounds].FIRAllocate(fpDec8FilterCoeffs,
                    lDec8FilterLen);
                break;
        }
        lSubRounds++;
    } while (lRemFact > 1l && lSubRounds < DEC_MAX_SUB_ROUNDS);
    if (lRemFact > 1l && lSubRounds == DEC_MAX_SUB_ROUNDS) return false;
    if (lNewBufSize != lBufferSize)
    {
        lBufferSize = lNewBufSize;
        dpDecBuf = NULL;
        fpDecBuf = (float *) DecBuf.Size(lBufferSize * sizeof(float));
    }
    return true;
}


bool clDecimator::Initialize (long lDecFact, long lNewBufSize,
    const double *dpNullPtr)
{
    long lRemFact;

    lSubRounds = 0l;
    lRemFact = lDecFact;
    do {
        if ((lRemFact / 8l) >= 1l) lpSubFactors[lSubRounds] = 8l;
        else if ((lRemFact / 4l) >= 1l) lpSubFactors[lSubRounds] = 4l;
        else lpSubFactors[lSubRounds] = 2l;
        lRemFact /= lpSubFactors[lSubRounds];
        switch (lpSubFactors[lSubRounds])
        {
            case 2l:
                dpGains[lSubRounds] = dDec2FilterGain;
                FIRBank[lSubRounds].FIRAllocate(dpDec2FilterCoeffs,
                    lDec2FilterLen);
                break;
            case 4l:
                dpGains[lSubRounds] = dDec4FilterGain;
                FIRBank[lSubRounds].FIRAllocate(dpDec4FilterCoeffs,
                    lDec4FilterLen);
                break;
            case 8l:
                dpGains[lSubRounds] = dDec8FilterGain;
                FIRBank[lSubRounds].FIRAllocate(dpDec8FilterCoeffs,
                    lDec8FilterLen);
                break;
        }
        lSubRounds++;
    } while (lRemFact > 1l && lSubRounds < DEC_MAX_SUB_ROUNDS);
    if (lRemFact > 1l && lSubRounds == DEC_MAX_SUB_ROUNDS) return false;
    if (lNewBufSize != lBufferSize)
    {
        lBufferSize = lNewBufSize;
        fpDecBuf = NULL;
        dpDecBuf = (double *) DecBuf.Size(lBufferSize * sizeof(double));
    }
    return true;
}


void clDecimator::Uninitialize ()
{
    fpDecBuf = NULL;
    dpDecBuf = NULL;
    DecBuf.Free();
}


void clDecimator::Process (float *fpVect)
{
    long lDecCntr;
    long lFactor;
    long lSampleCount;

    lFactor = 1l;
    for (lDecCntr = 0l; lDecCntr < lSubRounds; lDecCntr++)
    {
        lSampleCount = lBufferSize / lFactor;
        DSP.Mul(fpVect, fpGains[lDecCntr], lSampleCount);
        FIRBank[lDecCntr].FIRFilter(fpVect, lSampleCount);
        DSP.Decimate(fpVect, fpVect, lpSubFactors[lDecCntr], lSampleCount);
        lFactor *= lpSubFactors[lDecCntr];
    }
}


void clDecimator::Process (double *dpVect)
{
    long lDecCntr;
    long lFactor;
    long lSampleCount;

    lFactor = 1l;
    for (lDecCntr = 0l; lDecCntr < lSubRounds; lDecCntr++)
    {
        lSampleCount = lBufferSize / lFactor;
        DSP.Mul(dpVect, dpGains[lDecCntr], lSampleCount);
        FIRBank[lDecCntr].FIRFilter(dpVect, lSampleCount);
        DSP.Decimate(dpVect, dpVect, lpSubFactors[lDecCntr], lSampleCount);
        lFactor *= lpSubFactors[lDecCntr];
    }
}


void clDecimator::Process (float *fpDest, const float *fpSrc)
{
    long lDecCntr;
    long lFactor;
    long lSampleCount;

    lFactor = 1l;
    DSP.Copy(fpDecBuf, fpSrc, lBufferSize);
    for (lDecCntr = 0l; lDecCntr < lSubRounds; lDecCntr++)
    {
        lSampleCount = lBufferSize / lFactor;
        DSP.Mul(fpDecBuf, fpGains[lDecCntr], lSampleCount);
        FIRBank[lDecCntr].FIRFilter(fpDecBuf, lSampleCount);
        DSP.Decimate(fpDecBuf, fpDecBuf, lpSubFactors[lDecCntr], lSampleCount);
        lFactor *= lpSubFactors[lDecCntr];
    }
    DSP.Copy(fpDest, fpDecBuf, lBufferSize / lFactor);
}


void clDecimator::Process (double *dpDest, const double *dpSrc)
{
    long lDecCntr;
    long lFactor;
    long lSampleCount;

    lFactor = 1l;
    DSP.Copy(dpDecBuf, dpSrc, lBufferSize);
    for (lDecCntr = 0l; lDecCntr < lSubRounds; lDecCntr++)
    {
        lSampleCount = lBufferSize / lFactor;
        DSP.Mul(dpDecBuf, dpGains[lDecCntr], lSampleCount);
        FIRBank[lDecCntr].FIRFilter(dpDecBuf, lSampleCount);
        DSP.Decimate(dpDecBuf, dpDecBuf, lpSubFactors[lDecCntr], lSampleCount);
        lFactor *= lpSubFactors[lDecCntr];
    }
    DSP.Copy(dpDest, dpDecBuf, lBufferSize / lFactor);
}

