/***************************************************************************
                          cbytearray.cpp  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002-2004 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <dclib/core/cfile.h>
#include <dclib/core/cdir.h>

#include "cbytearray.h"

/** */
CByteArray::CByteArray( unsigned long nSize )
{
	m_pchBuffer = 0;

	// clear allready called by SetSize
	SetSize(nSize);
}

/** */
CByteArray::~CByteArray()
{
	Clear();
}

/** */
void CByteArray::Clear()
{
	if (m_pchBuffer)
	{
		free(m_pchBuffer);
		m_pchBuffer = 0;	
	}

	m_nSize       = 0;
	m_nBufferSize = 0;
}

/** */
void CByteArray::SetSize( unsigned long nNewSize )
{
	Clear();

	// sanity check	
	if( nNewSize > 0 )
	{
		m_pchBuffer = (unsigned char*)malloc(nNewSize);

		if( m_pchBuffer == 0 )
		{
			printf("CByteArray::SetSize: internal memory error\n");
		}
		else
		{
			m_nSize = m_nBufferSize = nNewSize;
		}
	}
}

/** */
void CByteArray::Append( const unsigned char * pchSrc, unsigned long nSize )
{
	unsigned char *p;

	// sanity check
	if( nSize == 0 )
	{
		printf("CByteArray::Append: len: 0\n");
		return;
	}

	// sanity check
	if( !pchSrc )
	{
		printf("CByteArray::Append: null pointer\n");
		return;
	}

	if ( (m_nSize+nSize) > m_nBufferSize )
	{
		// resize buffer
		m_nBufferSize += nSize + 10000;
		p = (unsigned char*) realloc(m_pchBuffer,m_nBufferSize);

		if( p == 0 )
		{
			m_nBufferSize -= (nSize + 10000);
			printf("CByteArray::Append: fatal error in cbytearray %ld %ld\n",m_nBufferSize,nSize);
			return;
		}

		m_pchBuffer = p;
	}

	// copy mem
	memcpy( m_pchBuffer+m_nSize, pchSrc, nSize );
	// update array size
	m_nSize += nSize;
}

/** */
bool CByteArray::LoadFromFile( CString file )
{
	CFile f;
	CDir d;
	ulonglong filesize;
	bool res = FALSE;

	filesize = d.getFileSize(file,FALSE);

	if ( f.Open( file, IO_RAW | IO_READONLY ) == TRUE )
	{
		SetSize(filesize);

		if ( f.Read( (char*)Data(), Size() ) == filesize )
		{
			res = TRUE;
		}

		f.Close();
	}
	
	return res;
}

/** */
bool CByteArray::SaveToFile( CString file )
{
	CFile f;
	bool res = FALSE;

	if ( f.Open( file, IO_RAW | IO_WRITEONLY | IO_TRUNCATE | IO_CREAT,
			MO_IRUSR | MO_IWUSR ) == TRUE )
	{
		if ( f.Write( (const char*)Data(), Size() ) == Size() )
		{
			res = TRUE;
		}
		
		f.Close();
	}
	
	return res;
}
