use Data::Dumper;
use IO::File;
use File::HomeDir ;

$conf_file_name = '';
$conf_dir       = 'debian/patches';

$model_to_test  = "Dpkg::Patches";

eval { require AptPkg::Config; };
$skip = ( $@ or not -r '/etc/debian_version' ) ? 1 : 0;

@tests = (
    { 
        name => 'debian-748502' ,
        # required to skip the bad patch (non dep-3)
        load_check => 'no',
        load_warnings => [ qr/Ignoring patch/ ],
        check => {
            'patches:tweak-defaults Synopsis' => 'Tweak defaults values for Debian'
        },
        load => 'patches:~mail-like-patch',
        # bad patch is skipped by config-model but is not removed from patch set
        # hence the 2nd instance must also skip the bad patch
        load_check2 => 'no',
    }
);


1;
