/*
 * Copyright 2002,2004 The Apache Software Foundation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.jexl.parser;

import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.util.Coercion;

/**
 *  && and 'and'
 *
 *  @author <a href="mailto:geirm@apache.org">Geir Magnusson Jr.</a>
 *  @version $Id: ASTAndNode.java,v 1.4 2004/08/17 13:20:47 dion Exp $
 */
public class ASTAndNode extends SimpleNode
{
    public ASTAndNode(int id)
    {
        super(id);
    }

    public ASTAndNode(Parser p, int id)
    {
        super(p, id);
    }


    /** Accept the visitor. **/
    public Object jjtAccept(ParserVisitor visitor, Object data)
    {
        return visitor.visit(this, data);
    }

    public Object value(JexlContext jc)
        throws Exception
    {
        Object left = ((SimpleNode) jjtGetChild(0)).value(jc);
        boolean leftValue = Coercion.coerceBoolean(left).booleanValue(); 

        /*
         * coercion rules
         */
        return (leftValue
        		&& 
				Coercion.coerceBoolean(
						((SimpleNode) jjtGetChild(1)).value(jc)).booleanValue()) ?
            Boolean.TRUE : Boolean.FALSE;
    }
}
