/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail.attributes.code;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.AbstractDetailPane;
import org.gjt.jclasslib.browser.BrowserComponent;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.attributes.code.ByteCodeDisplay;
import org.gjt.jclasslib.browser.detail.attributes.code.CounterDisplay;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;

public class ByteCodeDetailPane
extends AbstractDetailPane {
    private static final Rectangle RECT_ORIGIN = new Rectangle(0, 0, 0, 0);
    private ByteCodeDisplay byteCodeDisplay;
    private CounterDisplay counterDisplay;
    private JScrollPane scrollPane;
    private JButton btnCopy;

    public ByteCodeDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupComponent() {
        this.setLayout(new BorderLayout());
        this.btnCopy = new JButton("Copy to clipboard");
        this.btnCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ByteCodeDetailPane.this.byteCodeDisplay.copyToClipboard();
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.btnCopy);
        this.add((Component)box, "South");
        this.add((Component)this.buildByteCodeScrollPane(), "Center");
        DocumentLinkListener documentLinkListener = new DocumentLinkListener(this.byteCodeDisplay);
        this.byteCodeDisplay.addMouseListener(documentLinkListener);
        this.byteCodeDisplay.addMouseMotionListener(documentLinkListener);
    }

    public void show(TreePath treePath) {
        CodeAttribute codeAttribute = (CodeAttribute)this.findAttribute(treePath);
        if (this.byteCodeDisplay.getCodeAttribute() != codeAttribute) {
            BrowserComponent browserComponent = this.services.getBrowserComponent();
            browserComponent.setCursor(Cursor.getPredefinedCursor(3));
            this.byteCodeDisplay.setCodeAttribute(codeAttribute, this.services.getClassFile());
            this.counterDisplay.init(this.byteCodeDisplay);
            this.byteCodeDisplay.scrollRectToVisible(RECT_ORIGIN);
            this.scrollPane.validate();
            this.scrollPane.repaint();
            browserComponent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void scrollToOffset(int n) {
        this.byteCodeDisplay.scrollToOffset(n);
    }

    private JScrollPane buildByteCodeScrollPane() {
        this.byteCodeDisplay = new ByteCodeDisplay(this);
        this.scrollPane = new JScrollPane(this.byteCodeDisplay);
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.counterDisplay = new CounterDisplay();
        this.scrollPane.setRowHeaderView(this.counterDisplay);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ByteCodeDetailPane.this.scrollPane.requestFocus();
            }
        };
        this.byteCodeDisplay.addMouseListener(mouseAdapter);
        this.scrollPane.getHorizontalScrollBar().addMouseListener(mouseAdapter);
        this.scrollPane.getVerticalScrollBar().addMouseListener(mouseAdapter);
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ByteCodeDetailPane.this.scrollPane.requestFocus();
            }
        });
        return this.scrollPane;
    }

    private class DocumentLinkListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ByteCodeDisplay byteCodeDisplay;
        private Cursor defaultCursor;
        private int defaultCursorType;
        private Cursor handCursor;

        private DocumentLinkListener(ByteCodeDisplay byteCodeDisplay) {
            this.byteCodeDisplay = byteCodeDisplay;
            this.defaultCursor = Cursor.getDefaultCursor();
            this.defaultCursorType = this.defaultCursor.getType();
            this.handCursor = Cursor.getPredefinedCursor(12);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.byteCodeDisplay.link(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            boolean bl = this.byteCodeDisplay.isLink(mouseEvent.getPoint());
            if (this.byteCodeDisplay.getCursor().getType() == this.defaultCursorType && bl) {
                this.byteCodeDisplay.setCursor(this.handCursor);
            } else if (!bl) {
                this.byteCodeDisplay.setCursor(this.defaultCursor);
            }
        }
    }
}

