/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.net.URL;
import java.nio.CharBuffer;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ContentEmitter
implements ContentHandler,
LexicalHandler,
DTDHandler {
    private NamePool pool;
    private Receiver receiver;
    private boolean inDTD = false;
    private Locator locator;
    private char[] buffer = new char[4096];
    private int used = 0;
    private int[] namespaces = new int[50];
    private int namespacesUsed = 0;

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setNamePool(NamePool namePool) {
        this.pool = namePool;
    }

    public void startDocument() throws SAXException {
        try {
            this.used = 0;
            this.namespacesUsed = 0;
            this.receiver.setDocumentLocator(this.locator);
            this.receiver.startDocument();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flush();
            this.receiver.endDocument();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.namespacesUsed >= this.namespaces.length) {
            int[] nArray = new int[this.namespacesUsed * 2];
            System.arraycopy(this.namespaces, 0, nArray, 0, this.namespacesUsed);
            this.namespaces = nArray;
        }
        this.namespaces[this.namespacesUsed++] = this.pool.allocateNamespaceCode(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.flush();
            int n = this.getNameCode(string, string2, string3);
            this.receiver.startElement(n, -1, 0);
            int n2 = 0;
            while (n2 < this.namespacesUsed) {
                this.receiver.namespace(this.namespaces[n2], 0);
                ++n2;
            }
            int n3 = 0;
            while (n3 < attributes.getLength()) {
                String string4 = attributes.getURI(n3);
                int n4 = this.getNameCode(attributes.getURI(n3), attributes.getLocalName(n3), attributes.getQName(n3));
                String string5 = attributes.getType(n3);
                int n5 = -1;
                if (!string5.equals("CDATA")) {
                    if (string5.equals("ID")) {
                        n5 = 560;
                    } else if (string5.equals("IDREF")) {
                        n5 = 561;
                    } else if (string5.equals("IDREFS")) {
                        n5 = 562;
                    } else if (string5.equals("NMTOKEN")) {
                        n5 = 556;
                    } else if (string5.equals("NMTOKENS")) {
                        n5 = 557;
                    } else if (string5.equals("ENTITY")) {
                        n5 = 563;
                    } else if (string5.equals("ENTITIES")) {
                        n5 = 564;
                    } else if (string5.equals("NOTATION")) {
                        n5 = 531;
                    }
                }
                this.receiver.attribute(n4, n5, attributes.getValue(n3), 0);
                ++n3;
            }
            this.receiver.startContent();
            this.namespacesUsed = 0;
        }
        catch (ValidationException validationException) {
            validationException.setLocator(this.locator);
            throw new SAXException(validationException);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private int getNameCode(String string, String string2, String string3) throws SAXException {
        if (string3.equals("")) {
            throw new SAXException("Saxon requires an XML parser that reports the QName of each element");
        }
        if (string2.equals("")) {
            throw new SAXException("Parser configuration problem: namespace reporting is not enabled");
        }
        String string4 = Name.getPrefix(string3);
        return this.pool.allocate(string4, string, string2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.flush();
            this.receiver.endElement();
        }
        catch (ValidationException validationException) {
            validationException.setLocator(this.locator);
            throw new SAXException(validationException);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        while (this.used + n2 > this.buffer.length) {
            char[] cArray2 = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, cArray2, 0, this.used);
            this.buffer = cArray2;
        }
        System.arraycopy(cArray, n, this.buffer, this.used, n2);
        this.used += n2;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                if (string == null) {
                    this.comment(string2.toCharArray(), 0, string2.length());
                } else {
                    if (!XMLChar.isValidNCName(string)) {
                        throw new SAXException("Invalid processing instruction name (" + string + ")");
                    }
                    this.receiver.processingInstruction(string, string2, 0);
                }
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.flush();
            if (!this.inDTD) {
                this.receiver.comment(CharBuffer.wrap(cArray, n, n2), 0);
            }
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }

    private void flush() throws TransformerException {
        if (this.used > 0) {
            this.receiver.characters(CharBuffer.wrap(this.buffer, 0, this.used), 0);
            this.used = 0;
        }
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        String string5 = string3;
        if (this.locator != null) {
            try {
                String string6 = this.locator.getSystemId();
                URL uRL = new URL(new URL(string6), string3);
                string5 = uRL.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.receiver.setUnparsedEntity(string, string5, string2);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

