// LabPlot : LTable.cc

#include <cstdlib>
#include <qpainter.h>
#include <kdebug.h>
#include <cstdlib>
#include "LTable.h"

LTable::LTable(int nRows, int nCols, QWidget *parent, const char *name)
	: QTable(nRows, nCols, parent, name), editor(0)
{
	array=NULL;
	size=0;
	updateTable();
//	connect(this, SIGNAL(currentChanged(int row, int col)), this, SLOT(updateTable()));
}

void LTable::updateTable() {
	kdDebug()<<"LTable::updateTable()"<<endl;
	int number = numRows()*numCols();
	kdDebug()<<"	resize array from "<<size<<" to "<<number<<endl;
	kdDebug()<<"	array="<<array<<endl;
	array = (double *) realloc(array,number*sizeof(double));
	kdDebug()<<"	new array="<<array<<endl;
	size=number;
	kdDebug()<<"	OK"<<endl;
}

QString LTable::text(int row, int col) {
//	kdDebug()<<"LTable::text()"<<endl;
//	kdDebug()<<"	ROWS/COLS = "<<numRows()<<' '<<numCols()<<endl;
	if(row > numRows() || col > numCols())
		return QString("");

	// resize if necessary
	int item = row+col*numRows();
	if(item>size)
		updateTable();

	return QString::number(array[item]);
}

void LTable::setText(int row, int col, const QString &text) {
//	kdDebug()<<"LTable::setText() "<<row<<' '<<col<<" to "<<text<<endl;
	kdDebug()<<"	ROWS/COLS = "<<numRows()<<' '<<numCols()<<endl;
	int item = row+col*numRows();
	kdDebug()<<"	item = "<<item<<endl;

	if(item > numRows()*numCols()) {
		kdDebug()<<"	WRONG REQUEST fro setText() : item>numRows()*numCols()!"<<endl;
		return;
	}

	if(item>size)
		updateTable();

	kdDebug()<<"	size of array = "<<size<<endl;
	kdDebug()<<"	settings item "<<item<<" to "<<text.toDouble()<<endl;
	array[item] = text.toDouble();
	kdDebug()<<"	OK"<<endl;
}

void LTable::paintCell(QPainter *painter, int row, int col, const QRect &cr, bool selected, const QColorGroup &cg) {
//	kdDebug()<<"LTable::paintCell("<<row<<' '<<col<<")"<<endl;
	QRect rect(0, 0, cr.width(), cr.height());
	if (selected) {
		painter->fillRect(rect, cg.highlight());
		painter->setPen(cg.highlightedText());
	}
	else {
		painter->fillRect(rect, cg.base());
		painter->setPen(QPen(Qt::lightGray, 0));
		painter->drawLine(rect.bottomLeft(), rect.bottomRight());
		painter->drawLine(rect.bottomRight(), rect.topRight());
		painter->setPen(cg.text());
	}
	painter->drawText(0, 0, cr.width(), cr.height(), AlignCenter, text(row, col));
}

QWidget *LTable::createEditor(int row, int col, bool initFromCell) const {
	kdDebug()<<"LTable::createEditor() : "<<row<<" / "<<col<<" | "<<initFromCell<<endl;
	editor = new QLineEdit(viewport());
//	if (initFromCell)
//		editor->setText(text(row, col));
	return editor;
}

QWidget *LTable::cellWidget(int row, int col) const {
//	kdDebug()<<"LTable::cellWidget("<<row<<' '<<col<<")"<<endl;
	if (row == currEditRow() && col == currEditCol())
		return editor;
	return 0;
}

void LTable::endEdit(int row, int col, bool accept, bool replace) {
	kdDebug()<<"LTable::endEdit()"<<endl;
	QTable::endEdit(row, col, accept, replace);
	delete editor;
	editor = 0;
}

void LTable::setCellContentFromEditor(int row, int col) {
	kdDebug()<<"LTable::setCellContentFromEditor()"<<endl;
	if (editor)
		setText(row, col, editor->text());
}
