//LabPlot : ProjectDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "ProjectDialog.h"

using namespace std;

ProjectDialog::ProjectDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("Project Settings"));

	project = mw->getProject();

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("file name : "),hb);
	new QLabel(project->Filename(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("project version : "),hb);
	new QLabel(QString::number(project->Version()),hb);
	new QLabel(i18n(" LabPlot version : "),hb);
	new QLabel(project->LabPlot(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("title : "),hb);
	titlele = new KLineEdit(project->Title(),hb);
	hb = new QHBox(vbox);
	new QLabel(i18n("author : "),hb);
	authorle = new KLineEdit(project->Author(),hb);

	hb = new QHBox(vbox);
	new QLabel(i18n("created : "),hb);
#if KDE_VERSION > 0x030104
	created = new KDateTimeWidget(project->Created(),hb);
#else
	new QLabel(i18n(project->Created().toString()),hb);
#endif
	hb = new QHBox(vbox);
	new QLabel(i18n(" last modified : "),hb);
#if KDE_VERSION > 0x030104
	modified = new KDateTimeWidget(project->Modified(),hb);
#else
	new QLabel(i18n(project->Modified().toString()),hb);
#endif 

	hb = new QHBox(vbox);
	new QLabel(i18n(" comment : "),hb);
	commentle = new KLineEdit(project->Comment(),hb);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	save->setEnabled(false);
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ProjectDialog::apply_clicked() {
	project->setTitle(titlele->text());
	project->setAuthor(authorle->text());
	project->setComment(commentle->text());
	// not changable
//	project->setCreated(created->dateTime());
//	project->setModified(created->dateTime());
	
	mw->setProject(project);
}
