<?php
// File           usr_user.php / ibWebAdmin
// Purpose        html sequence for the users-panel in user.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <01/10/10 21:24:42 lb>
//
// $Id: usr_user.php,v 1.6 2004/02/04 17:43:21 lbrueckner Exp $


if (isset($s_confirmations['user'])) {
    $subject = 'user';
    include_once('./panels/confirm.php');
}

elseif (isset($user_add_flag)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="usr_user_form">
<?php 

    hidden_session_field();
    user_definition(NULL, $usr_strings['CreateUsr']);

?>
<input type="submit" name="usr_user_create_cancel" value="<?php echo $button_strings['Cancel']; ?>">&nbsp;&nbsp;&nbsp;
<input type="reset" name="usr_user_reset" value="<?php echo $button_strings['Reset']; ?>">&nbsp;&nbsp;&nbsp;
<input type="submit" name="usr_user_create_doit" value="<?php echo $button_strings['Create']; ?>">
</form>
<?php

} elseif (!empty($s_user_name)) {

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="usr_user_form">
<?php

    hidden_session_field();
    user_definition($s_user_name, sprintf($usr_strings['ModUser'], $s_user_name));

?>
<input type="submit" name="usr_user_mod_cancel" value="<?php echo $button_strings['Cancel']; ?>">
<input type="submit" name="usr_user_mod_doit" value="<?php echo $button_strings['Modify']; ?>">
</form>

<?php

} elseif ($s_connected) {

?>
<table cellpadding="3" cellspacing="0" border>
  <tr align="left">
    <th><?php echo $usr_strings['UName']; ?></th>
    <th><?php echo $usr_strings['FName']; ?></th>
    <th><?php echo $usr_strings['MName']; ?></th>
    <th><?php echo $usr_strings['LName']; ?></th>
    <th><?php echo $usr_strings['UserID']; ?></th>
    <th><?php echo $usr_strings['GroupID']; ?></th>
  </tr>
<?php
    if (!empty($users)) {
        foreach($users as $uname => $udata) {
?>
  <tr>
    <td><?php echo table_val($uname); ?></td>
    <td><?php echo table_val($udata['FIRST_NAME']); ?></td>
    <td><?php echo table_val($udata['MIDDLE_NAME']); ?></td>
    <td><?php echo table_val($udata['LAST_NAME']); ?></td>
    <td><?php echo table_val($udata['UID']); ?></td>
    <td><?php echo table_val($udata['GID']); ?></td>
  </tr>
<?php
        } // foreach
    }

?>
</table>

<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="usr_user_form">
<?php hidden_session_field(); ?>
<?php
        if ($s_login['user'] != 'SYSDBA') {
            sysdba_pw_textfield($usr_strings['SysdbaPW'], $usr_strings['Required'], $s_sysdba_pw);
        }
?>
<table border cellpadding="3" cellspacing="0">
<tr>
  <th align="left"><?php echo $usr_strings['CreateUsr']; ?></th>
  <td><input type="submit" name="usr_user_create" value="<?php echo $button_strings['Create']; ?>"></td>
</tr>

<tr>
  <td>
    <b><?php echo $usr_strings['USelMod']; ?></b>
    <select name="usr_user_mname">
    <?php build_user_options(); ?>
    </select>
  </td>
  <td align="left">
    <input type="submit" name="usr_user_mod" value="<?php echo $button_strings['Modify']; ?>">
  </td>
</tr>

<tr>
  <td>
    <b><?php echo $usr_strings['USelDel']; ?></b>
    <select name="usr_user_dname">
    <?php build_user_options($with_sysdba=FALSE); ?>
    </select>
  </td>
  <td align="left">
    <input type="submit" name="usr_user_del" value="<?php echo $button_strings['Delete']; ?>">
  </td>
</tr>
</table>
</form>
<?php

}

function table_val($val) {

    $val = (empty($val) && $val !== 0) ? '&nbsp;' : $val;

    return $val;
}
?>
