//
// Filename: xojpanel.h
//
// XojPanel class declaration.
/*
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
*/

// Copyright (C) circa 1998 Andreas Fester
// Copyright (C) 2000, 2001 Joe Piolunek
//
// This is an expanded version of the original
// xojpanel application released by Andreas Fester.
//
// Thanks to David Paschal for contributing a patch to allow xojpanel to exit
// gracefully if the peripheral does not support LCD message requests.
//
// David Paschal also did the ojlib->PTAL conversion.
//


#ifndef XOJPANEL_H
#define XOJPANEL_H

#include "ptal.h"
#include <qwidget.h>
#include <qpixmap.h>
#include <qlabel.h>

class XojPanel : public QWidget
{
	Q_OBJECT
public:
	XojPanel(int argc, char **argv, QWidget *parent=0, const char *name=0 );
	void paintEvent( QPaintEvent* );
	void closeEvent( QCloseEvent* );

signals:
	//

protected:
	//

private slots:
	void getPrinterLCDMessages();
	void updateLCDPixmap();


private:
	void createInterface( QString );
	void createLCD( void );
	void createCoverGraphic( void );
	void createTimers( void );
	void stripRightSpace( QString * );
	void displayLCDMessage( QString*, QString*, bool, bool );
	void drawLCDTextLine( QPainter*, QString*, int, int );

	QWidget *xojpanel;
	QPixmap *pm;
	QPixmap *lcdPixmap;
	QLabel *lcdGraphic;

	QString Line1;    // upper line of the lc display
	QString Line2;    // lower line of the lc display

	ptalDevice_t dev;
	// objHpLineX are for the HP MIB.
	// objSpmLineX are for the Standard Printer MIB.
	// objLineX start out pointing to the HP objects,
	// but may get changed to the SPM objects if the
	// peripheral doesn't support the HP objects.
	ptalPmlObject_t objLine1;
	ptalPmlObject_t objLine2;
	ptalPmlObject_t objHpLine1;
	ptalPmlObject_t objHpLine2;
	ptalPmlObject_t objSpmLine1;
	ptalPmlObject_t objSpmLine2;
};


#endif
