/* ptal-devid -- PTAL command-line device ID string retrieval client */

/* Copyright (C) 2000-2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Original author: David Paschal */

#include <unistd.h>
#include <string.h>
#include "ptal.h"

#define STDOUT			1

#define RETCODE_SUCCESSFUL	0
#define RETCODE_NO_DATA		1
#define RETCODE_SYNTAX_ERROR	2
#define RETCODE_DEVICE_ERROR	3

#define LEN_BUFFER		4096

#define PRINT_IT \
	do { \
		if (r!=PTAL_ERROR && lenResult>0) { \
			retcode=RETCODE_SUCCESSFUL; \
			if (!fullOutput) { \
				ptalDeviceIDPruneField(&result,&lenResult); \
			} \
			write(STDOUT,result,lenResult); \
		} \
		write(STDOUT,"\n",1); \
	} while(0)

int main(int argc,char **argv) {
	char *argv0=*argv;
	int retcode=RETCODE_DEVICE_ERROR,lenResult,fullOutput=1,r;
	char buffer[LEN_BUFFER],*result=buffer;
	ptalDevice_t dev=0;

	if (ptalInit()==PTAL_ERROR) goto abort;

	argv++; argc--;
	if (argc<=0) {
syntaxError:
		PTAL_LOG_ERROR(
"Syntax: %s <dev> [[<modifiers>] <queries>]...\n"
"where <dev> is a PTAL device name\n"
"Supported <modifiers>:\n"
"\t-short       -- Displays field values only\n"
"\t-long        -- Displays leading field name through semicolon\n"
"Supported <queries>:\n"
"\t-field <key> -- Queries specific field\n"
"\t-mfg         -- Queries manufacturer fields\n"
"\t-mdl         -- Queries model fields\n"
"\t-cmd         -- Queries command set fields\n"
"\t-sern        -- Queries serial number fields\n"
			,argv0);
		retcode=RETCODE_SYNTAX_ERROR;
		goto abort;
	}

	dev=ptalDeviceOpen(*argv);
	if (!dev) {
		PTAL_LOG_ERROR("ptalDeviceOpen(dev=%s) failed!\n",*argv);
		goto abort;
	}

	r=ptalDeviceGetDeviceIDString(dev,buffer,LEN_BUFFER);
	if (r==PTAL_ERROR) {
		PTAL_LOG_ERROR("ptalDeviceGetDeviceIDString(dev=%s) failed!\n",
			*argv);
		goto abort;
	}

	retcode=RETCODE_NO_DATA;
	if (argc<=1) {
		lenResult=strlen(buffer);
		PRINT_IT;

	} else while (42) {
		argc--; argv++; if (argc<=0) break;
		lenResult=0;

		if (!strcmp(*argv,"-short")) {
			fullOutput=0;

		} else if (!strcmp(*argv,"-long")) {
			fullOutput=1;

		} else if (!strcmp(*argv,"-field")) {
			argc--; argv++; if (argc<=0) goto syntaxError;
			r=ptalDeviceIDGetField(buffer,*argv,
			     &result,&lenResult);
			PRINT_IT;

		} else if (!strcmp(*argv,"-mfg")) {
			r=ptalDeviceIDGetManufacturer(buffer,
			     &result,&lenResult);
			PRINT_IT;

		} else if (!strcmp(*argv,"-mdl")) {
			r=ptalDeviceIDGetModel(buffer,
			     &result,&lenResult);
			PRINT_IT;

		} else if (!strcmp(*argv,"-cmd")) {
			r=ptalDeviceIDGetCommandSet(buffer,
			     &result,&lenResult);
			PRINT_IT;

		} else if (!strcmp(*argv,"-sern")) {
			r=ptalDeviceIDGetSerialNumber(buffer,
			     &result,&lenResult);
			PRINT_IT;

		} else {
			goto syntaxError;
		}
	}

abort:
	ptalDone();
	return retcode;
}
