/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXPlayerToObserver.m,v 1.13.2.4 2004/07/09 01:49:35 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#import "HXClientCallbacks.h"
#import "HXStringUtils.h"
#import "HXErrorCodeStrings.h"
#import "HXErrorCodeStringsMac.h"
#import "HXPlayerToObserver.h"

#include "enter_hx_headers.h"
#include "ihxhurl.h" // HXHURL_...
#include "exit_hx_headers.h"

NSString* kErrorParamKeyHXKey		= @"HX_RESULT_KEY";
NSString* kErrorParamKeyHXCode		= @HXHURL_ITEMID; 
NSString* kErrorParamKeyUserCode	= @HXHURL_USERCODE;
NSString* kErrorParamKeyUserString	= @HXHURL_USERERRSTRING;
NSString* kErrorParamKeyMoreInfoURL	= @HXHURL_MOREINFOURL;

static void OnPlayerVisualStateChanged( void/*id*/* observer, bool hasVisualContent )
{
	if ( [(id)observer respondsToSelector:@selector( onVisualStateChanged: )] )
	{
		BOOL newHasVisualContent = ( hasVisualContent ? YES : NO );
		[(id)observer onVisualStateChanged:newHasVisualContent];
	}
}

static void OnPlayerIdealSizeChanged( void/*id*/* observer, SInt32 idealWidth, SInt32 idealHeight )
{
	if ( [(id)observer respondsToSelector:@selector( onIdealSizeChanged: )] )
	{
		NSSize newIdealSize;
		newIdealSize.width = idealWidth;
		newIdealSize.height = idealHeight;
		[(id)observer onIdealSizeChanged:newIdealSize];
	}
}

static void OnPlayerLengthChanged( void/*id*/* observer, UInt32 length )
{
	if ( [(id)observer respondsToSelector:@selector( onLengthChanged: )] )
	{
		[(id)observer onLengthChanged:length];
	}
}

static void OnPlayerTitleChanged( void/*id*/* observer, const char* pTitle )
{
	if ( [(id)observer respondsToSelector:@selector( onTitleChanged: )] )
	{
		if ( pTitle && *pTitle )
		{
			CFStringRef title = CFStringCreateWithCString( kCFAllocatorDefault, pTitle, GuessEncodingForCString( ( const unsigned char* ) pTitle ) );
			[(id)observer onTitleChanged:(NSString*)title];
			CFRelease( title );
		}
		else
		{
			[(id)observer onTitleChanged:[NSString string]];
		}
	}
}

static void OnPlayerGroupsChanged( void/*id*/* observer )
{
	if ( [(id)observer respondsToSelector:@selector( onTracksChanged )] )
	{
		[(id)observer onTracksChanged];
	}
}

static void OnPlayerGroupStarted( void/*id*/* observer, UInt16 groupIndex )
{
	if ( [(id)observer respondsToSelector:@selector( onTrackStarted: )] )
	{
		[(id)observer onTrackStarted:groupIndex];
	}
}

static void OnPlayerContacting( void/*id*/* observer, const char* pHostName )
{
	if ( [(id)observer respondsToSelector:@selector( onContacting: )] )
	{
		NSString* hostName = pHostName ? [NSString stringWithCString:pHostName] : [NSString string];
		[(id)observer onContacting:hostName];
	}
}

static void OnPlayerBuffering( void/*id*/* observer, UInt32 bufferingReason, UInt16 bufferPercent )
{
	if ( [(id)observer respondsToSelector:@selector( onBuffering:because: )] )
	{
		[(id)observer onBuffering:bufferPercent because:bufferingReason];
	}
}

static void OnPlayerContentStateChanged( void/*id*/* observer, int oldContentState, int newContentState )
{
	if ( [(id)observer respondsToSelector:@selector( onContentStateChangedFrom:to: )] )
	{
		[(id)observer onContentStateChangedFrom:oldContentState to:newContentState];
	}
}

static void OnPlayerContentConcluded( void/*id*/* observer )
{
	if ( [(id)observer respondsToSelector:@selector( onContentConcluded )] )
	{
		[(id)observer onContentConcluded];
	}
}

static void OnPlayerStatusChanged( void/*id*/* observer, const char* pStatus )
{
	if ( [(id)observer respondsToSelector:@selector( onStatusChanged: )] )
	{
		if ( pStatus && *pStatus )
		{
			CFStringRef status = CFStringCreateWithCString( kCFAllocatorDefault, pStatus, GuessEncodingForCString( ( const unsigned char* ) pStatus ) );
			[(id)observer onStatusChanged:(NSString*)status];
			CFRelease( status );
		}
		else
		{
			[(id)observer onStatusChanged:[NSString string]];
		}
	}
}

static void OnPlayerVolumeChanged( void/*id*/* observer, UInt16 volume )
{
	if ( [(id)observer respondsToSelector:@selector( onVolumeChanged: )] )
	{
		[(id)observer onVolumeChanged:volume];
	}
}

static void OnPlayerMuteChanged( void/*id*/* observer, bool hasMuted )
{
	if ( [(id)observer respondsToSelector:@selector( onMuteChanged: )] )
	{
		BOOL newHasMuted = ( hasMuted ? YES : NO );
		[(id)observer onMuteChanged:newHasMuted];
	}
}

static void OnPlayerClipBandwidthChanged( void/*id*/* observer, SInt32 clipBandwidth )
{
	if ( [(id)observer respondsToSelector:@selector( onEncodedBitrateChanged: )] )
	{
		double newClipBandwidth = clipBandwidth;
		[(id)observer onEncodedBitrateChanged:newClipBandwidth];
	}
}

static void OnPlayerErrorOccurred( void/*id*/* observer, UInt32 hxCode, UInt32 userCode, const char* pErrorString, const char* pUserString, const char* pMoreInfoURL )
{
	if ( [(id)observer respondsToSelector:@selector( onErrorOccurred:msgString:params: )] )
	{
		CFStringRef errorString = CreateErrorStringForHXCode( hxCode, pErrorString );
		if ( errorString )
		{
			NSMutableDictionary* params = [NSMutableDictionary dictionary];
			[params setObject:[NSNumber numberWithUnsignedLong:hxCode] forKey:kErrorParamKeyHXCode];
			
			const char* keyString = HXErrorCodeToString( hxCode );
			if ( keyString )
			{
				[params setObject:[NSString stringWithCString:keyString] forKey:kErrorParamKeyHXKey];
			}
			
			[params setObject:[NSNumber numberWithUnsignedLong:userCode] forKey:kErrorParamKeyUserCode];
			if ( pUserString )
			{
				[params setObject:[NSString stringWithCString:pUserString] forKey:kErrorParamKeyUserString];
			}
			if ( pMoreInfoURL )
			{
				[params setObject:[NSString stringWithCString:pMoreInfoURL] forKey:kErrorParamKeyMoreInfoURL];
			}
			NSString* userString = pUserString ? [NSString stringWithCString:pUserString] : [NSString string];
			[(id)observer onErrorOccurred:(NSString*)errorString msgString:userString params:params];
			
			CFRelease( errorString );
		}
	}
}

static bool HandlePlayerGoToURL( void/*id*/* observer, const char* pURL, const char* pTarget, bool isPlayerURL )
{
	if ( [(id)observer respondsToSelector:@selector( goToURL:withTarget:isPlayerURL: )] )
	{
		BOOL willPlay = [(id)observer goToURL:pURL withTarget:pTarget isPlayerURL:( isPlayerURL ? YES : NO )];
		return ( willPlay ? true : false );
	}
	return false;
}

static bool HandlePlayerRequestAuthentication( void/*id*/* observer, const char* pServer, const char* pRealm, bool isProxyServer )
{
	if ( [(id)observer respondsToSelector:@selector( requestAuthenticationFrom:inRealm:isProxyServer: )] )
	{
		NSString* server = ( pServer && *pServer ) ? [NSString stringWithCString:pServer] : nil;
		NSString* realm  = ( pRealm  && *pRealm  ) ? [NSString stringWithCString:pRealm]  : nil;
		BOOL hasBegun = [(id)observer requestAuthenticationFrom:server inRealm:realm isProxyServer:( isProxyServer ? YES : NO )];
		return ( hasBegun ? true : false );
	}
	return false;
}

static bool HandlePlayerRequestUpgrade( void/*id*/* observer, const char* pURL, UInt32 numOfComponents, const char* componentNames[], bool isBlocking )
{
	if ( [(id)observer respondsToSelector:@selector( requestUpgradeForURL:requiresComponents:isBlocking: )] )
	{
		UInt32 index;
		NSMutableArray* upgradeCollection = [NSMutableArray arrayWithCapacity:numOfComponents];
		for ( index = 0; index < numOfComponents; ++index )
		{
			NSString* componentName = [NSString stringWithCString:componentNames[ index ]];
			[upgradeCollection addObject:componentName];
		}
		BOOL hasBegun = [(id)observer requestUpgradeForURL:pURL requiresComponents:upgradeCollection isBlocking:( isBlocking ? YES : NO )];
		return ( hasBegun ? true : false );
	}
	return false;
}

static bool DoesPlayerHaveComponent( void/*id*/* observer, const char* componentName )
{
	if ( [(id)observer respondsToSelector:@selector( hasComponent: )] )
	{
		BOOL hasComponent = [(id)observer hasComponent:[NSString stringWithCString:componentName]];
		return ( hasComponent ? true : false );
	}
	return false;
}

HXClientCallbacks gPlayerToObserverCallbacks =
{
	OnPlayerVisualStateChanged,
	OnPlayerIdealSizeChanged,
	OnPlayerLengthChanged,
	OnPlayerTitleChanged,
	OnPlayerGroupsChanged,
	OnPlayerGroupStarted,
	OnPlayerContacting,
	OnPlayerBuffering,
	OnPlayerContentStateChanged,
	OnPlayerContentConcluded,
	OnPlayerStatusChanged,
	OnPlayerVolumeChanged,
	OnPlayerMuteChanged,
	OnPlayerClipBandwidthChanged,
	OnPlayerErrorOccurred,
	HandlePlayerGoToURL,
	HandlePlayerRequestAuthentication,
	HandlePlayerRequestUpgrade,
	DoesPlayerHaveComponent,
	NULL,
	NULL
};
