/* 

HAPM - High Availability Port Monitor

by Alexandre Antonio Antunes de Almeida (BR Army)
   Joao Eriberto Mota Filho (BR Army)
   Rosemeri Dantas de Oliveira (BR Army)

High Availability Port Monitor (HAPM) is a local port status check. It is a
simple, light and fast daemon to check TCP/UDP ports. If one or more monitored
ports (per IP) downs then the Heartbeat will be killed by HAPM.
   
This is a Brazilian project under Gnu GPL License!

Please check the /etc/ha.d/hapm.conf file.

*/
   
#include "hapm.h" 
#include <stdarg.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <syslog.h>
#include <string.h>
#define MAX 100

// Print out the version number
void PrintVersion()
{
    printf("\n\nHigh Availability Port Monitor - HAPM v%0.1f",NUMBER_VERSION);
    printf("\nhttp://hapm.sourceforge.net\n\n");
}

void PrintUsage()
{
    PrintVersion();
    
    printf("Usage:\n");
    printf("----------------------------\n");
    printf("hapm <args>\n");
    printf("  -v  Print version and exit\n");
    printf("----------------------------\n\n");
    printf("Example:\n");
    printf("  hapm -v\n\n");
}

int main(int parc, char *parv[])
{
    if(parc>1)
    {	
        if(parc>2)
	{
    	    PrintUsage();
	    exit(0);
	}

	if(strncmp("-v",parv[1],3)==0)
        {
    	    PrintVersion();
	    exit(0);
	} else {
    	    printf("Couldn't understand command line, quitting\n\n");
	    exit(0);
	}
    }
    
    /* Criando estrutura que conter os endereos IPs e Portas a serem
       verificada em um loop eterno. */
    typedef struct	
    {
	char address_ip[16];
	char number_port[10];
    } addressport;  

    int 	fd;
    char	ip[16]; 
    char 	port[10];	
    struct 	sockaddr_in serv_addr;
    addressport matriz_addressport[MAX]; 
       
    /* Lendo arquivo de configurao */
    FILE *conf,*pid;
    char linha[MAX];
    char vsocket[]="socket=";
    char vtime[]="time=";
    char vheartbeat[]="heartbeat=";
    char vheartbeatpid[]="heartbeatpid=";
    char heartbeat_path[MAX];
    char heartbeatpib_path[MAX];
    int  vpid=getpid();
    int  inicioPosicaoPorta;
    char time_sleep[5];
    int  i,j,k,h,s,t,p;
    int	 interval;
    char cmd[MAX]; //Armazena o string do comando system
    char cmdstop[MAX];//Armazena o comando stop
    char cmdrm[MAX];//Armazena o string do comando de remoo do arquivo pid
    char cmdpid[MAX];//Armazena o comando rm
    
    // LOG: HAPM Started
    syslog(LOG_NOTICE,"HAPM Started");

    //Leitura do arquivo de configurao e montagem das variveis.
    conf = fopen("/etc/ha.d/hapm.conf","r");

    if (!conf){
	printf("HAPM: ERROR: fail when openning configuration file. \n");

	// LOG: HAPM: ERROR: fail when openning configuration file
	syslog(LOG_NOTICE,"ERROR: fail when openning configuration file.");    
	exit(0);
    }
    
    fgets(linha, MAX, conf);
    
    /* Processamento do arquivo de configurao para obter:
       - Endereo de IPs
       - Nmero das Portas
       - Caminho do Heartbeat para stop no servio
       - Tempo para sleep
    */
    
    /* Inicializa o vetor para montar a estrutura ADDRESSPORT */
    s=0;

    /* Incio do processamento */
    while(!feof(conf))
    {
        /* Desconsidera as linhas comentadas com o caracter '#'
	   e as linhas em branco */

	if(strncmp("#",linha,1)!=0 & strlen(linha)!=1)
	{
	    // Monta a estrutura ADDRESSPORT
	    if(strncmp(vsocket,linha,7)==0)
	    {
		// Localiza a posio da virgula na linha do arquivo
    		for(i=0;i<=25;i++)
		{
    		    if (linha[i]==':')
			inicioPosicaoPorta=i+1; //  a virgula
		}    	
    		//Localiza a porta
		//limpa o vetor porta
		for(j=0;j<=9;j++)
		{
    		    port[j]='\0';
		}

		//Uma vez que esteja limpa, pode ser utilizada
    		j=0;
		for(i=inicioPosicaoPorta;linha[i]!='\0';i++)
		{
		    port[j++]=linha[i];
		}
		j=0;

		//Limpa vetor ip, para que no haja lixo
    		for(j=0;j<=14;j++)
    		    ip[j]='\0';
	
		//Localiza o ip e armazena na varivel ip
    		k=0;	
		for(i=7;i<=(inicioPosicaoPorta-2);i++)
		{
		    ip[k++]=linha[i];
		}

		// Armazena ip e porta na estrutura ADDRESSPORT
		strcpy(matriz_addressport[s].address_ip,ip);
		strcpy(matriz_addressport[s].number_port,port);
		s++;
	    }
	    
    	    // Busca do caminho do heartbeat no arquivo de configurao
	    if(strncmp(vheartbeat,linha,10)==0)
	    {
		h=0;
		for(i=10;i<=strlen(linha);i++)
		{
		    heartbeat_path[h++]=linha[i];
		}	    
	    }

    	    // Busca do caminho do heartbeat.pid do arquivo de configurao
	    if(strncmp(vheartbeatpid,linha,13)==0)
	    {
		p=0;
		for(i=13;i<=strlen(linha);i++)
		{
		    heartbeatpib_path[p++]=linha[i];
		}	    
	    }
	    
	    // Busca tempo para sleep do processo
	    if(strncmp(vtime,linha,5)==0)
	    {
		t=0;
		for(i=5;linha[i]!='\0';i++)
		{
		    time_sleep[t++]=linha[i];
		}
	    }
	}    
        // Ler prxima linha do arquivo de configurao
        fgets(linha,MAX, conf);
    }
    // Fecha o arquivo de configurao
    fclose(conf);

    //Monta o str cmdo:
    for (i=0;i<=h-3;i++)
    {
	cmd[i] = heartbeat_path[i];
    }
    strncpy(cmd,heartbeat_path,h-4);
    strncpy(cmdstop," stop",6);
    strcat(cmd,cmdstop);
    
    //Monta o str cmdo de remoo do arquivo heartbeat.pid
    for (i=0;i<=p-3;i++)
    {
	cmdrm[i] = heartbeatpib_path[i];
    }
    strncpy(cmdpid,"rm -f ",7);
    strcat(cmdpid,cmdrm);

    // Validao do tempo para sleep
    if(atoi(time_sleep)<=0 | atoi(time_sleep)>3600)
    {
	printf("HAPM: ERROR: The time range must be 0 to 3600 seconds. \n");

        // LOG: HAPM: ERROR: The time range must be 0 to 3600 seconds.
	syslog(LOG_NOTICE,"ERROR: The time range must be 0 to 3600 seconds.");

        exit(0);
     }     
     
    // Cria arquivo PID
    pid=fopen("/var/run/hapm.pid","w");
    fprintf(pid,"%d", vpid);
    fclose(pid);

    // Processamento eterno
    interval=58;
    while(1==1)
    {
	sleep(atoi(time_sleep));
	for(i=0;i<=(s-1);i++)
	{    
	    strcpy(ip,matriz_addressport[i].address_ip);
	    strcpy(port,matriz_addressport[i].number_port);
	    fd = socket(AF_INET, SOCK_STREAM, 0);

//    	    if (fd < 0)
//	        printf("Can't create a new socket");

	    bzero((char *) &serv_addr, sizeof(serv_addr));
	    serv_addr.sin_family = AF_INET;
	    serv_addr.sin_port = htons(atoi(port));
	    serv_addr.sin_addr.s_addr = INADDR_ANY;

	    if (bind(fd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) >= 0)
	    {
	        if (fopen("/var/run/heartbeat.pid","r"))
	        {
    		    // LOG: HAPM: Port $porta is down.
		    syslog(LOG_NOTICE,"Port %sis down.",port);

		    // LOG: HAPM: Stopping Heartbeat.
		    syslog(LOG_NOTICE,"Stopping Heartbeat.");

		    //Stop in Heartbeat - parameter hapm.conf
    		    system(cmd);
		    
		    //Apaga o arquivo heartbeat.pid 
		    system(cmdpid);
//		    system(rm -f /var/run/heartbeat.pid);
		} else
		{
		    interval++;
		    if (interval==60)
		    {
			// Report Heartbeat status in log and screen periodcly
			syslog(LOG_NOTICE,"WARNING: HEARTBEAT IS DOWN.");
			
			printf("HAPM WARNING: HEARTBEAT IS DOWN \n");
			interval=0;
		    }
		}
		  
	    }  
	    //Fecha o descritor do socket
	    close(fd);
	}
    }
}

