/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Matias Mutchinick
 *           Jos Miguel Ronquillo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gnome.h>
#include <gtrans_ifase/gtrans_ifase.h>
#include "gtrans_conn_list.h"
#include "gtrans_conn_dialog.h"
#include "gtrans_error_dialog.h"


extern GtkWidget  *app;
extern GtkWidget  *conn_list;




/**
 * Connecting...
 */


/**
 * gtrans_conn_establish_connection:
 * @dlg  : The connection dialog.
 * 
 * Read the information needed to establish a connection from the 
 * connection dlialog, establish the connection and add the connection
 * to the open connections list.
 */
static void
gtrans_conn_establish_connection(GtkWidget *dlg)
{
	GTransIFaseConn    *conn;
	GTransIFasePlugin  *plugin;
	gchar              *host, *user, *port, *db, *pwd;
	
	
	/* 
	 * First we get the options from the connection dialog 
	 */
	host = gtk_entry_get_text(GTK_ENTRY(GTRANS_CONN_DIALOG(dlg)->host));
	port = gtk_entry_get_text(GTK_ENTRY(GTRANS_CONN_DIALOG(dlg)->port));
	db   = gtk_entry_get_text(GTK_ENTRY(GTRANS_CONN_DIALOG(dlg)->db));
	user = gtk_entry_get_text(GTK_ENTRY(GTRANS_CONN_DIALOG(dlg)->login));
	pwd  = gtk_entry_get_text(GTK_ENTRY(GTRANS_CONN_DIALOG(dlg)->pwd));
	
		
	if (GTRANS_CONN_DIALOG(dlg)->plugin == NULL){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_SELECT_PLUGIN]);
		return;
	}
	
	if (strlen(db) == 0 || strlen(user) == 0){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_LOGIN_USER_DB]);
		return;
	}
	

	/* Establish a connection */	
	plugin = GTRANS_CONN_DIALOG(dlg)->plugin;
	conn   = (plugin->connect) (host,port,db,user,pwd);
	
	if(gtrans_ifase_conn_status(conn)){
		gtrans_error_dialog(gtrans_ifase_conn_error_msg(conn));
		return;
	}
	
	/* Append to the open connection's list */
	gtrans_conn_list_append(conn_list,conn,plugin);
	
	gtk_widget_destroy(dlg);	
}



/**
 * gtrans_conn_pop_dialog:
 *
 * Pop the connection dialog.
 */
static void
gtrans_conn_pop_conn_dialog()
{
	GtkWidget *dlg;
	GList     *plugins;
	
	plugins = gtrans_ifase_plugin_list(GNOME_TRANSCRIPT_PLUGIN_DIR);
	
	if (!plugins){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_NO_PLUGINS]);
		return;
	}
	
	dlg = gtrans_conn_dialog_new(plugins);
	GTK_WINDOW (dlg)->position = GTK_WIN_POS_MOUSE;
	gtk_window_set_modal (GTK_WINDOW (dlg),TRUE);
	gtk_window_set_transient_for (GTK_WINDOW (dlg), GTK_WINDOW (app));
	
	gtk_signal_connect_object(GTK_OBJECT(dlg),"connect",
				  GTK_SIGNAL_FUNC(gtrans_conn_establish_connection),
				  GTK_OBJECT(dlg));
	
	gtk_widget_show_all (dlg);
}



/**
 * gtrans_conn_connect:
 * 
 * Just call the above 
 * (Show the connection dialog to start a connection).
 */
void
gtrans_conn_connect(GtkWidget    *widget,
		    gpointer      data)
{
	gtrans_conn_pop_conn_dialog();
}





/**
 * Disconnecting...
 */

/**
 * gtrans_conn_disconnect_selected:
 * 
 * Finish the selected connection from the connection list,
 * and remove it from the list.
 */
static void
gtrans_conn_disconnect_selected()
{
	GTransConnListItem  *item;
	
	item = gtrans_conn_list_selected(conn_list);
	if(item == NULL){
		gtrans_error_dialog(GTransErrorMsg[GTRANS_ERROR_SELECT_DB]);		
		return;
	}
	
	gtrans_ifase_conn_finish_conn(item->conn);
	if (item->gde)
		gtk_widget_destroy(item->gde);
	/* FIXME : free the GTransIFasePlugin */
	
	gtrans_conn_list_remove_selected(conn_list);
}



/*
 * gtrans_conn_disconnect:
 * 
 * Disconnect from the selected database.
 */
void
gtrans_conn_disconnect(GtkWidget    *widget,
		       gpointer      data)
{
	gtrans_conn_disconnect_selected();
}








