/*   grep-dctrl - grep Debian control files
     Copyright (C) 1999  Antti-Juhani Kaijanaho
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
  
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details. 
  
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING.  If not, write to
     the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
  
     The author can be reached via mail at (ISO 8859-1 charset for the city)
        Antti-Juhani Kaijanaho
        Helvintie 2 e as 9
        FIN-40500 JYVSKYL
        FINLAND
        EUROPE
     and via electronic mail from
        gaia@iki.fi
     If you have a choice, use the email address; it is more likely to
     stay current.

*/

#ifndef MSG_H__
#define MSG_H__

#include <stdio.h>
#include <stdlib.h>
#include "i18n.h"

/* log levels */
#define L_FATAL 3
#define L_IMPORTANT 2
#define L_INFORMATIONAL 1
#define L_DEBUG 0

#define PROGNAME_MAXLEN 64

#ifdef MSG_C__
int loglevel = L_IMPORTANT;
char progname [PROGNAME_MAXLEN];
#endif

inline static void
line_message (int severity, const char * s, const char * fname, int line)
{
#ifndef MSG_C__
  extern int loglevel;
#endif

#if defined(TEST_NODEBUG)
  if (severity == L_DEBUG)
    {
      line_message (L_INFORMATIONAL, _("Got a L_DEBUG while TEST_NODEBUG "
                                  "is defined"), 0, 0);
      message (L_FATAL, _("I'm broken - please report this "
                          "to <gaia@iki.fi>"), 0, 0);
      abort ();
    }
#endif
  
  if (severity >= loglevel)
    {
#ifndef MSG_C__
      extern const char progname [PROGNAME_MAXLEN];
#endif

      if (fname == 0)
        fprintf (stderr,  "%s: %s.\n", progname, s);
      else
        if (line > 0)
          fprintf (stderr, "%s: %s: %i: %s.\n", progname, fname, line, s);
        else
          fprintf (stderr, "%s: %s: %s.\n", progname, fname, s);
    }
}

inline static void
message (int severity, const char * s, const char * fname)
{
  line_message (severity, s, fname, 0);
}

#ifndef MSG_C__
#undef PROGNAME_MAXLEN
#endif

inline static void
debug_message (const char * s, const char * fname)
{
#if !defined(NDEBUG) && !defined(TEST_NODEBUG) && defined(ENABLE_L_DEBUG)
  message (L_DEBUG, s, fname);
#endif
}

#define enomem_msg _("cannot find enough memory")

inline static void
enomem (const char * fname)
{
  message (L_IMPORTANT, enomem_msg, fname);
}

inline static void
fatal_enomem (const char * fname)
{
  message (L_FATAL, enomem_msg, fname);
  exit (EXIT_FAILURE);
}

#undef enomem_msg

/* Given a string that represents a log level, return the number that
   repsesents that loglevel.  A negative return value means that the
   string is not a valid log level.  */
int
str2loglevel (const char * s);

/* Set current log level to ll.  */
void
set_loglevel (int ll);

/* Set program name to pn. */
void
msg_set_progname (const char * pn);

#endif /* MSG_H__ */
