# gozerbot/myimport.py
#
#

""" provide own import function for absolute imports """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import rlog
import time

def my_import(name):
    """ absolute import """
    rlog(-1, 'my_import', 'importing %s' % name)
    try:
        result = __import__(name)
    except:
        rlog(100, 'my_import', 'failed to import %s' % name)
        time.sleep(1)
        raise
    mods = name.split('.')
    if len(mods) == 1:
        pass
    else:
        # expand module name
        for mod in mods[1:]:
            result = getattr(result, mod)
    return result
