/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgtkitemfactory.c -

  $Author: iga $
  $Date: 2001/05/21 21:25:38 $

  Copyright (C) 1998-2000 Hiroshi Igarashi,
                          dellin

************************************************/

#include "global.h"

/*
 * ItemFactory
 */

const static guint cb_type = 2;

static VALUE
ifact_initialize(self, type, path, accel)
    VALUE self;
    VALUE type, path, accel;
{
    GtkType gtype;

    gtype = FIX2INT(type);
    set_gobject(self, GTK_OBJECT(gtk_item_factory_new(gtype,
						      STR2CSTR(path),
						      get_gtkaccelgrp(accel)
				     )));
    gtk_object_set_data(get_gobject(self), "rbgtk/ifact/type", (gpointer)gtype);
    return Qnil;
}

static int
item_type_check(item_type)
    char *item_type;
{
    if (item_type == NULL){
	return -1;
    }
    if ((strcmp(item_type, "<Branch>") == 0) 
	|| (strcmp(item_type, "<LastBranch>") == 0))
	return 0;
    else if (strcmp(item_type, "<Separator>") == 0)
	return 0;
    else 
	return -1;
}

static void
item_exec_callback_wrap(p_mitem, ifact, iter)
    GtkWidget *p_mitem;
    VALUE ifact;
    VALUE iter;
{
    VALUE mitem;

    mitem = rb_obj_alloc(gMenuItem);
    set_widget(mitem, GTK_WIDGET(p_mitem));

    if (!NIL_P(iter)){
	rb_funcall(iter, id_call, 1, mitem);
    }
}

static void // It is the way that this func is called twice.
items_exec_callback_wrap(p_mitem, func_data_ary)
    GtkWidget *p_mitem; 
    VALUE func_data_ary;
{
    VALUE iter, data;

    iter = rb_ary_entry(func_data_ary, 0);
    data = rb_ary_entry(func_data_ary, 1);

    if (!NIL_P(iter)){
	rb_funcall(iter, id_call, 1, data);
    }

    return;
}

static VALUE
ifact_create_item(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE path, accel, item_type;
    GtkItemFactoryEntry *entry;

    rb_scan_args(argc, argv, "12",
		 &path, &accel, &item_type);

    entry = ALLOC(GtkItemFactoryEntry);

    entry->path = NIL_P(path)?NULL:STR2CSTR(path);
    entry->accelerator = NIL_P(accel)?NULL:STR2CSTR(accel);
    entry->item_type = NIL_P(item_type)?NULL:STR2CSTR(item_type);
    entry->callback = item_exec_callback_wrap;
    if (item_type_check(entry->item_type) != 0){
	entry->callback_action = rb_rescue((VALUE(*)())rb_f_lambda, 0, NULL, 0);
    }
  
    if (NIL_P(item_type)){
	gtk_item_factory_create_item(GTK_ITEM_FACTORY(get_gobject(self)),
				     entry, (gpointer)self, cb_type);
    }
    else if (item_type_check(entry->item_type) == 0) {
	entry->callback = NULL;
	entry->callback_action = 0;
	gtk_item_factory_create_item(GTK_ITEM_FACTORY(get_gobject(self)),
				     entry, (gpointer)self, cb_type);
    }
    else {
	gtk_item_factory_create_item(GTK_ITEM_FACTORY(get_gobject(self)),
				     entry, (gpointer)self, cb_type);
    }

    free(entry);

    return Qnil;
}

static VALUE
ifact_create_items(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE rb_entries, cb_data;
    VALUE rb_entry, rb_path, rb_accel, rb_type, rb_func, rb_data;
    GtkItemFactoryEntry *entries;
    GtkAccelGroup *accel_group;
    guint i, n_menu_entries;

    accel_group = gtk_accel_group_new();

    rb_scan_args(argc, argv, "11", &rb_entries, &cb_data);

    n_menu_entries = FIX2INT(rb_funcall(rb_entries, rb_intern("length"), 0));

    entries = ALLOC_N(GtkItemFactoryEntry, n_menu_entries);

    for (i = 0; i < n_menu_entries; i++){
	rb_entry = rb_ary_entry(rb_entries, i);
	Check_Type(rb_entry, T_ARRAY);
	rb_path = rb_ary_entry(rb_entry, 0);
	rb_accel = rb_ary_entry(rb_entry, 1);
	rb_type = rb_ary_entry(rb_entry, 2);
	rb_func = rb_ary_entry(rb_entry, 3);
	rb_data = rb_ary_entry(rb_entry, 4);
	entries[i].path = NIL_P(rb_path)?NULL:STR2CSTR(rb_path);
	entries[i].accelerator = NIL_P(rb_accel)?NULL:STR2CSTR(rb_accel);
	entries[i].item_type = NIL_P(rb_type)?NULL:STR2CSTR(rb_type);
	if (item_type_check(entries[i].item_type) != 0){
	    if (!NIL_P(rb_func)){
		entries[i].callback = items_exec_callback_wrap;
	    }
	    entries[i].callback_action = rb_ary_new3(4, rb_func, rb_data,
						     self, rb_path);
	}
    }

    gtk_item_factory_create_items (GTK_ITEM_FACTORY(get_gobject(self)),
				   n_menu_entries, entries, NULL);
    free(entries);

    return Qnil;
}

static VALUE
ifact_get_widget(self, path)
    VALUE self, path;
{
    VALUE menuobj;
    GtkType gtype;
  
    gtype = (guint)gtk_object_get_data(get_gobject(self), "rbgtk/ifact/type");
    if (gtype == GTK_TYPE_MENU_BAR)
	menuobj = rb_obj_alloc(gMenuBar);
    else if (gtype == GTK_TYPE_MENU)
	menuobj = rb_obj_alloc(gMenu);
    else
	menuobj = rb_obj_alloc(gOptionMenu);
    set_widget(menuobj, gtk_item_factory_get_widget
	       (GTK_ITEM_FACTORY(get_gobject(self)), STR2CSTR(path)));
  
    return menuobj;
}

void Init_gtk_itemfactory()
{
    gItemFactory = rb_define_class_under(mGtk, "ItemFactory", gObject);

    rb_define_const(gItemFactory, "TYPE_MENU_BAR", INT2FIX(GTK_TYPE_MENU_BAR));
    rb_define_const(gItemFactory, "TYPE_MENU", INT2FIX(GTK_TYPE_MENU));
    rb_define_const(gItemFactory, "TYPE_OPTION_MENU",
		    INT2FIX(GTK_TYPE_OPTION_MENU));
  
    rb_define_const(gItemFactory, "TITLE", rb_str_new2("<Title>"));
    rb_define_const(gItemFactory, "ITEM", rb_str_new2("<Item>"));
    rb_define_const(gItemFactory, "CHECK_ITEM", rb_str_new2("<CheckItem>"));
    rb_define_const(gItemFactory, "TOGGLE_ITEM", rb_str_new2("<ToggleItem>"));
    rb_define_const(gItemFactory, "RADIO_ITEM", rb_str_new2("<RadioItem>"));
    rb_define_const(gItemFactory, "SEPARATOR", rb_str_new2("<Separator>"));
    rb_define_const(gItemFactory, "BRANCH", rb_str_new2("<Branch>"));
    rb_define_const(gItemFactory, "LAST_BRANCH", rb_str_new2("<LastBranch>"));
    rb_define_const(gItemFactory, "TEAROFF", rb_str_new2("<Tearoff>"));
  
    rb_define_method(gItemFactory, "initialize", ifact_initialize, 3);
    rb_define_method(gItemFactory, "create_item", ifact_create_item, -1);
    rb_define_method(gItemFactory, "create_items", ifact_create_items, -1);
    rb_define_method(gItemFactory, "get_widget", ifact_get_widget, 1);
}
