/* $Id: rbgnome-font-selector.c,v 1.1.1.1 2000/03/29 18:43:12 iga Exp $ */

#include "rbgnome.h"

/*
 * Class Gnome::FontSelector
 *
 * Description:
 *   A very specialized widget to display "About this program"-like
 *   boxes.
 *
 * Hierarchy:
 *
 *   Object
 *     +----Gtk::Object
 *            +----Gtk::Widget
 *                   +----Gtk::Container
 *                          +----Gtk::Bin
 *                                 +----Gtk::Window
 *                                        +----Gtk::Dialog
 *                                               +----Gnome::FontSelector
 */

VALUE gnoFontSelector;

static VALUE
fontsel_initialize(self)
    VALUE self;
{
    GtkWidget* font_selector;
    font_selector = gnome_font_selector_new();
    set_widget(self, font_selector);
    return Qnil;
}

static VALUE
fontsel_get_selected(self)
    VALUE self;
{
    gchar *font;
    font = gnome_font_selector_get_selected(
	       GNOME_FONT_SELECTOR(get_widget(self)));
}

static VALUE
rbgnome_font_select(argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
    VALUE default_font;
    char* font;

    rb_scan_args(argc, argv, "01", &default_font);
    if (NIL_P(default_font)) {
	font = gnome_font_select();
    } else {
	font = gnome_font_select_with_default(STR2CSTR(default_font));
    }

    return rb_str_new2(font);
}

void
Init_gnome_font_selector()
{
    gnoFontSelector = rb_define_class_under(mGnome, "FongSelector", gDialog);

    /* Instance methods */
    rb_define_method(gnoFontSelector, "get_selected", fontsel_get_selected, 0);

    rb_define_module_function(mGnome, "font_select", rbgnome_font_select, -1);
}
