/* SqliteEPGStore.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from SqliteEPGStore.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <time.h>
#include <stdio.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;

#define DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE (dvb_database_sqlite_sqlite_epg_store_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStore))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_EPG_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE))
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStoreClass))

typedef struct _DVBdatabasesqliteSqliteEPGStore DVBdatabasesqliteSqliteEPGStore;
typedef struct _DVBdatabasesqliteSqliteEPGStoreClass DVBdatabasesqliteSqliteEPGStoreClass;
typedef struct _DVBdatabasesqliteSqliteEPGStorePrivate DVBdatabasesqliteSqliteEPGStorePrivate;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBEventPrivate DVBEventPrivate;

#define DVB_EVENT_TYPE_AUDIO_COMPONENT (dvb_event_audio_component_get_type ())
#define DVB_EVENT_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponent))
#define DVB_EVENT_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))
#define DVB_EVENT_IS_AUDIO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_IS_AUDIO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_AUDIO_COMPONENT))
#define DVB_EVENT_AUDIO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_AUDIO_COMPONENT, DVBEventAudioComponentClass))

typedef struct _DVBEventAudioComponent DVBEventAudioComponent;
typedef struct _DVBEventAudioComponentClass DVBEventAudioComponentClass;

#define DVB_EVENT_TYPE_VIDEO_COMPONENT (dvb_event_video_component_get_type ())
#define DVB_EVENT_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponent))
#define DVB_EVENT_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))
#define DVB_EVENT_IS_VIDEO_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_IS_VIDEO_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_VIDEO_COMPONENT))
#define DVB_EVENT_VIDEO_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_VIDEO_COMPONENT, DVBEventVideoComponentClass))

typedef struct _DVBEventVideoComponent DVBEventVideoComponent;
typedef struct _DVBEventVideoComponentClass DVBEventVideoComponentClass;

#define DVB_EVENT_TYPE_TELETEXT_COMPONENT (dvb_event_teletext_component_get_type ())
#define DVB_EVENT_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponent))
#define DVB_EVENT_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))
#define DVB_EVENT_IS_TELETEXT_COMPONENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_IS_TELETEXT_COMPONENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_EVENT_TYPE_TELETEXT_COMPONENT))
#define DVB_EVENT_TELETEXT_COMPONENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_EVENT_TYPE_TELETEXT_COMPONENT, DVBEventTeletextComponentClass))

typedef struct _DVBEventTeletextComponent DVBEventTeletextComponent;
typedef struct _DVBEventTeletextComponentClass DVBEventTeletextComponentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _dvb_event_unref0(var) ((var == NULL) ? NULL : (var = (dvb_event_unref (var), NULL)))
#define __g_slist_free__dvb_event_audio_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_audio_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_video_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_video_component_unref0_ (var), NULL)))
#define __g_slist_free__dvb_event_teletext_component_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__dvb_event_teletext_component_unref0_ (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};

struct _DVBdatabasesqliteSqliteEPGStore {
	DVBdatabasesqliteSqliteDatabase parent_instance;
	DVBdatabasesqliteSqliteEPGStorePrivate * priv;
};

struct _DVBdatabasesqliteSqliteEPGStoreClass {
	DVBdatabasesqliteSqliteDatabaseClass parent_class;
};

struct _DVBdatabasesqliteSqliteEPGStorePrivate {
	sqlite3_stmt* to_julian_statement;
	sqlite3_stmt* insert_event_statement;
	sqlite3_stmt* update_event_statement;
	sqlite3_stmt* delete_event_statement;
	sqlite3_stmt* has_event_statement;
	sqlite3_stmt* select_event_statement;
	sqlite3_stmt* delete_events_group;
	sqlite3_stmt* delete_expired_events;
};

struct _DVBEvent {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DVBEventPrivate * priv;
	guint id;
	guint year;
	guint month;
	guint hour;
	guint day;
	guint minute;
	guint second;
	guint duration;
	guint running_status;
	gboolean free_ca_mode;
	gchar* name;
	gchar* description;
	gchar* extended_description;
	GSList* audio_components;
	GSList* video_components;
	GSList* teletext_components;
};

struct _DVBEventClass {
	GTypeClass parent_class;
	void (*finalize) (DVBEvent *self);
};


static gpointer dvb_database_sqlite_sqlite_epg_store_parent_class = NULL;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_epg_store_log;
static DVBLoggingLogger* dvb_database_sqlite_sqlite_epg_store_log = NULL;
static DVBdatabaseEPGStoreIface* dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
GType dvb_database_sqlite_sqlite_epg_store_get_type (void) G_GNUC_CONST;
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE, DVBdatabasesqliteSqliteEPGStorePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DUMMY_PROPERTY
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION 2
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT "CREATE TABLE events (group_id INTEGER,\n" \
"            sid INTEGER,\n" \
"            event_id INTEGER,\n" \
"            starttime JULIAN,\n" \
"            duration INTEGER,\n" \
"            running_status INTEGER(2),\n" \
"            free_ca_mode INTEGER(1),\n" \
"            name VARCHAR(255),\n" \
"            description VARCHAR(255),\n" \
"            extended_description TEXT,\n" \
"            PRIMARY KEY (group_id, sid, event_id))"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL "INSERT INTO events VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT "DELETE FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_ALL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id='%u' AND sid='%u'"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT "SELECT event_id, datetime(starttime),\n" \
"            duration FROM events WHERE group_id='%u' AND sid='%u'\n" \
"            ORDER BY starttime ASC"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT "SELECT 1 FROM events WHERE group_id=? AND sid=? AND event_id=? LIMIT 1"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL "UPDATE events SET starttime=?, duration=?, running_status=?,\n" \
"            free_ca_mode=?, name=?, description=?,\n" \
"            extended_description=? WHERE group_id=? AND sid=? AND even" \
"t_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL "SELECT julianday(?)"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL "SELECT event_id, datetime(starttime),\n" \
"            duration, running_status, free_ca_mode, name,\n" \
"            description, extended_description\n" \
"            FROM events WHERE group_id=? AND sid=? AND event_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP "DELETE FROM events WHERE group_id=?"
#define DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS "DELETE FROM events WHERE starttime <= julianday(?, 'unixepoch')\n" \
"        AND sid=? AND group_id=?"
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void);
DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type);
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base);
static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const gchar* sql, GError** error);
static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
gpointer dvb_event_audio_component_ref (gpointer instance);
void dvb_event_audio_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_audio_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_audio_component (GValue* value, gpointer v_object);
void dvb_event_value_take_audio_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_audio_component (const GValue* value);
GType dvb_event_audio_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_video_component_ref (gpointer instance);
void dvb_event_video_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_video_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_video_component (GValue* value, gpointer v_object);
void dvb_event_value_take_video_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_video_component (const GValue* value);
GType dvb_event_video_component_get_type (void) G_GNUC_CONST;
gpointer dvb_event_teletext_component_ref (gpointer instance);
void dvb_event_teletext_component_unref (gpointer instance);
GParamSpec* dvb_event_param_spec_teletext_component (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_event_value_set_teletext_component (GValue* value, gpointer v_object);
void dvb_event_value_take_teletext_component (GValue* value, gpointer v_object);
gpointer dvb_event_value_get_teletext_component (const GValue* value);
GType dvb_event_teletext_component_get_type (void) G_GNUC_CONST;
gchar* dvb_database_sqlite_utils_escape (const gchar* text);
static gdouble dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_database_epg_store_contains_event (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const gchar* errmsg, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error_reset (DVBdatabasesqliteSqliteDatabase* self, sqlite3_stmt* stmnt, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
time_t dvb_event_get_end_timestamp (DVBEvent* self);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error);
static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement);
static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error);
DVBEvent* dvb_event_new (void);
DVBEvent* dvb_event_construct (GType object_type);
gchar* dvb_database_sqlite_utils_unescape (const gchar* text);
static void _dvb_event_audio_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self);
static void _dvb_event_video_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self);
static void _dvb_event_teletext_component_unref0_ (gpointer var);
static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self);
static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj);


DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_construct (GType object_type) {
	DVBdatabasesqliteSqliteEPGStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* cache_dir;
	GFile* _tmp2_ = NULL;
	GFile* our_cache;
	GFile* _tmp3_ = NULL;
	GFile* database_file;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	cache_dir = _tmp1_;
	_tmp2_ = g_file_get_child (cache_dir, "gnome-dvb-daemon");
	our_cache = _tmp2_;
	_tmp3_ = g_file_get_child (our_cache, "eventsdb.sqlite3");
	database_file = _tmp3_;
	self = (DVBdatabasesqliteSqliteEPGStore*) dvb_database_sqlite_sqlite_database_construct (object_type, database_file, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_VERSION);
	_g_object_unref0 (database_file);
	_g_object_unref0 (our_cache);
	_g_object_unref0 (cache_dir);
	return self;
}


DVBdatabasesqliteSqliteEPGStore* dvb_database_sqlite_sqlite_epg_store_new (void) {
	return dvb_database_sqlite_sqlite_epg_store_construct (DVB_DATABASE_SQLITE_TYPE_SQLITE_EPG_STORE);
}


static void dvb_database_sqlite_sqlite_epg_store_real_on_open (DVBdatabasesqliteSqliteDatabase* base) {
	DVBdatabasesqliteSqliteEPGStore * self;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	sqlite3* _tmp4_;
	sqlite3_stmt* _tmp5_ = NULL;
	sqlite3* _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	sqlite3* _tmp8_;
	sqlite3_stmt* _tmp9_ = NULL;
	sqlite3* _tmp10_;
	sqlite3_stmt* _tmp11_ = NULL;
	sqlite3* _tmp12_;
	sqlite3_stmt* _tmp13_ = NULL;
	sqlite3* _tmp14_;
	sqlite3_stmt* _tmp15_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp0_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_TO_JULIAN_SQL, -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (self->priv->to_julian_statement);
	self->priv->to_julian_statement = _tmp1_;
	_tmp2_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp2_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_INSERT_EVENT_SQL, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (self->priv->insert_event_statement);
	self->priv->insert_event_statement = _tmp3_;
	_tmp4_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp4_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_UPDATE_EVENT_SQL, -1, &_tmp5_, NULL);
	_sqlite3_finalize0 (self->priv->update_event_statement);
	self->priv->update_event_statement = _tmp5_;
	_tmp6_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp6_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENT_STATEMENT, -1, &_tmp7_, NULL);
	_sqlite3_finalize0 (self->priv->delete_event_statement);
	self->priv->delete_event_statement = _tmp7_;
	_tmp8_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp8_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_HAS_EVENT_STATEMENT, -1, &_tmp9_, NULL);
	_sqlite3_finalize0 (self->priv->has_event_statement);
	self->priv->has_event_statement = _tmp9_;
	_tmp10_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp10_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_EVENT_SQL, -1, &_tmp11_, NULL);
	_sqlite3_finalize0 (self->priv->select_event_statement);
	self->priv->select_event_statement = _tmp11_;
	_tmp12_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp12_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EVENTS_GROUP, -1, &_tmp13_, NULL);
	_sqlite3_finalize0 (self->priv->delete_events_group);
	self->priv->delete_events_group = _tmp13_;
	_tmp14_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	sqlite3_prepare (_tmp14_, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_DELETE_EXPIRED_EVENTS, -1, &_tmp15_, NULL);
	_sqlite3_finalize0 (self->priv->delete_expired_events);
	self->priv->delete_expired_events = _tmp15_;
}


static void dvb_database_sqlite_sqlite_epg_store_real_create (DVBdatabasesqliteSqliteDatabase* base, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_CREATE_EVENTS_TABLE_STATEMENT, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void dvb_database_sqlite_sqlite_epg_store_real_upgrade (DVBdatabasesqliteSqliteDatabase* base, gint old_version, gint new_version, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gint _tmp0_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = old_version;
	if (_tmp0_ == 1) {
		dvb_database_sqlite_sqlite_database_exec_sql ((DVBdatabasesqliteSqliteDatabase*) self, "PRAGMA synchronous=OFF", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	DVBEvent* _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint free_ca_mode;
	DVBEvent* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* name;
	DVBEvent* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* desc;
	DVBEvent* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* ext_desc;
	DVBEvent* _tmp13_;
	guint _tmp14_;
	DVBEvent* _tmp15_;
	guint _tmp16_;
	DVBEvent* _tmp17_;
	guint _tmp18_;
	DVBEvent* _tmp19_;
	guint _tmp20_;
	DVBEvent* _tmp21_;
	guint _tmp22_;
	DVBEvent* _tmp23_;
	guint _tmp24_;
	gdouble _tmp25_ = 0.0;
	gdouble julian_start;
	gdouble _tmp26_;
	DVBEvent* _tmp28_;
	guint _tmp29_;
	guint _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->free_ca_mode;
	if (_tmp2_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp3_ = _tmp0_;
	free_ca_mode = _tmp3_;
	_tmp4_ = event;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = dvb_database_sqlite_utils_escape (_tmp5_);
	name = _tmp6_;
	_tmp7_ = event;
	_tmp8_ = _tmp7_->description;
	_tmp9_ = dvb_database_sqlite_utils_escape (_tmp8_);
	desc = _tmp9_;
	_tmp10_ = event;
	_tmp11_ = _tmp10_->extended_description;
	_tmp12_ = dvb_database_sqlite_utils_escape (_tmp11_);
	ext_desc = _tmp12_;
	_tmp13_ = event;
	_tmp14_ = _tmp13_->year;
	_tmp15_ = event;
	_tmp16_ = _tmp15_->month;
	_tmp17_ = event;
	_tmp18_ = _tmp17_->day;
	_tmp19_ = event;
	_tmp20_ = _tmp19_->hour;
	_tmp21_ = event;
	_tmp22_ = _tmp21_->minute;
	_tmp23_ = event;
	_tmp24_ = _tmp23_->second;
	_tmp25_ = dvb_database_sqlite_sqlite_epg_store_to_julian (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, _tmp24_, &_inner_error_);
	julian_start = _tmp25_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp26_ = julian_start;
	if (_tmp26_ <= ((gdouble) 0)) {
		DVBLoggingLogger* _tmp27_;
		_tmp27_ = dvb_database_sqlite_sqlite_epg_store_log;
		dvb_logging_logger_warning (_tmp27_, "SqliteEPGStore.vala:150: Failed to convert start time");
		result = FALSE;
		_g_free0 (ext_desc);
		_g_free0 (desc);
		_g_free0 (name);
		return result;
	}
	_tmp28_ = event;
	_tmp29_ = channel_sid;
	_tmp30_ = group_id;
	_tmp31_ = dvb_database_epg_store_contains_event ((DVBdatabaseEPGStore*) self, _tmp28_, _tmp29_, _tmp30_, &_inner_error_);
	_tmp32_ = _tmp31_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return FALSE;
		} else {
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (_tmp32_) {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		gboolean _tmp41_ = FALSE;
		sqlite3_stmt* _tmp42_;
		gdouble _tmp43_;
		gint _tmp44_ = 0;
		gboolean _tmp49_;
		gboolean _tmp54_;
		gboolean _tmp58_;
		gboolean _tmp64_;
		gboolean _tmp70_;
		gboolean _tmp76_;
		gboolean _tmp80_;
		gboolean _tmp84_;
		gboolean _tmp89_;
		sqlite3_stmt* _tmp90_;
		gint _tmp91_ = 0;
		sqlite3_stmt* _tmp93_;
		_tmp42_ = self->priv->update_event_statement;
		_tmp43_ = julian_start;
		_tmp44_ = sqlite3_bind_double (_tmp42_, 1, _tmp43_);
		if (_tmp44_ != SQLITE_OK) {
			_tmp41_ = TRUE;
		} else {
			sqlite3_stmt* _tmp45_;
			DVBEvent* _tmp46_;
			guint _tmp47_;
			gint _tmp48_ = 0;
			_tmp45_ = self->priv->update_event_statement;
			_tmp46_ = event;
			_tmp47_ = _tmp46_->duration;
			_tmp48_ = sqlite3_bind_int (_tmp45_, 2, (gint) _tmp47_);
			_tmp41_ = _tmp48_ != SQLITE_OK;
		}
		_tmp49_ = _tmp41_;
		if (_tmp49_) {
			_tmp40_ = TRUE;
		} else {
			sqlite3_stmt* _tmp50_;
			DVBEvent* _tmp51_;
			guint _tmp52_;
			gint _tmp53_ = 0;
			_tmp50_ = self->priv->update_event_statement;
			_tmp51_ = event;
			_tmp52_ = _tmp51_->running_status;
			_tmp53_ = sqlite3_bind_int (_tmp50_, 3, (gint) _tmp52_);
			_tmp40_ = _tmp53_ != SQLITE_OK;
		}
		_tmp54_ = _tmp40_;
		if (_tmp54_) {
			_tmp39_ = TRUE;
		} else {
			sqlite3_stmt* _tmp55_;
			gint _tmp56_;
			gint _tmp57_ = 0;
			_tmp55_ = self->priv->update_event_statement;
			_tmp56_ = free_ca_mode;
			_tmp57_ = sqlite3_bind_int (_tmp55_, 4, _tmp56_);
			_tmp39_ = _tmp57_ != SQLITE_OK;
		}
		_tmp58_ = _tmp39_;
		if (_tmp58_) {
			_tmp38_ = TRUE;
		} else {
			sqlite3_stmt* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			GDestroyNotify _tmp62_;
			gint _tmp63_ = 0;
			_tmp59_ = self->priv->update_event_statement;
			_tmp60_ = name;
			_tmp61_ = g_strdup (_tmp60_);
			_tmp62_ = g_free;
			_tmp63_ = sqlite3_bind_text (_tmp59_, 5, _tmp61_, -1, _tmp62_);
			_tmp38_ = _tmp63_ != SQLITE_OK;
		}
		_tmp64_ = _tmp38_;
		if (_tmp64_) {
			_tmp37_ = TRUE;
		} else {
			sqlite3_stmt* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			GDestroyNotify _tmp68_;
			gint _tmp69_ = 0;
			_tmp65_ = self->priv->update_event_statement;
			_tmp66_ = desc;
			_tmp67_ = g_strdup (_tmp66_);
			_tmp68_ = g_free;
			_tmp69_ = sqlite3_bind_text (_tmp65_, 6, _tmp67_, -1, _tmp68_);
			_tmp37_ = _tmp69_ != SQLITE_OK;
		}
		_tmp70_ = _tmp37_;
		if (_tmp70_) {
			_tmp36_ = TRUE;
		} else {
			sqlite3_stmt* _tmp71_;
			const gchar* _tmp72_;
			gchar* _tmp73_;
			GDestroyNotify _tmp74_;
			gint _tmp75_ = 0;
			_tmp71_ = self->priv->update_event_statement;
			_tmp72_ = ext_desc;
			_tmp73_ = g_strdup (_tmp72_);
			_tmp74_ = g_free;
			_tmp75_ = sqlite3_bind_text (_tmp71_, 7, _tmp73_, -1, _tmp74_);
			_tmp36_ = _tmp75_ != SQLITE_OK;
		}
		_tmp76_ = _tmp36_;
		if (_tmp76_) {
			_tmp35_ = TRUE;
		} else {
			sqlite3_stmt* _tmp77_;
			guint _tmp78_;
			gint _tmp79_ = 0;
			_tmp77_ = self->priv->update_event_statement;
			_tmp78_ = group_id;
			_tmp79_ = sqlite3_bind_int (_tmp77_, 8, (gint) _tmp78_);
			_tmp35_ = _tmp79_ != SQLITE_OK;
		}
		_tmp80_ = _tmp35_;
		if (_tmp80_) {
			_tmp34_ = TRUE;
		} else {
			sqlite3_stmt* _tmp81_;
			guint _tmp82_;
			gint _tmp83_ = 0;
			_tmp81_ = self->priv->update_event_statement;
			_tmp82_ = channel_sid;
			_tmp83_ = sqlite3_bind_int (_tmp81_, 9, (gint) _tmp82_);
			_tmp34_ = _tmp83_ != SQLITE_OK;
		}
		_tmp84_ = _tmp34_;
		if (_tmp84_) {
			_tmp33_ = TRUE;
		} else {
			sqlite3_stmt* _tmp85_;
			DVBEvent* _tmp86_;
			guint _tmp87_;
			gint _tmp88_ = 0;
			_tmp85_ = self->priv->update_event_statement;
			_tmp86_ = event;
			_tmp87_ = _tmp86_->id;
			_tmp88_ = sqlite3_bind_int (_tmp85_, 10, (gint) _tmp87_);
			_tmp33_ = _tmp88_ != SQLITE_OK;
		}
		_tmp89_ = _tmp33_;
		if (_tmp89_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp90_ = self->priv->update_event_statement;
		_tmp91_ = sqlite3_step (_tmp90_);
		if (_tmp91_ != SQLITE_DONE) {
			sqlite3_stmt* _tmp92_;
			_tmp92_ = self->priv->update_event_statement;
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp92_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp93_ = self->priv->update_event_statement;
		sqlite3_reset (_tmp93_);
	} else {
		gboolean _tmp94_ = FALSE;
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_ = FALSE;
		gboolean _tmp99_ = FALSE;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		sqlite3_stmt* _tmp103_;
		guint _tmp104_;
		gint _tmp105_ = 0;
		gboolean _tmp109_;
		gboolean _tmp114_;
		gboolean _tmp118_;
		gboolean _tmp123_;
		gboolean _tmp128_;
		gboolean _tmp132_;
		gboolean _tmp138_;
		gboolean _tmp144_;
		gboolean _tmp150_;
		sqlite3_stmt* _tmp151_;
		gint _tmp152_ = 0;
		sqlite3_stmt* _tmp154_;
		_tmp103_ = self->priv->insert_event_statement;
		_tmp104_ = group_id;
		_tmp105_ = sqlite3_bind_int (_tmp103_, 1, (gint) _tmp104_);
		if (_tmp105_ != SQLITE_OK) {
			_tmp102_ = TRUE;
		} else {
			sqlite3_stmt* _tmp106_;
			guint _tmp107_;
			gint _tmp108_ = 0;
			_tmp106_ = self->priv->insert_event_statement;
			_tmp107_ = channel_sid;
			_tmp108_ = sqlite3_bind_int (_tmp106_, 2, (gint) _tmp107_);
			_tmp102_ = _tmp108_ != SQLITE_OK;
		}
		_tmp109_ = _tmp102_;
		if (_tmp109_) {
			_tmp101_ = TRUE;
		} else {
			sqlite3_stmt* _tmp110_;
			DVBEvent* _tmp111_;
			guint _tmp112_;
			gint _tmp113_ = 0;
			_tmp110_ = self->priv->insert_event_statement;
			_tmp111_ = event;
			_tmp112_ = _tmp111_->id;
			_tmp113_ = sqlite3_bind_int (_tmp110_, 3, (gint) _tmp112_);
			_tmp101_ = _tmp113_ != SQLITE_OK;
		}
		_tmp114_ = _tmp101_;
		if (_tmp114_) {
			_tmp100_ = TRUE;
		} else {
			sqlite3_stmt* _tmp115_;
			gdouble _tmp116_;
			gint _tmp117_ = 0;
			_tmp115_ = self->priv->insert_event_statement;
			_tmp116_ = julian_start;
			_tmp117_ = sqlite3_bind_double (_tmp115_, 4, _tmp116_);
			_tmp100_ = _tmp117_ != SQLITE_OK;
		}
		_tmp118_ = _tmp100_;
		if (_tmp118_) {
			_tmp99_ = TRUE;
		} else {
			sqlite3_stmt* _tmp119_;
			DVBEvent* _tmp120_;
			guint _tmp121_;
			gint _tmp122_ = 0;
			_tmp119_ = self->priv->insert_event_statement;
			_tmp120_ = event;
			_tmp121_ = _tmp120_->duration;
			_tmp122_ = sqlite3_bind_int (_tmp119_, 5, (gint) _tmp121_);
			_tmp99_ = _tmp122_ != SQLITE_OK;
		}
		_tmp123_ = _tmp99_;
		if (_tmp123_) {
			_tmp98_ = TRUE;
		} else {
			sqlite3_stmt* _tmp124_;
			DVBEvent* _tmp125_;
			guint _tmp126_;
			gint _tmp127_ = 0;
			_tmp124_ = self->priv->insert_event_statement;
			_tmp125_ = event;
			_tmp126_ = _tmp125_->running_status;
			_tmp127_ = sqlite3_bind_int (_tmp124_, 6, (gint) _tmp126_);
			_tmp98_ = _tmp127_ != SQLITE_OK;
		}
		_tmp128_ = _tmp98_;
		if (_tmp128_) {
			_tmp97_ = TRUE;
		} else {
			sqlite3_stmt* _tmp129_;
			gint _tmp130_;
			gint _tmp131_ = 0;
			_tmp129_ = self->priv->insert_event_statement;
			_tmp130_ = free_ca_mode;
			_tmp131_ = sqlite3_bind_int (_tmp129_, 7, _tmp130_);
			_tmp97_ = _tmp131_ != SQLITE_OK;
		}
		_tmp132_ = _tmp97_;
		if (_tmp132_) {
			_tmp96_ = TRUE;
		} else {
			sqlite3_stmt* _tmp133_;
			const gchar* _tmp134_;
			gchar* _tmp135_;
			GDestroyNotify _tmp136_;
			gint _tmp137_ = 0;
			_tmp133_ = self->priv->insert_event_statement;
			_tmp134_ = name;
			_tmp135_ = g_strdup (_tmp134_);
			_tmp136_ = g_free;
			_tmp137_ = sqlite3_bind_text (_tmp133_, 8, _tmp135_, -1, _tmp136_);
			_tmp96_ = _tmp137_ != SQLITE_OK;
		}
		_tmp138_ = _tmp96_;
		if (_tmp138_) {
			_tmp95_ = TRUE;
		} else {
			sqlite3_stmt* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			GDestroyNotify _tmp142_;
			gint _tmp143_ = 0;
			_tmp139_ = self->priv->insert_event_statement;
			_tmp140_ = desc;
			_tmp141_ = g_strdup (_tmp140_);
			_tmp142_ = g_free;
			_tmp143_ = sqlite3_bind_text (_tmp139_, 9, _tmp141_, -1, _tmp142_);
			_tmp95_ = _tmp143_ != SQLITE_OK;
		}
		_tmp144_ = _tmp95_;
		if (_tmp144_) {
			_tmp94_ = TRUE;
		} else {
			sqlite3_stmt* _tmp145_;
			const gchar* _tmp146_;
			gchar* _tmp147_;
			GDestroyNotify _tmp148_;
			gint _tmp149_ = 0;
			_tmp145_ = self->priv->insert_event_statement;
			_tmp146_ = ext_desc;
			_tmp147_ = g_strdup (_tmp146_);
			_tmp148_ = g_free;
			_tmp149_ = sqlite3_bind_text (_tmp145_, 10, _tmp147_, -1, _tmp148_);
			_tmp94_ = _tmp149_ != SQLITE_OK;
		}
		_tmp150_ = _tmp94_;
		if (_tmp150_) {
			dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp151_ = self->priv->insert_event_statement;
		_tmp152_ = sqlite3_step (_tmp151_);
		if (_tmp152_ != SQLITE_DONE) {
			sqlite3_stmt* _tmp153_;
			_tmp153_ = self->priv->insert_event_statement;
			dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp153_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					return FALSE;
				} else {
					_g_free0 (ext_desc);
					_g_free0 (desc);
					_g_free0 (name);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
			result = FALSE;
			_g_free0 (ext_desc);
			_g_free0 (desc);
			_g_free0 (name);
			return result;
		}
		_tmp154_ = self->priv->insert_event_statement;
		sqlite3_reset (_tmp154_);
	}
	result = TRUE;
	_g_free0 (ext_desc);
	_g_free0 (desc);
	_g_free0 (name);
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_real_get_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	DVBEvent* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp8_;
	gboolean _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint _tmp14_ = 0;
	gint rc;
	gboolean _tmp15_ = FALSE;
	gint _tmp16_;
	gboolean _tmp18_;
	DVBEvent* event;
	gint _tmp20_;
	sqlite3_stmt* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp2_ = self->priv->select_event_statement;
	_tmp3_ = group_id;
	_tmp4_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp3_);
	if (_tmp4_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp5_;
		guint _tmp6_;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->select_event_statement;
		_tmp6_ = channel_sid;
		_tmp7_ = sqlite3_bind_int (_tmp5_, 2, (gint) _tmp6_);
		_tmp1_ = _tmp7_ != SQLITE_OK;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp9_;
		guint _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->select_event_statement;
		_tmp10_ = event_id;
		_tmp11_ = sqlite3_bind_int (_tmp9_, 3, (gint) _tmp10_);
		_tmp0_ = _tmp11_ != SQLITE_OK;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	_tmp13_ = self->priv->select_event_statement;
	_tmp14_ = sqlite3_step (_tmp13_);
	rc = _tmp14_;
	_tmp16_ = rc;
	if (_tmp16_ != SQLITE_ROW) {
		gint _tmp17_;
		_tmp17_ = rc;
		_tmp15_ = _tmp17_ != SQLITE_DONE;
	} else {
		_tmp15_ = FALSE;
	}
	_tmp18_ = _tmp15_;
	if (_tmp18_) {
		sqlite3_stmt* _tmp19_;
		_tmp19_ = self->priv->select_event_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp19_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = NULL;
		return result;
	}
	event = NULL;
	_tmp20_ = rc;
	if (_tmp20_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp21_;
		DVBEvent* _tmp22_ = NULL;
		_tmp21_ = self->priv->select_event_statement;
		_tmp22_ = dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (self, _tmp21_);
		_dvb_event_unref0 (event);
		event = _tmp22_;
	}
	_tmp23_ = self->priv->select_event_statement;
	sqlite3_reset (_tmp23_);
	result = event;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_event (DVBdatabaseEPGStore* base, guint event_id, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp8_;
	gboolean _tmp12_;
	sqlite3_stmt* _tmp13_;
	gint _tmp14_ = 0;
	sqlite3_stmt* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp2_ = self->priv->delete_event_statement;
	_tmp3_ = group_id;
	_tmp4_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp3_);
	if (_tmp4_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp5_;
		guint _tmp6_;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->delete_event_statement;
		_tmp6_ = channel_sid;
		_tmp7_ = sqlite3_bind_int (_tmp5_, 2, (gint) _tmp6_);
		_tmp1_ = _tmp7_ != SQLITE_OK;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp9_;
		guint _tmp10_;
		gint _tmp11_ = 0;
		_tmp9_ = self->priv->delete_event_statement;
		_tmp10_ = event_id;
		_tmp11_ = sqlite3_bind_int (_tmp9_, 3, (gint) _tmp10_);
		_tmp0_ = _tmp11_ != SQLITE_OK;
	}
	_tmp12_ = _tmp0_;
	if (_tmp12_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->delete_event_statement;
	_tmp14_ = sqlite3_step (_tmp13_);
	if (_tmp14_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp15_;
		_tmp15_ = self->priv->delete_event_statement;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp15_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->delete_event_statement;
	sqlite3_reset (_tmp16_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	DVBEvent* _tmp0_;
	time_t _tmp1_ = 0;
	time_t timestamp;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	sqlite3_stmt* _tmp4_;
	time_t _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp10_;
	gboolean _tmp14_;
	sqlite3_stmt* _tmp15_;
	gint _tmp16_ = 0;
	sqlite3_stmt* _tmp18_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = dvb_event_get_end_timestamp (_tmp0_);
	timestamp = _tmp1_;
	_tmp4_ = self->priv->delete_expired_events;
	_tmp5_ = timestamp;
	_tmp6_ = sqlite3_bind_int64 (_tmp4_, 1, (gint64) _tmp5_);
	if (_tmp6_ != SQLITE_OK) {
		_tmp3_ = TRUE;
	} else {
		sqlite3_stmt* _tmp7_;
		guint _tmp8_;
		gint _tmp9_ = 0;
		_tmp7_ = self->priv->delete_expired_events;
		_tmp8_ = channel_sid;
		_tmp9_ = sqlite3_bind_int (_tmp7_, 2, (gint) _tmp8_);
		_tmp3_ = _tmp9_ != SQLITE_OK;
	}
	_tmp10_ = _tmp3_;
	if (_tmp10_) {
		_tmp2_ = TRUE;
	} else {
		sqlite3_stmt* _tmp11_;
		guint _tmp12_;
		gint _tmp13_ = 0;
		_tmp11_ = self->priv->delete_expired_events;
		_tmp12_ = group_id;
		_tmp13_ = sqlite3_bind_int (_tmp11_, 3, (gint) _tmp12_);
		_tmp2_ = _tmp13_ != SQLITE_OK;
	}
	_tmp14_ = _tmp2_;
	if (_tmp14_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp15_ = self->priv->delete_expired_events;
	_tmp16_ = sqlite3_step (_tmp15_);
	if (_tmp16_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp17_;
		_tmp17_ = self->priv->delete_expired_events;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp17_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->delete_expired_events;
	sqlite3_reset (_tmp18_);
	result = TRUE;
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_contains_event (DVBdatabaseEPGStore* base, DVBEvent* event, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	sqlite3_stmt* _tmp2_;
	guint _tmp3_;
	gint _tmp4_ = 0;
	gboolean _tmp8_;
	gboolean _tmp13_;
	gint c;
	sqlite3_stmt* _tmp18_;
	gint _tmp19_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->has_event_statement;
	_tmp3_ = group_id;
	_tmp4_ = sqlite3_bind_int (_tmp2_, 1, (gint) _tmp3_);
	if (_tmp4_ != SQLITE_OK) {
		_tmp1_ = TRUE;
	} else {
		sqlite3_stmt* _tmp5_;
		guint _tmp6_;
		gint _tmp7_ = 0;
		_tmp5_ = self->priv->has_event_statement;
		_tmp6_ = channel_sid;
		_tmp7_ = sqlite3_bind_int (_tmp5_, 2, (gint) _tmp6_);
		_tmp1_ = _tmp7_ != SQLITE_OK;
	}
	_tmp8_ = _tmp1_;
	if (_tmp8_) {
		_tmp0_ = TRUE;
	} else {
		sqlite3_stmt* _tmp9_;
		DVBEvent* _tmp10_;
		guint _tmp11_;
		gint _tmp12_ = 0;
		_tmp9_ = self->priv->has_event_statement;
		_tmp10_ = event;
		_tmp11_ = _tmp10_->id;
		_tmp12_ = sqlite3_bind_int (_tmp9_, 3, (gint) _tmp11_);
		_tmp0_ = _tmp12_ != SQLITE_OK;
	}
	_tmp13_ = _tmp0_;
	if (_tmp13_) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	c = 0;
	while (TRUE) {
		sqlite3_stmt* _tmp14_;
		gint _tmp15_ = 0;
		sqlite3_stmt* _tmp16_;
		gint _tmp17_ = 0;
		_tmp14_ = self->priv->has_event_statement;
		_tmp15_ = sqlite3_step (_tmp14_);
		if (!(_tmp15_ == SQLITE_ROW)) {
			break;
		}
		_tmp16_ = self->priv->has_event_statement;
		_tmp17_ = sqlite3_column_int (_tmp16_, 0);
		c = _tmp17_;
	}
	_tmp18_ = self->priv->has_event_statement;
	sqlite3_reset (_tmp18_);
	_tmp19_ = c;
	result = _tmp19_ > 0;
	return result;
}


static GeeList* dvb_database_sqlite_sqlite_epg_store_real_get_events (DVBdatabaseEPGStore* base, guint channel_sid, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeList* events;
	sqlite3* _tmp1_;
	guint _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* statement_str;
	sqlite3_stmt* statement = NULL;
	sqlite3* _tmp6_;
	const gchar* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = gee_array_list_new (DVB_TYPE_EVENT, (GBoxedCopyFunc) dvb_event_ref, dvb_event_unref, NULL);
	events = (GeeList*) _tmp0_;
	_tmp1_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	if (_tmp1_ == NULL) {
		DVBLoggingLogger* _tmp2_;
		_tmp2_ = dvb_database_sqlite_sqlite_epg_store_log;
		dvb_logging_logger_warning (_tmp2_, "SqliteEPGStore.vala:295: DB not initialized");
		result = events;
		return result;
	}
	_tmp3_ = group_id;
	_tmp4_ = channel_sid;
	_tmp5_ = g_strdup_printf (DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_SELECT_MINIMAL_EVENTS_STATEMENT, _tmp3_, _tmp4_);
	statement_str = _tmp5_;
	_tmp6_ = ((DVBdatabasesqliteSqliteDatabase*) self)->db;
	_tmp7_ = statement_str;
	_tmp9_ = sqlite3_prepare (_tmp6_, _tmp7_, -1, &_tmp8_, NULL);
	_sqlite3_finalize0 (statement);
	statement = _tmp8_;
	if (_tmp9_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				_g_free0 (statement_str);
				_g_object_unref0 (events);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = events;
		_sqlite3_finalize0 (statement);
		_g_free0 (statement_str);
		return result;
	}
	while (TRUE) {
		sqlite3_stmt* _tmp10_;
		gint _tmp11_ = 0;
		sqlite3_stmt* _tmp12_;
		DVBEvent* _tmp13_ = NULL;
		DVBEvent* event;
		GeeList* _tmp14_;
		DVBEvent* _tmp15_;
		_tmp10_ = statement;
		_tmp11_ = sqlite3_step (_tmp10_);
		if (!(_tmp11_ == SQLITE_ROW)) {
			break;
		}
		_tmp12_ = statement;
		_tmp13_ = dvb_database_sqlite_sqlite_epg_store_create_minimal_event (self, _tmp12_);
		event = _tmp13_;
		_tmp14_ = events;
		_tmp15_ = event;
		gee_collection_add ((GeeCollection*) _tmp14_, _tmp15_);
		_dvb_event_unref0 (event);
	}
	result = events;
	_sqlite3_finalize0 (statement);
	_g_free0 (statement_str);
	return result;
}


static gboolean dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group (DVBdatabaseEPGStore* base, guint group_id, GError** error) {
	DVBdatabasesqliteSqliteEPGStore * self;
	gboolean result = FALSE;
	sqlite3_stmt* _tmp0_;
	guint _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (DVBdatabasesqliteSqliteEPGStore*) base;
	_tmp0_ = self->priv->delete_events_group;
	_tmp1_ = group_id;
	_tmp2_ = sqlite3_bind_int (_tmp0_, 1, (gint) _tmp1_);
	if (_tmp2_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->delete_events_group;
	_tmp4_ = sqlite3_step (_tmp3_);
	if (_tmp4_ != SQLITE_DONE) {
		sqlite3_stmt* _tmp5_;
		_tmp5_ = self->priv->delete_events_group;
		dvb_database_sqlite_sqlite_database_throw_last_error_reset ((DVBdatabasesqliteSqliteDatabase*) self, _tmp5_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->delete_events_group;
	sqlite3_reset (_tmp6_);
	result = TRUE;
	return result;
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_minimal_event (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* _tmp0_;
	DVBEvent* event;
	sqlite3_stmt* _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* starttime;
	sqlite3_stmt* _tmp5_;
	gint _tmp6_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = dvb_event_new ();
	event = _tmp0_;
	_tmp1_ = statement;
	_tmp2_ = sqlite3_column_int (_tmp1_, 0);
	event->id = (guint) _tmp2_;
	_tmp3_ = statement;
	_tmp4_ = sqlite3_column_text (_tmp3_, 1);
	starttime = _tmp4_;
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_int (_tmp5_, 2);
	event->duration = (guint) _tmp6_;
	result = event;
	return result;
}


static void _dvb_event_audio_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_audio_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_audio_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_audio_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_video_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_video_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_video_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_video_component_unref0_, NULL);
	g_slist_free (self);
}


static void _dvb_event_teletext_component_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (dvb_event_teletext_component_unref (var), NULL));
}


static void _g_slist_free__dvb_event_teletext_component_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _dvb_event_teletext_component_unref0_, NULL);
	g_slist_free (self);
}


static DVBEvent* dvb_database_sqlite_sqlite_epg_store_create_event_from_statement (DVBdatabasesqliteSqliteEPGStore* self, sqlite3_stmt* statement) {
	DVBEvent* result = NULL;
	DVBEvent* _tmp0_;
	DVBEvent* event;
	sqlite3_stmt* _tmp1_;
	gint _tmp2_ = 0;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* starttime;
	sqlite3_stmt* _tmp5_;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	sqlite3_stmt* _tmp17_;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	_tmp0_ = dvb_event_new ();
	event = _tmp0_;
	_tmp1_ = statement;
	_tmp2_ = sqlite3_column_int (_tmp1_, 0);
	event->id = (guint) _tmp2_;
	_tmp3_ = statement;
	_tmp4_ = sqlite3_column_text (_tmp3_, 1);
	starttime = _tmp4_;
	sscanf (starttime, "%04u-%02u-%02u %02u:%02u:%02u", &event->year, &event->month, &event->day, &event->hour, &event->minute, &event->second);
	_tmp5_ = statement;
	_tmp6_ = sqlite3_column_int (_tmp5_, 2);
	event->duration = (guint) _tmp6_;
	_tmp7_ = statement;
	_tmp8_ = sqlite3_column_int (_tmp7_, 3);
	event->running_status = (guint) _tmp8_;
	_tmp9_ = statement;
	_tmp10_ = sqlite3_column_int (_tmp9_, 4);
	event->free_ca_mode = _tmp10_ == 1;
	_tmp11_ = statement;
	_tmp12_ = sqlite3_column_text (_tmp11_, 5);
	_tmp13_ = dvb_database_sqlite_utils_unescape (_tmp12_);
	_g_free0 (event->name);
	event->name = _tmp13_;
	_tmp14_ = statement;
	_tmp15_ = sqlite3_column_text (_tmp14_, 6);
	_tmp16_ = dvb_database_sqlite_utils_unescape (_tmp15_);
	_g_free0 (event->description);
	event->description = _tmp16_;
	_tmp17_ = statement;
	_tmp18_ = sqlite3_column_text (_tmp17_, 7);
	_tmp19_ = dvb_database_sqlite_utils_unescape (_tmp18_);
	_g_free0 (event->extended_description);
	event->extended_description = _tmp19_;
	__g_slist_free__dvb_event_audio_component_unref0_0 (event->audio_components);
	event->audio_components = NULL;
	__g_slist_free__dvb_event_video_component_unref0_0 (event->video_components);
	event->video_components = NULL;
	__g_slist_free__dvb_event_teletext_component_unref0_0 (event->teletext_components);
	event->teletext_components = NULL;
	result = event;
	return result;
}


static gdouble dvb_database_sqlite_sqlite_epg_store_to_julian (DVBdatabasesqliteSqliteEPGStore* self, guint year, guint month, guint day, guint hour, guint minute, guint second, GError** error) {
	gdouble result = 0.0;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* datetime_str;
	sqlite3_stmt* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GDestroyNotify _tmp10_;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp14_;
	gdouble _tmp15_ = 0.0;
	gdouble val;
	sqlite3_stmt* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = year;
	_tmp1_ = month;
	_tmp2_ = day;
	_tmp3_ = hour;
	_tmp4_ = minute;
	_tmp5_ = second;
	_tmp6_ = g_strdup_printf ("%04u-%02u-%02u %02u:%02u:%02u", _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
	datetime_str = _tmp6_;
	_tmp7_ = self->priv->to_julian_statement;
	_tmp8_ = datetime_str;
	_tmp9_ = g_strdup (_tmp8_);
	_tmp10_ = g_free;
	_tmp11_ = sqlite3_bind_text (_tmp7_, 1, _tmp9_, -1, _tmp10_);
	if (_tmp11_ != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (gdouble) 0;
		_g_free0 (datetime_str);
		return result;
	}
	_tmp12_ = self->priv->to_julian_statement;
	_tmp13_ = sqlite3_step (_tmp12_);
	if (_tmp13_ != SQLITE_ROW) {
		dvb_database_sqlite_sqlite_database_throw_last_error ((DVBdatabasesqliteSqliteDatabase*) self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (datetime_str);
				return 0.0;
			} else {
				_g_free0 (datetime_str);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0;
			}
		}
		result = (gdouble) 0;
		_g_free0 (datetime_str);
		return result;
	}
	_tmp14_ = self->priv->to_julian_statement;
	_tmp15_ = sqlite3_column_double (_tmp14_, 0);
	val = _tmp15_;
	_tmp16_ = self->priv->to_julian_statement;
	sqlite3_reset (_tmp16_);
	result = val;
	_g_free0 (datetime_str);
	return result;
}


static void dvb_database_sqlite_sqlite_epg_store_class_init (DVBdatabasesqliteSqliteEPGStoreClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_database_sqlite_sqlite_epg_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteEPGStorePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_epg_store_real_on_open;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_epg_store_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_epg_store_real_upgrade;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_epg_store_finalize;
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_database_sqlite_sqlite_epg_store_log = _tmp1_;
}


static void dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init (DVBdatabaseEPGStoreIface * iface) {
	dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_or_update_event = (gboolean (*)(DVBdatabaseEPGStore*, DVBEvent*, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_add_or_update_event;
	iface->get_event = (DVBEvent* (*)(DVBdatabaseEPGStore*, guint, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_get_event;
	iface->remove_event = (gboolean (*)(DVBdatabaseEPGStore*, guint, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_event;
	iface->remove_events_older_than = (gboolean (*)(DVBdatabaseEPGStore*, DVBEvent*, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_events_older_than;
	iface->contains_event = (gboolean (*)(DVBdatabaseEPGStore*, DVBEvent*, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_contains_event;
	iface->get_events = (GeeList* (*)(DVBdatabaseEPGStore*, guint, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_get_events;
	iface->remove_events_of_group = (gboolean (*)(DVBdatabaseEPGStore*, guint, GError**)) dvb_database_sqlite_sqlite_epg_store_real_remove_events_of_group;
}


static void dvb_database_sqlite_sqlite_epg_store_instance_init (DVBdatabasesqliteSqliteEPGStore * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_epg_store_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteEPGStore * self;
	self = DVB_DATABASE_SQLITE_SQLITE_EPG_STORE (obj);
	_sqlite3_finalize0 (self->priv->to_julian_statement);
	_sqlite3_finalize0 (self->priv->insert_event_statement);
	_sqlite3_finalize0 (self->priv->update_event_statement);
	_sqlite3_finalize0 (self->priv->delete_event_statement);
	_sqlite3_finalize0 (self->priv->has_event_statement);
	_sqlite3_finalize0 (self->priv->select_event_statement);
	_sqlite3_finalize0 (self->priv->delete_events_group);
	_sqlite3_finalize0 (self->priv->delete_expired_events);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_epg_store_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_epg_store_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_epg_store_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteEPGStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_epg_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteEPGStore), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_epg_store_instance_init, NULL };
		static const GInterfaceInfo dvb_database_epg_store_info = { (GInterfaceInitFunc) dvb_database_sqlite_sqlite_epg_store_dvb_database_epg_store_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_database_sqlite_sqlite_epg_store_type_id;
		dvb_database_sqlite_sqlite_epg_store_type_id = g_type_register_static (DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, "DVBdatabasesqliteSqliteEPGStore", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_database_sqlite_sqlite_epg_store_type_id, DVB_DATABASE_TYPE_EPG_STORE, &dvb_database_epg_store_info);
		g_once_init_leave (&dvb_database_sqlite_sqlite_epg_store_type_id__volatile, dvb_database_sqlite_sqlite_epg_store_type_id);
	}
	return dvb_database_sqlite_sqlite_epg_store_type_id__volatile;
}



