/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libcsm.so
 *
 *   File: csm_plugin.h
 */

#ifndef   _CSM_HEADERS_
#define   _CSM_HEADER_ 1


#include <ece.h>

/* Needed for CRC calculations */
#define  INITIAL_CRC 0xFFFFFFFFL

/* Globally Unique Identifier
 *
 * Reference: Wired For Management Baseline Specification, Version 1.1a
 *            Appendix J
 */
typedef struct _guid_s {
    u_int32_t       time_low;              // timestamp - low order 32 bits
    u_int16_t       time_mid;              // timestamp - mid 16 bits
    u_int16_t       time_high;             // timestamp - high 16 bits
    u_int8_t        clock_seq_high;        // clock - high order 8 bits
    u_int8_t        clock_seq_low;         // clock - low order 8 bits
    u_int8_t        node[6];               // node - spatial reference - unique identification like
} __attribute__((packed)) guid_t;          //        the mac address of this systems network card.



/*
 * Need a define for the asciiz size of an ece_nodeid_t
 */
#define NODEID_STRING_SIZE ((ECE_NODEID_SIZE*2)+16) // just an approximation


//
//  Cluster Segment Manager Header - must fit in single VSECTOR
//
#define CSM_DISK_MAGIC                     0x54524150204D5343ULL  // "CSM PART"

#define CSM_CLUSTER_SHARED        0x00000001      /* any valid nodeid in the cluster can access   */
#define CSM_CLUSTER_PRIVATE       0x00000002      /* only the owner nodeid can access             */
#define CSM_CLUSTER_DEPORTED      0x00000004      /* owner relenquished and nobody can access till*/
                                                          /* new owner is provided.                       */
typedef struct _csm_header_s {
    u_int64_t       signature;                            /* CSM_DISK_MAGIC                               */
    u_int32_t       size;                                 /* size (bytes) of header - used to CRC it      */
    u_int32_t       crc;                                  /* CRC of header                                */
    u_int32_t       flags;                                /* flags will be used for container properties  */
    u_int32_t       sequence;                             /* reserved for now ...                         */
    lba_t           alternate_lba;                        /* LBA of other csm header                      */
    lba_t           start_useable;                        /* LBA of 1st block of useable area on disk     */
    lba_t           end_useable;                          /* LBA of last block of useable area on disk    */
    ece_nodeid_t    nodeid;                               /* ID identifies owner of this disk group       */
    ece_clusterid_t clusterid;                            /* ID identifies the cluster                    */
    guid_t          disk_id;                              /* UID - identifies this disk                   */
    char            container_name[EVMS_NAME_SIZE+1];     /* STRING - ascii name of disk group (container)*/
} csm_header_t;                                           /* total length = 448 bytes (must be < 512)     */


//
// Private Data Areas
//
#define  CSM_DISK_PDATA_SIGNATURE          0x4449534B   /* DISK */

typedef struct disk_private_data_s {

    u_int32_t                   signature;                /* used to validate disk private data area      */

    u_int32_t                   flags;                    /* see DISK_HAS_xxxx flags above                */

    DISKSEG                    *md1;                      /* primary copy of metadata                     */

    DISKSEG                    *md2;                      /* alternate copy of metadata                   */

    u_int32_t                   vsectors_per_block;       /* disk hardsector size >> EVMS_VSECTOR_SIZE    */

} disk_private_data_t;


#define  CSM_SEGMENT_PDATA_SIGNATURE       0x2D474553   /* SEG- */
#define  SEG_CFLAG_TOP_SEGMENT             0x00000001

typedef struct seg_private_data_s {

    u_int32_t          signature;            /* used to validate our private data area                      */

    u_int32_t          cflags;               /* common flag definitions                                     */

    //----------------- end of segment manager common area  -----------------------

    storage_object_t  *logical_disk;         /* storage object we found the csm partitions on               */

    //----------------- next 2 fields are only used by the metadata segs --------------------

    csm_header_t      *hdr;                  /* csm header ptr ... a copy of the csm metadata               */

    u_int32_t          commit_phase;         /* specifies which phase we write this csm header to disk      */

} seg_private_data_t;



#define  CSM_CONTAINER_PDATA_SIGNATURE       0x2D4E4F43   /* CON- */

typedef struct container_private_data_s {

    u_int32_t          signature;            /* used to validate our private data area                      */

    u_int32_t          sequence;             /* highest seq number found during discovery                   */

    ece_clusterid_t    clusterid;            /* the cluster I belong to                                     */

    ece_nodeid_t       nodeid;               /* the node I belong to                                        */

} container_private_data_t;


extern struct engine_functions_s       *EngFncs;
extern plugin_record_t                 *csm_plugin_record_ptr;
extern ece_nodeid_t                     csm_nodeid;
extern ece_clusterid_t                  csm_clusterid;
extern boolean                          csm_has_quorum;
extern boolean                          csm_admin_mode;

#define my_plugin_record                csm_plugin_record_ptr

#include "disks.h"
#include "helpers.h"
#include "commit.h"
#include "options.h"
#include "discovery.h"
#include "containers.h"
#include "segments.h"
#include "dm.h"

#endif

