# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a HTML lexer with some additional methods.
"""

from qtext import QextScintillaLexerHTML
from qt import *

from Lexer import Lexer

class LexerHTML(QextScintillaLexerHTML, Lexer):
    """ 
    Subclass to implement some additional lexer dependant methods.
    """
    def __init__(self, parent=None, name=None):
        """
        Constructor
        
        @param parent parent widget of this lexer
        @param name name of this lexer
        """
        QextScintillaLexerHTML.__init__(self, parent, name)
        Lexer.__init__(self)
        
        self.streamCommentString = {
            'start' : QString('<!-- '),
            'end'   : QString(' -->')
        }
