/*
 * Copyright (c) 2010-2012 Stefan Bolte <portix@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

static KeyValue KEYS[] = {
  { "tab_new",                  {   "ga",         0,                0 }, },  
  { "allow_cookie",             {   "CC",         0,                0 }, },  
  { "allow_session_cookie",     {   "CS",         0,                0 }, },  
  { "allow_session_cookie_tmp", {   "CT",         0,                0 }, },  
  { "bookmark",                 {   "M",          0,                0 }, },  
  { "bookmarks",                {   "gb",         0,                0 }, },  
  { "tab_bookmarks",            {   "gB",         0,                0 }, },  
  { "win_bookmarks",            {   "wB",         0,                0 }, },  
  { "command_mode",             {   ":",          0,                0 }, },  
  { "only",                     {   "co",         0,                0 }, },  
  { "find_forward",             {   "/",          0,                0 }, }, 
  { "find_forward_ic",          {   "c/",         0,                0 }, }, 
  { "find_next",                {   "n",          0,                0 }, },
  { "find_previous",            {   "N",          0,                0 }, },
  { "find_backward",            {   "?",          0,                0 }, },  
  { "find_backward_ic",         {   "c?",         0,                0 }, },  
  { "focus_next",               {   "J",          0,                0 }, },  
  { "focus_prev",               {   "K",          0,                0 }, },  
  { "focus_tab",                {   "T",          0,                0 }, },  
  { "hints",                    {   "f",          0,                0 }, },  
  { "hints_links",              {   ";;",         0,                0 }, },  
  { "hints_images",             {   ";i",         0,                0 }, },  
  { "hints_images_tab",         {   ";I",         0,                0 }, },  
  { "hints_images_background",  {   ".i",         0,                0 }, },  
  { "hints_editable",           {   ";e",         0,                0 }, },  
  { "hints_url",                {   ";o",         0,                0 }, },  
  { "hints_url_tab",            {   ";O",         0,                0 }, },  
  { "hints_url_background",     {   ".o",         0,                0 }, },  
  { "hints_download",           {   ";d",         0,                0 }, },
  { "hints_tab",                {   "F",          0,                0 }, },  
  { "hints_background",         {   ";b",         0,                0 }, },  
  { "hints_win",                {   "wf",         0,                0 }, },  
  { "hints_clipboard",          {   ";y",         0,                0 }, },  
  { "hints_primary",            {   ";Y",         0,                0 }, },  
  { "hints_rapid",              {   ";r",         0,                0 }, },  
  { "hints_rapid_win",          {   ";R",         0,                0 }, },  
  { "history_back",             {   "H",          0,                0 }, },  
  { "history_forward",          {   "L",          0,                0 }, },  
  { "tab_hist_back",            {   "th",         0,                0 }, },  
  { "tab_hist_forward",         {   "tl",         0,                0 }, },  
  { "win_hist_back",            {   "wh",         0,                0 }, },  
  { "win_hist_forward",         {   "wl",         0,                0 }, },  
  { "insert_mode",              {   "i",          0,                0 }, },  
  { "normal_mode",              {   "n",          GDK_CONTROL_MASK, 0 }, },  
  { "open",                     {   "o",          0,                0 }, },  
  { "open_url",                 {   "go",         0,                0 }, }, 
  { "tabopen",                  {   "O",          0,                0 }, },  
  { "tabopen_url",              {   "gO",         0,                0 }, },  
  { "backopen",                 {   "xo",         0,                0 }, },  
  { "backopen_url",             {   "xO",         0,                0 }, },  
  { "winopen",                  {   "wo",         0,                0 }, },  
  { "winopen_url",              {   "wO",         0,                0 }, },  
  { "start_page",               {   "h",          GDK_CONTROL_MASK, 0 }, },  
  { "quickmark",                {   "b",          0,                0 }, },  
  { "tab_quickmark",            {   "B",          0,                0 }, },  
  { "win_quickmark",            {   "wb",         0,                0 }, },  
  { "reload",                   {   "r",          0,                0 }, },  
  { "reload_bypass_cache",      {   "R",          0,                0 }, },  
  { "close_tab",                {   "d",          0,                0 }, },  
  { "save_quickmark",           {   "m",          0,                0 }, },  
  { "scroll_bottom",            {   "G",          0,                0 }, },  
  { "scroll_down",              {   "j",          0,                0 }, },  
  { "scroll_left",              {   "h",          0,                0 }, },  
  { "scroll_halfpage_down",     {   "d",          GDK_CONTROL_MASK, 0 }, },  
  { "scroll_halfpage_up",       {   "u",          GDK_CONTROL_MASK, 0 }, },  
  { "scroll_page_down",         {   "f",          GDK_CONTROL_MASK, 0 }, },  
  { "scroll_page_up",           {   "b",          GDK_CONTROL_MASK, 0 }, },  
  { "scroll_right",             {   "l",          0,                0 }, },  
  { "scroll_top",               {   "gg",         0,                0 }, },  
  { "scroll_up",                {   "k",          0,                0 }, },  
  { "show_keys",                {   "Sk",         0,                0 }, },  
  { "show_settings",            {   "Ss",         0,                0 }, },  
  { "show_bookmarks",           {   "Sb",         0,                0 }, },  
  { "show_history",             {   "Sh",         0,                0 }, },  
  { "show_downloads",           {   "Sd",         0,                0 }, },  
  { "show_quickmarks",          {   "Sq",         0,                0 }, },  
  { "stop_loading",             {   "s",          GDK_CONTROL_MASK, 0 }, },  
  { "view_source",              {   "gf",         0,                0 }, },  
  { "zoom_in",                  {   "+",          0,                0 }, },  
  { "zoom",                     {   "=",          0,                0 }, },  
  { "zoom_out",                 {   "-",          0,                0 }, },  
  { "save_search_field",        {   "gs",         0,                0 }, },  
  { "reload_userscripts",       {   NULL,         0,                0 }, },
  { "proxy",                    {   "p" ,         GDK_CONTROL_MASK, 0 }, },
  { "focus_input",              {   "gi",         0,                0 }, }, 
  { "set_setting",              {   "ss",         0,                0 }, }, 
  { "set_local_setting",        {   "sl",         0,                0 }, }, 
  { "set_key",                  {   "sk",         0,                0 }, }, 
  { "yank",                     {   "yy",         0,                0 }, }, 
  { "yank_primary",             {   "yY",         0,                0 }, }, 
  { "yank_title",               {   "yt",         0,                0 }, }, 
  { "yank_title_primary",       {   "yT",         0,                0 }, }, 
  { "paste",                    {   "pp",         0,                0 }, }, 
  { "paste_primary",            {   "pP",         0,                0 }, }, 
  { "tab_paste",                {   "Pp",         0,                0 }, }, 
  { "tab_paste_primary",        {   "PP",         0,                0 }, }, 
  { "win_paste",                {   "wp",         0,                0 }, }, 
  { "win_paste_primary",        {   "wP",         0,                0 }, }, 
  /* entry  shortcuts */
  { "entry_delete_word",        {   "w",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_delete_word_forward",{   "e",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_delete_letter",      {   "h",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_delete_line",        {   "u",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_delete_line_end",    {   "e",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_word_forward",       {   "f",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_word_back",          {   "b",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_history_forward",    {   "j",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_history_back",       {   "k",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_escape",             {   "c",          GDK_CONTROL_MASK, 0 }, }, 
  { "entry_confirm",            {   "g",          GDK_CONTROL_MASK, 0 }, }, 
  { "download_set_execute",     {   "x",          GDK_CONTROL_MASK, 0 }, }, 
  { "complete_history",         {   "H",          GDK_CONTROL_MASK, 0 }, },  
  { "complete_bookmarks",       {   "B",          GDK_CONTROL_MASK, 0 }, },  
  { "complete_searchengines",   {   "S",          GDK_CONTROL_MASK, 0 }, },  
  { "complete_userscript",      {   "U",          GDK_CONTROL_MASK, 0 }, },  
  { "buffers",                  {   "gt",         0,                0 }, }, 

  { "web_inspector",            {   "wi",         0,                0 }, },  

  { "save_session",             {   "ZZ",         0,                0 }, }, 
  { "save_named_session",       {   "gZZ",        0,                0 }, }, 
  { "toggle_scripts_uri",       {   "tsu",        0,                0 }, }, 
  { "toggle_scripts_host",      {   "tsh",        0,                0 }, }, 
  { "toggle_scripts_uri_tmp",   {   "ttu",        0,                0 }, }, 
  { "toggle_scripts_host_tmp",  {   "tth",        0,                0 }, }, 
  { "toggle_plugins_uri",       {   "pu",         0,                0 }, }, 
  { "toggle_plugins_host",      {   "ph",         0,                0 }, }, 
  { "toggle_plugins_uri_tmp",   {   "ptu",        0,                0 }, }, 
  { "toggle_plugins_host_tmp",  {   "pth",        0,                0 }, }, 
  { "new_tab",                  {   "V",          0,                0 }, }, 
  { "new_win",                  {   "W",          0,                0 }, }, 
  { "save",                     {   "sf",         0,                0 }, }, 
  { "undo",                     {   "u",          0,                0 }, }, 
  { "execute_userscript",       {   "eu",         0,                0 }, },  
  { "print",                    {   "p",          GDK_CONTROL_MASK | GDK_MOD1_MASK, 0 }, }, 
  { "load_html",                {   NULL,         0,                0 }, }, 
  { "load_html_tab",            {   NULL,         0,                0 }, }, 
  { "toggle_hidden_files",      {   "g.",         0,                0 }, }, 
  { "complete_path",            {   "p",          GDK_CONTROL_MASK, 0 }, }, 
  { "quit",                     {   "q",          GDK_CONTROL_MASK, 0 }, }, 
  { "fullscreen",               {   "@F11@",      0,                0 }, }, 
  { "pass_through",             {   "i",          GDK_CONTROL_MASK, 0 }, }, 
  { "open_editor",              {   "e",          GDK_CONTROL_MASK, 0 }, }, 
  { "toggle_bars",              {   "xx",         0,                0 }, }, 
  { "toggle_tabbar",            {   "xt",         0,                0 }, }, 
  { "toggle_statusbar",         {   "xb",         0,                0 }, }, 
  { "presentation_mode",        {   "@F12@",      0,                0 }, }, 
  { "protect",                  {   "P",          GDK_CONTROL_MASK, 0 }, }, 
  { "lock_uri",                 {   "xu",         0,                0 }, }, 
  { "lock_domain",              {   "xd",         0,                0 }, }, 
  { "back_new_tab",             {   "xb",         0,                0 }, }, 
  { "visible",                  {   "xv",         0,                0 }, }, 
  { "execute_javascript",       {   NULL,         0,                0 }, }, 
  { "set",                      {   NULL,         0,                0 }, }, 
  { "toggle_setting",           {   NULL,         0,                0 }, }, 
  { "toggle_local_setting",     {   NULL,         0,                0 }, }, 
  { "tab_move",                 {   "gm",         0,                0 }, }, 
  { "tab_move_left",            {   "gl",         0,                0 }, }, 
  { "tab_move_right",           {   "gr",         0,                0 }, }, 
  { "clear_tab",                {   "gc",         0,                0 }, }, 
  { "cancel_download",          {   "ad",         0,                0 }, }, 
  { "local_set",                {   NULL,         0,                0 }, }, 
  { "dump",                     {   NULL,         0,                0 }, }, 
  { "sanitize",                 {   NULL,         0,                0 }, }, 
  { "eval",                     {   NULL,         0,                0 }, }, 
  { "download",                 {   "gd",         0,                0 }, }, 
  { "toggle_tab",               {   "@Tab@",      GDK_CONTROL_MASK, 0 }, }, 
};

/* FUNCTION_MAP{{{*/
static FunctionMap FMAP [] = {
  { { "tab_new",              "Add a new tab",                    }, CP_COMMANDLINE, 
    (Func)commands_add_view,            NULL,                            ALWAYS_SM,     
    { .p = NULL },                          EP_NONE,    { NULL }, },

  { { "toggle_tab",              "Toggle between last and current tab",                    }, CP_COMMANDLINE, 
    (Func)commands_toggle_tab,            NULL,                            ALWAYS_SM,     
    { .p = NULL },                          EP_NONE,    { "ttab" }, },

  { { "cancel_download",              "Cancel a download",                    }, CP_COMMANDLINE, 
    (Func)commands_cancel_download,            "No download to stop",                            ALWAYS_SM,     
    { .p = NULL },                          EP_NONE,    { NULL }, },

  { { "clear_tab",              "Clear current tab",                    }, CP_COMMANDLINE, 
    (Func)commands_clear_tab,            NULL,                            ALWAYS_SM,     
    { .p = NULL },                          EP_NONE,    { "clear" }, },

  { { "execute_javascript",              "Execute a javascript snippet",                    }, CP_COMMANDLINE, 
    (Func)commands_execute_javascript,            NULL,                            ALWAYS_SM,     
    { .p = NULL },                          EP_NONE,    { "js", "exja", NULL }, },

  { { "eval",              "Execute a javascript snippet that uses the internal jsapi",                    }, CP_COMMANDLINE, 
    (Func)commands_eval,            NULL,                            POST_SM,     
    { .p = NULL },                          EP_NONE,    { NULL }, },

  { { "download",              "Download",                    }, CP_COMMANDLINE | CP_DONT_CLEAN, 
    (Func)commands_download,            NULL,                            NEVER_SM,     
    { .p = NULL },                          EP_NONE,    { NULL }, },

  { { "set",              "Set a setting",                    }, CP_COMMANDLINE, 
    (Func)commands_set,            "Invalid value",                            POST_SM,     
    { .p = NULL, .n = SET_GLOBAL },                          EP_NONE,    { NULL }, },

  { { "local_set",                "Set a setting",                    }, CP_COMMANDLINE, 
    (Func)commands_set,            "Invalid value",                            POST_SM,     
    { .p = NULL, .n = SET_LOCAL },                          EP_NONE,    { NULL }, },

  { { "dump",                "Write current website to a file or stdout",               }, CP_COMMANDLINE, 
    (Func)commands_dump,            NULL,                            POST_SM,     
    { .p = NULL },                            EP_NONE,    { NULL }, },

  { { "toggle_setting",              "Toggle a setting",                    }, CP_COMMANDLINE, 
    (Func)commands_toggle_setting,            "Invalid value",                            POST_SM,     
    { .p = NULL , .n = SET_GLOBAL },                          EP_NONE,    { "toggle", "tog", NULL }, },

  { { "toggle_local_setting",              "Toggle a setting",                    }, CP_COMMANDLINE, 
    (Func)commands_toggle_setting,            "Invalid value",                            POST_SM,     
    { .p = NULL , .n = SET_LOCAL },                          EP_NONE,    { "loctog", NULL }, },

  { { "toggle_bars",    "Toggle visibility of status and tabbar" },                 CP_COMMANDLINE, 
    (Func) commands_toggle_bars,                                     NULL,     ALWAYS_SM,    
    { .n = BAR_VIS_STATUS | BAR_VIS_TOP  }, EP_NONE, { "bars", NULL }, },

  { { "toggle_tabbar",    "Toggle visibility of tabbar" },                CP_COMMANDLINE, 
    (Func) commands_toggle_bars,                NULL,     ALWAYS_SM,    
    { .n = BAR_VIS_TOP  },                  EP_NONE,  { "tbar", NULL }, },

  { { "toggle_statusbar",    "Toggle visibility of statusbar" },                 CP_COMMANDLINE, 
    (Func) commands_toggle_bars,                                     NULL,     ALWAYS_SM,    
    { .n = BAR_VIS_STATUS }, EP_NONE, { "sbar", NULL }, },

  { { "presentation_mode",    "Toggle presentation mode" },                 CP_COMMANDLINE, 
    (Func) commands_presentation_mode,                                     NULL,     ALWAYS_SM,    
    { .n = BAR_VIS_STATUS | BAR_VIS_TOP  }, EP_NONE,  { "present", NULL }, },

  { { "protect",    "Protect/unprotect this tab" },                 1, 
    (Func) commands_toggle_lock_protect,                                   NULL,     ALWAYS_SM,    
    { .n = LP_PROTECT }, EP_NONE,  { "prot", NULL }, },

  { { "lock_domain",    "Lock/unlock domain for this tab" },                 1, 
    (Func) commands_toggle_lock_protect,                                   NULL,     ALWAYS_SM,    
    { .n = LP_LOCK_DOMAIN  }, EP_NONE,  { "dlock", NULL }, },

  { { "lock_uri",    "Lock/unlock uri for this tab" },                 1, 
    (Func) commands_toggle_lock_protect,                                   NULL,     ALWAYS_SM,    
    { .n = LP_LOCK_URI  }, EP_NONE,  { "ulock", NULL }, },

  { { "visible",    "Toggle visibility for this tab" },                 1, 
    (Func) commands_toggle_lock_protect,                                   NULL,     ALWAYS_SM,    
    { .n = LP_VISIBLE  }, EP_NONE,  { "vis", NULL }, },
  { { "allow_cookie",          "Cookie allowed",                    }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_allow_cookie,        "No new domain in current context",    POST_SM, 
    { .n = COOKIE_ALLOW_PERSISTENT }, EP_NONE,  { "cookie", NULL }, },

  { { "allow_session_cookie",          "Cookie allowed",                    }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_allow_cookie,        "No new domain in current context",    POST_SM, 
    { .n = COOKIE_ALLOW_SESSION }, EP_NONE, { "scookie", NULL }, },
  
  { { "allow_session_cookie_tmp",          "Cookie allowed",                    }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_allow_cookie,        "No new domain in current context",   ALWAYS_SM, 
    { .n = COOKIE_ALLOW_SESSION_TMP }, EP_NONE, { "tcookie", NULL }, },
  
  { { "bookmark",              "Bookmark current page",             }, CP_COMMANDLINE, 
    (Func)commands_bookmark,            NO_URL,                            POST_SM,     
    {0},  EP_NONE, { "bmark", "bma", NULL }, },
  
  { { "bookmarks",             "bookmarks",                         }, CP_COMMANDLINE|CP_HAS_MODE,
    (Func)commands_bookmarks,           "No Bookmarks",                    NEVER_SM,     
    { .n = OPEN_NORMAL }, EP_NONE, { "bmarks", "bmas", NULL }, },
  
  { { "tab_bookmarks",          "tabmarks",                }, CP_COMMANDLINE|CP_HAS_MODE,
    (Func)commands_bookmarks,           "No Bookmarks",                    NEVER_SM,     
    { .n = OPEN_NEW_VIEW }, EP_NONE, { "tabmarks", NULL }, },
  
  { { "win_bookmarks",          "winmarks",              }, CP_COMMANDLINE|CP_HAS_MODE, 
    (Func)commands_bookmarks,           "No Bookmarks",                    NEVER_SM,     
    { .n = OPEN_NEW_WINDOW}, EP_NONE, { "winmarks", NULL }, },
  
  { { "new_tab",              "new_tab",      }, 0, 
    (Func)commands_new_window_or_view,  NULL,                              NEVER_SM,     
    { .n = OPEN_NEW_VIEW }, EP_NONE, { NULL }, },
  
  { { "new_win",            "new_win",    }, 0, 
    (Func)commands_new_window_or_view,  NULL,                              NEVER_SM,     
    { .n = OPEN_NEW_WINDOW }, EP_NONE, { NULL }, },
  
  { { "command_mode",          "Enter command mode",                }, 0, 
    (Func)commands_command_mode,            NULL,                              POST_SM, 
    {0}, EP_NONE, { NULL }, },
  
  { { "find_backward",         "Find backward ",                    }, CP_COMMANDLINE|CP_HAS_MODE, 
    (Func)commands_find,                NO_URL,                            NEVER_SM,     
    { .n = 0 }, EP_NONE, { "bfind", NULL }, },
  
  { { "find_forward",          "Find forward ",                     }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_find,                NO_URL,                            NEVER_SM,     
    { .n = FIND_FORWARD }, EP_NONE, { "ffind",  NULL, }, },

  { { "find_backward_ic",         "Find backward ",                    }, CP_COMMANDLINE|CP_HAS_MODE, 
    (Func)commands_find,                NO_URL,                            NEVER_SM,     
    { .n = FIND_CASE_SENSITIVE }, EP_NONE, { "ibfind", NULL }, },
  
  { { "find_forward_ic",          "Find forward ",                     }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_find,                NO_URL,                            NEVER_SM,     
    { .n = FIND_FORWARD | FIND_CASE_SENSITIVE }, EP_NONE, { "iffind",  NULL, }, },
  
  { { "find_next",             "Find next",                         }, CP_COMMANDLINE, 
    (Func)commands_search,                  "No matches",                      ALWAYS_SM,     
    { .b = true }, EP_NONE, { "fnext", NULL, }, },
  
  { { "find_previous",         "Find previous",                     }, CP_COMMANDLINE, 
    (Func)commands_search,                  "No matches",                      ALWAYS_SM,     
    { .b = false }, EP_NONE, { "fprev", NULL }, },
  
  { { "focus_input",           "Focus input",                       }, CP_COMMANDLINE, 
    (Func)commands_focus_input,        "No input found in current context",      ALWAYS_SM, 
    {0}, EP_NONE, { NULL }, },
  
  { { "focus_next",            "Focus next tab",                   }, CP_COMMANDLINE, 
    (Func)commands_focus,              "No other tab",                   ALWAYS_SM,  
    { .n = 1 }, EP_NONE, { "tabnext", NULL }, },
  
  { { "focus_prev",            "Focus previous tab",               }, CP_COMMANDLINE, 
    (Func)commands_focus,              "No other tab",                   ALWAYS_SM,  
    { .n = -1 }, EP_NONE, { "tabprev", NULL }, },
  
  { { "focus_tab",        "Focus nth tab",                    }, CP_COMMANDLINE, 
    (Func)commands_focus_nth_view,       "No such tab",                   ALWAYS_SM,  
    { 0 }, EP_NONE, { "tab", NULL }, },

  { { "tab_move",        "Move tab to position",                    }, CP_COMMANDLINE, 
    (Func)commands_tab_move,       NULL,                   ALWAYS_SM,  
    { .n = TAB_MOVE_NONE }, EP_NONE, { "tabm", NULL }, },

  { { "tab_move_left",        "Move tab left",                    }, CP_COMMANDLINE, 
    (Func)commands_tab_move,       NULL,                   ALWAYS_SM,  
    { .n = TAB_MOVE_LEFT }, EP_NONE, { "tabl", NULL }, },

  { { "tab_move_right",        "Move tab right",                    }, CP_COMMANDLINE, 
    (Func)commands_tab_move,       NULL,                   ALWAYS_SM,  
    { .n = TAB_MOVE_RIGHT }, EP_NONE, { "tabr", NULL }, },
  
  { { "hints",             "follow",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_ALL }, EP_NONE, { "hi",  NULL }, },
  
  { { "hints_links",       "follow links",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          "No links",                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_LINKS }, EP_NONE, { "lhints", "lhi", NULL }, },
  
  { { "hints_images",       "follow images",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          "No images",                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_IMAGES }, EP_NONE, { "ihints", "ihi", NULL }, },
  
  { { "hints_images_tab",       "tabfollow images",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          "No images",                          NEVER_SM,    
    { .n = OPEN_NEW_VIEW, .i = HINT_T_IMAGES }, EP_NONE, { "itabhints", "ithi", NULL }, },

  { { "hints_images_background",       "backfollow images",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          "No images",                          NEVER_SM,    
    { .n = OPEN_NEW_VIEW | OPEN_BACKGROUND, .i = HINT_T_IMAGES }, EP_NONE, { "ibackhints", NULL }, },
  
  { { "hints_editable",       "follow editable",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          "No editable elements",           NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_EDITABLE }, EP_NONE, { "ehints", "ehi", NULL }, },
  
  { { "hints_url",            "follow url",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,           NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_URL }, EP_NONE, { "uhints", "uhi", NULL }, },
  
  { { "hints_url_background",         "backfollow url",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,           NEVER_SM,    
    { .n = OPEN_NEW_VIEW | OPEN_BACKGROUND, .i = HINT_T_URL }, EP_NONE, { "utabhints", "uthi",  NULL }, },

  { { "hints_url_tab",         "tabfollow url",                      }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,           NEVER_SM,    
    { .n = OPEN_NEW_VIEW, .i = HINT_T_URL }, EP_NONE, { "utabhints", "uthi",  NULL }, },
  
  { { "hints_tab",          "tabfollow",           }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NEW_VIEW, .i = HINT_T_ALL }, EP_NONE, { "tabhints", "thi", NULL }, },

  { { "hints_background",          "backfollow",           }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NEW_VIEW | OPEN_BACKGROUND, .i = HINT_T_ALL }, EP_NONE, { "backhints", "bhi", NULL }, },
  
  { { "hints_win",          "winfollow",         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NEW_WINDOW, .i = HINT_T_ALL }, EP_NONE, { "winhints", "whi", NULL }, },
  
  { { "hints_clipboard",          "follow clipboard",         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_CLIPBOARD }, EP_NONE, { "chints", "chi", NULL }, },
  
  { { "hints_primary",          "follow primary",         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_PRIMARY }, EP_NONE, { "phints", "phi", NULL }, },

  { { "hints_rapid",          "follow rapid",         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_RAPID }, EP_NONE, { "rhints", "rhi", NULL }, },

  { { "hints_rapid_win",          "winfollow rapid",         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_NORMAL, .i = HINT_T_RAPID_NW }, EP_NONE, { "wrhints", "wrhi", NULL }, },
  
  { { "hints_download",         "follow download",                          }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_show_hints,          NO_HINTS,                          NEVER_SM,    
    { .n = OPEN_DOWNLOAD }, EP_NONE, { "dhints", "dhi", NULL }, },
  
  { { "history_back",          "Go Back",                           }, CP_COMMANDLINE, 
    (Func)commands_history,        "Beginning of History",            ALWAYS_SM, 
    { .n = OPEN_NORMAL, .i = -1 }, EP_NONE, { "back", "ba", NULL }, },
  
  { { "history_forward",       "Go Forward",                        }, CP_COMMANDLINE, 
    (Func)commands_history,     "End of History",                  ALWAYS_SM, 
    { .n = OPEN_NORMAL, .i = 1 }, EP_NONE, { "forward", "fo", NULL }, },
  
  { { "tab_hist_back",          "Go Back",                           }, CP_COMMANDLINE, 
    (Func)commands_history,        "Beginning of History",            ALWAYS_SM, 
    { .n = OPEN_NEW_VIEW, .i = -1 }, EP_NONE, { "tabback", "tba", NULL }, },
  
  { { "tab_hist_forward",       "Go Forward",                        }, CP_COMMANDLINE, 
    (Func)commands_history,     "End of History",                  ALWAYS_SM, 
    { .n = OPEN_NEW_VIEW, .i = 1 }, EP_NONE, { "tabforward", "tfo", NULL }, },
  
  { { "win_hist_back",          "Go Back",                           }, CP_COMMANDLINE, 
    (Func)commands_history,        "Beginning of History",            ALWAYS_SM, 
    { .n = OPEN_NEW_WINDOW, .i = -1 }, EP_NONE, { "winback", "wba", NULL }, },
  
  { { "win_hist_forward",       "Go Forward",                        }, CP_COMMANDLINE, 
    (Func)commands_history,     "End of History",                  ALWAYS_SM, 
    { .n = OPEN_NEW_WINDOW, .i = 1 }, EP_NONE, { "winforward", "wfo", NULL }, },
  
  { { "insert_mode",           "Insert Mode",                       }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_insert_mode,             NULL,                              POST_SM, 
    { 0 }, EP_NONE, { "i", "insert", NULL }, },
  
  { { "normal_mode",           "Normal Mode",                       }, CP_OVERRIDE_INSERT | CP_OVERRIDE_ENTRY | CP_OVERRIDE_ALL, 
    (Func)commands_normal_mode,             NULL,                              POST_SM, 
    { 0 }, EP_NONE, { NULL }, },
  
  { { "load_html",             "Load html",                         }, CP_COMMANDLINE, 
    (Func)commands_open,           NULL,                       NEVER_SM,   
    { .i = HTML_STRING, .n = OPEN_NORMAL,      .p = NULL }, EP_NONE, { NULL }, },
  
  { { "load_html_tab",          "Load html new tab",                }, CP_COMMANDLINE, 
    (Func)commands_open,           NULL,                       NEVER_SM,   
    { .i = HTML_STRING, .n = OPEN_NEW_VIEW,    .p = NULL }, EP_NONE, { NULL }, },
  
  { { "open",                  "open",                              }, CP_COMMANDLINE | CP_DONT_CLEAN | CP_NEEDS_ARG, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NORMAL,      .p = NULL }, EP_COMP_DEFAULT, { "o", NULL }, },
  
  { { "open_url",                  "open",                              }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NORMAL | SET_URL, .p = NULL }, EP_COMP_DEFAULT, { NULL }, },
  
  { { "tabopen",               "tabopen",                          }, CP_COMMANDLINE | CP_DONT_CLEAN | CP_NEEDS_ARG, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_VIEW,     .p = NULL }, EP_COMP_DEFAULT, { "t", "topen", NULL }, },
  
  { { "tabopen_url",               "tabopen",                          }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_VIEW | SET_URL, .p = NULL }, EP_COMP_DEFAULT, { NULL }, },

  { { "backopen",               "backopen",                          }, CP_COMMANDLINE | CP_DONT_CLEAN | CP_NEEDS_ARG, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_VIEW | OPEN_BACKGROUND,     .p = NULL }, EP_COMP_DEFAULT, { "bopen", NULL }, },
  
  { { "backopen_url",               "backopen",                          }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_VIEW | SET_URL | OPEN_BACKGROUND, .p = NULL }, EP_COMP_DEFAULT, { NULL }, },
  
  { { "winopen",               "winopen",                           }, CP_COMMANDLINE | CP_DONT_CLEAN | CP_NEEDS_ARG, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_WINDOW,     .p = NULL }, EP_COMP_DEFAULT, { "w", "wopen", NULL }, },
  
  { { "winopen_url",               "winopen",                           }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_open,                NULL,                 NEVER_SM,   
    { .n = OPEN_NEW_WINDOW | SET_URL,     .p = NULL }, EP_COMP_DEFAULT, { NULL }, },
  
  { { "quickmark",        "Open quickmark",                         }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_quickmark,           NO_URL,                            NEVER_SM,   
    { .n = QUICK_MARK_OPEN, .i=OPEN_NORMAL }, EP_NONE, { "qmarks", NULL }, },
  
  { { "tab_quickmark",     "Open quickmark in a new tab",                }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_quickmark,           NULL,                              NEVER_SM,    
    { .n = QUICK_MARK_OPEN, .i=OPEN_NEW_VIEW }, EP_NONE, { "tabqmarks", NULL }, },
  
  { { "win_quickmark",     "Open quickmark in a new window",              }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_quickmark,           NULL,                              NEVER_SM,    
    { .n = QUICK_MARK_OPEN, .i=OPEN_NEW_WINDOW }, EP_NONE, { "winqmarks", NULL }, },
  
  { { "start_page",       "Open startpage",                    }, CP_COMMANDLINE, 
    (Func)commands_open_startpage,      "No startpage set",                ALWAYS_SM, 
    { 0 }, EP_NONE, { "home", NULL }, },
  
  { { "quit",           "Quit dwb",               }, CP_COMMANDLINE, 
    (Func)commands_quit,         NULL,                   ALWAYS_SM, 
    { 0 }, EP_NONE, { "q", NULL }, },
  
  { { "reload",                "Reload current page",                            }, 1, 
    (Func)commands_reload,              NULL,                              ALWAYS_SM, 
    { 0 }, EP_NONE, { "re", NULL }, },
  
  { { "reload_bypass_cache",   "Reload current page without using any cached data",  }, 1, 
    (Func)commands_reload_bypass_cache,       NULL,                              ALWAYS_SM, 
    { 0 }, EP_NONE, { "refull", NULL }, },
  
  { { "stop_loading",   "Stop loading current page",  }, 1, 
    (Func)commands_stop_loading,       NULL,                              ALWAYS_SM, 
    { 0 }, EP_NONE, { "st", "stop", NULL }, },
  
  { { "close_tab",           "Close tab",                        }, 1, 
    (Func)commands_remove_view,         NULL,                              ALWAYS_SM, 
    { 0 }, EP_NONE, { "close", NULL }, },
  
  { { "only",           "Close other tabs except for current",                        }, 1, 
    (Func)commands_only,         "No other tab",                              ALWAYS_SM, 
    { 0 }, EP_NONE, { NULL }, },
  
  { { "save_quickmark",        "Save quickmark",    }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_quickmark,           NO_URL,                            NEVER_SM,    
    { .n = QUICK_MARK_SAVE }, EP_NONE, { "quickmark", "qmark", NULL }, },
  
  { { "save_search_field",     "Add a new searchengine",            }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_add_search_field,    "No input in current context",     POST_SM, 
    { 0 }, EP_NONE, { "search", NULL }, },
  
  { { "scroll_bottom",         "Scroll to  bottom of the page",     }, CP_COMMANDLINE, 
    (Func)commands_scroll,              NULL,                              ALWAYS_SM,    
    { .n = SCROLL_BOTTOM }, EP_NONE, { "bottom", NULL }, },
  
  { { "scroll_down",           "Scroll down",                       }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Bottom of the page",              ALWAYS_SM,    
    { .n = SCROLL_DOWN, }, EP_NONE, { "down", NULL }, },
  
  { { "scroll_left",           "Scroll left",                       }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Left side of the page",           ALWAYS_SM,    
    { .n = SCROLL_LEFT }, EP_NONE, { "left",  NULL }, },
  
  { { "scroll_halfpage_down",  "Scroll one-half page down",         }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Bottom of the page",              ALWAYS_SM,    
    { .n = SCROLL_HALF_PAGE_DOWN, }, EP_NONE, { "halfdown", NULL }, },
  
  { { "scroll_halfpage_up",    "Scroll one-half page up",           }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Top of the page",                 ALWAYS_SM,    
    { .n = SCROLL_HALF_PAGE_UP, }, EP_NONE, { "halfup", NULL }, },
  
  { { "scroll_page_down",      "Scroll one page down",              }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Bottom of the page",              ALWAYS_SM,    
    { .n = SCROLL_PAGE_DOWN, }, EP_NONE, { "pagedown", NULL }, },
  
  { { "scroll_page_up",        "Scroll one page up",                }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Top of the page",                 ALWAYS_SM,    
    { .n = SCROLL_PAGE_UP, }, EP_NONE, { "pageup", NULL }, },
  
  { { "scroll_right",          "Scroll left",                       }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Right side of the page",          ALWAYS_SM,    
    { .n = SCROLL_RIGHT }, EP_NONE, { "right", NULL }, },
  
  { { "scroll_top",            "Scroll to the top of the page",     }, CP_COMMANDLINE, 
    (Func)commands_scroll,              NULL,                              ALWAYS_SM,    
    { .n = SCROLL_TOP }, EP_NONE, { "top", NULL }, },
  
  { { "scroll_up",             "Scroll up",                         }, CP_COMMANDLINE, 
    (Func)commands_scroll,              "Top of the page",                 ALWAYS_SM,    
    { .n = SCROLL_UP, }, EP_NONE, { "up", NULL }, },
  
  { { "set_setting",    "Set setting",               }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_set_setting,         NULL,                              NEVER_SM, 
    { .n = SETTINGS_MODE }, EP_NONE, { NULL }, },

  { { "set_local_setting",    "Set local setting",               }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_set_setting,         NULL,                              NEVER_SM, 
    { .n = SETTINGS_MODE_LOCAL }, EP_NONE, { NULL }, },
  
  { { "set_key",               "Set keybinding",                    }, CP_COMMANDLINE | CP_HAS_MODE, 
    (Func)commands_set_key,             NULL,                              NEVER_SM,    
    { 0 }, EP_NONE, { "keys", NULL }, },
  
  { { "show_bookmarks",             "Show bookmarks",                 }, CP_COMMANDLINE, 
    (Func)commands_show,           NULL,                              ALWAYS_SM, 
    { .p = "dwb:bookmarks", .ro = true }, EP_NONE, { "sbookmarks", NULL }, },
  
  { { "show_quickmarks",             "Show quickmarks",                 }, CP_COMMANDLINE, 
    (Func)commands_show,           NULL,                              ALWAYS_SM, 
    { .p = "dwb:quickmarks", .ro = true }, EP_NONE, { "squickmarks", NULL }, },

  { { "show_history",             "Show history",                 }, CP_COMMANDLINE, 
    (Func)commands_show,           NULL,                              ALWAYS_SM, 
    { .p = "dwb:history", .ro = true }, EP_NONE, { "shistory", NULL }, },

  { { "show_downloads",             "Show downloads",                 }, CP_COMMANDLINE, 
    (Func)commands_show,           NULL,                              ALWAYS_SM, 
    { .p = "dwb:downloads", .ro = true }, EP_NONE, { "sdownloads", NULL }, },
  
  { { "show_keys",             "Key configuration",                 }, CP_COMMANDLINE, 
    (Func)commands_show,           NULL,                              ALWAYS_SM, 
    { .p = "dwb:keys", .ro = true }, EP_NONE, { "skeys", NULL }, },

  { { "show_settings",         "Settings configuration",                          }, CP_COMMANDLINE, 
    (Func)commands_show,       NULL,                              ALWAYS_SM, 
    { .p = "dwb:settings", .ro = true }, EP_NONE, { "ssettings", NULL }, },
  
  { { "view_source",           "View source",                       }, CP_COMMANDLINE, 
    (Func)commands_view_source,         NULL,                              ALWAYS_SM, 
    { 0 }, EP_NONE, { "source", "so", NULL }, },
  
  { { "zoom_in",               "Zoom in",                           }, CP_COMMANDLINE, 
    (Func)commands_zoom,             "Cannot zoom in further",          POST_SM, 
    { .i = 1 }, EP_NONE, { "zi", NULL }, },
  
  { { "zoom",                 "Zoom",                         }, CP_COMMANDLINE, 
    (Func)commands_set_zoom_level,      NULL,                              POST_SM,    
    { .d = 1.0,   .p = NULL }, EP_NONE, { "z", NULL }, },
  
  { { "zoom_out",              "Zoom out",                          }, CP_COMMANDLINE, 
    (Func)commands_zoom,            "Cannot zoom out further",         POST_SM, 
    { .i = -1 }, EP_NONE, { "zo", NULL }, },
  
  /* yank and paste */
  
  { { "yank",                  "Yank current url",                              }, CP_COMMANDLINE, 
    (Func)commands_yank,                 NO_URL,                 POST_SM,  
    { .p = GDK_NONE, .n = CA_URI, .ro = true }, EP_NONE, { NULL }, },
  
  { { "yank_primary",          "Yank current url to Primary selection",         }, CP_COMMANDLINE, 
    (Func)commands_yank,                 NO_URL,                 POST_SM,  
    { .p = GDK_SELECTION_PRIMARY, .n = CA_URI, .ro = true }, EP_NONE, { "pyank", NULL }, },
  
  { { "yank_title",                  "Yank current title",                              }, CP_COMMANDLINE, 
    (Func)commands_yank,                 "No title",                 POST_SM,  
    { .p = GDK_NONE, .n = CA_TITLE, .ro = true }, EP_NONE, { "tyank", NULL }, },
  
  { { "yank_title_primary",          "Yank current title to Primary selection",         }, CP_COMMANDLINE, 
    (Func)commands_yank,                 "No title",                 POST_SM,  
    { .p = GDK_SELECTION_PRIMARY, .n = CA_TITLE, .ro = true }, EP_NONE, { "tpyank", NULL }, },
  
  { { "paste",                 "Open url from clipboard",                             }, CP_COMMANDLINE, 
    (Func)commands_paste,               "Clipboard is empty",    ALWAYS_SM, 
    { .n = OPEN_NORMAL, .p = GDK_NONE, .ro = true }, EP_NONE, { NULL }, },
  
  { { "paste_primary",         "Open url from primary selection",           }, CP_COMMANDLINE, 
    (Func)commands_paste,               "No primary selection",  ALWAYS_SM, 
    { .n = OPEN_NORMAL, .p = GDK_SELECTION_PRIMARY, .ro = true }, EP_NONE, { "ppaste", NULL }, },
  
  { { "tab_paste",              "Open url from clipboard in a new tab",                   }, CP_COMMANDLINE, 
    (Func)commands_paste,               "Clipboard is empty",    ALWAYS_SM, 
    { .n = OPEN_NEW_VIEW, .p = GDK_NONE, .ro = true }, EP_NONE, { "tpaste", NULL }, },
  
  { { "tab_paste_primary",      "Open url from primary selection in a new window", }, CP_COMMANDLINE, 
    (Func)commands_paste,               "No primary selection",  ALWAYS_SM, 
    { .n = OPEN_NEW_VIEW, .p = GDK_SELECTION_PRIMARY, .ro = true }, EP_NONE, { "tabppaste", NULL }, },
  
  { { "win_paste",              "Open url from clipboard in a new window",                   }, CP_COMMANDLINE, 
    (Func)commands_paste,             "Clipboard is empty",    ALWAYS_SM, 
    { .n = OPEN_NEW_WINDOW, .p = GDK_NONE, .ro = true }, EP_NONE, { "wpaste", NULL }, },
  
  { { "win_paste_primary",      "Open url from primary selection in a new window", }, CP_COMMANDLINE, 
    (Func)commands_paste,             "No primary selection",  ALWAYS_SM, 
    { .n = OPEN_NEW_WINDOW, .p = GDK_SELECTION_PRIMARY, .ro = true }, EP_NONE, { "wppaste", NULL }, },
  

  { { "save_session",          "Save current session", },              CP_COMMANDLINE, 
    (Func)commands_save_session,        NULL,                              ALWAYS_SM,  
    { .n = NORMAL_MODE }, EP_NONE, { "wq", NULL }, },
  
  { { "save_named_session",    "Save current session with name", },    CP_COMMANDLINE|CP_HAS_MODE, 
    (Func)commands_save_session,        NULL,                              POST_SM,  
    { .n = SAVE_SESSION }, EP_NONE, { "wqn", NULL }, },
  
  { { "save",                  "Save all configuration files", },      CP_COMMANDLINE, 
    (Func)commands_save_files,        NULL,                              POST_SM,  
    { .n = SAVE_SESSION }, EP_NONE, { NULL }, },
  
  { { "undo",                  "Undo closing last tab", },             CP_COMMANDLINE, 
    (Func)commands_undo,              "No more closed views",            POST_SM,  
    { 0 }, EP_NONE, { "u", NULL }, },
  
  { { "web_inspector",         "Open the webinspector", },             CP_COMMANDLINE, 
    (Func)commands_web_inspector,              "Enable developer extras for the webinspector",           POST_SM, 
    { 0 }, EP_NONE, { "inspect", "insp", NULL }, },
  
  { { "reload_userscripts",         "Reload userscripts", },             CP_COMMANDLINE, 
    (Func)commands_reload_user_scripts,              NULL,                              POST_SM, 
    { 0 }, EP_NONE, { NULL }, },
  

  /* Entry editing */
  { { "entry_delete_word",      "Command line: Delete word back", },                      CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,        NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_WORDS, .i = -1, .b = true }, EP_NONE, { NULL }, },
  
  { { "entry_delete_word_forward",      "Command line: Delete word forward", },                      CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,        NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_WORDS, .i = 1, .b = true }, EP_NONE, { NULL }, },
  
  { { "entry_delete_letter",    "Command line: Delete a single letter", },           CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,          NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_LOGICAL_POSITIONS, .i = -1, .b = true }, EP_NONE, { NULL }, },
  
  { { "entry_delete_line",      "Command line: Delete to beginning of the line", },  CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,            NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_BUFFER_ENDS, .i = -1, .b = true }, EP_NONE, { NULL }, },
  
  { { "entry_delete_line_end",      "Command line: Delete to end of the line", },  CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,            NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_BUFFER_ENDS, .i = 1, .b = true }, EP_NONE, { NULL }, },
  
  { { "entry_word_forward",     "Command line: Move cursor forward on word", },      CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,           NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_WORDS, .i = 1, .b = false }, EP_NONE, { NULL }, },
  
  { { "entry_word_back",        "Command line: Move cursor back on word", },         CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_movement,              NULL,        ALWAYS_SM,  
    { .n = GTK_MOVEMENT_WORDS, .i = -1, .b = false }, EP_NONE, { NULL }, },
  
  { { "entry_history_back",     "Command line: Command history back", },             CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_history_back,           NULL,        ALWAYS_SM,  
    { 0 }, EP_NONE, { NULL }, },

  { { "entry_history_forward",     "Command line: Command history forward", },             CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_history_forward,           NULL,        ALWAYS_SM,  
    { 0 }, EP_NONE, { NULL }, },

  { { "entry_escape",     "Command line: Alternate escape binding", },             CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_escape,           NULL,        ALWAYS_SM,  
    { 0 }, EP_NONE, { NULL }, },
  
  { { "entry_confirm",  "Command line: Alternate return binding", },          CP_OVERRIDE_ENTRY,  
    (Func)commands_entry_confirm,        NULL,        ALWAYS_SM,  
    { 0 }, EP_NONE, { NULL }, },
  
  { { "download_set_execute",   "Downloads: toggle between spawning application/download path", }, CP_OVERRIDE_ENTRY, 
    (Func)download_set_execute,        NULL,       ALWAYS_SM,  
    { 0 }, EP_NONE, { NULL }, },
  
  { { "complete_history",       "Complete browsing history", },       CP_OVERRIDE_ENTRY, 
    (Func)commands_complete_type,             NULL,     ALWAYS_SM,     
    { .n = COMP_HISTORY }, EP_NONE, { NULL }, },
  
  { { "complete_bookmarks",     "Complete bookmarks", },              CP_OVERRIDE_ENTRY, 
    (Func)commands_complete_type,             NULL,     ALWAYS_SM,     
    { .n = COMP_BOOKMARK }, EP_NONE, { NULL }, },
  
  { { "complete_searchengines", "Complete searchengines", },          CP_OVERRIDE_ENTRY, 
    (Func)commands_complete_type,             NULL,     ALWAYS_SM,     
    { .n = COMP_SEARCH }, EP_NONE, { NULL }, },
  
  { { "complete_userscript",    "Complete userscripts", },            CP_OVERRIDE_ENTRY, 
    (Func)commands_complete_type,             NULL,     ALWAYS_SM,     
    { .n = COMP_USERSCRIPT }, EP_NONE, { NULL }, },
  
  { { "complete_path",          "Complete local file path", },        CP_OVERRIDE_ENTRY, 
    (Func)commands_complete_type,             NULL,     ALWAYS_SM,     
    { .n = COMP_PATH }, EP_NONE, { NULL }, },
  
  { { "buffers",                          "Buffer", },        CP_COMMANDLINE | CP_HAS_MODE,
    (Func)commands_complete_type,            "Only one buffer",     NEVER_SM,     
    { .n = COMP_BUFFER }, EP_NONE, { "bu", NULL }, },
  

  { { "proxy",                 "Toggle proxy",                    },        CP_COMMANDLINE,     
    (Func)commands_toggle_proxy,        NULL,                    POST_SM,    
    { 0 }, EP_NONE, { NULL }, },
  
  { { "toggle_scripts_host", "Toggle block content for current host" },   CP_COMMANDLINE, 
    (Func) commands_toggle_scripts, NULL,                  POST_SM,    
    { .n = ALLOW_HOST }, EP_NONE, { "hscript",  NULL }, },
  
  { { "toggle_scripts_uri",    "Toggle block content for current url" }, CP_COMMANDLINE, 
    (Func) commands_toggle_scripts, NULL,                POST_SM,    
    { .n = ALLOW_URI }, EP_NONE, { "uscript", NULL }, },
  
  { { "toggle_scripts_host_tmp", "Toggle block content for current host for this session" },  CP_COMMANDLINE, 
    (Func) commands_toggle_scripts, NULL,      POST_SM,    
    { .n = ALLOW_HOST | ALLOW_TMP }, EP_NONE, { "thscript", NULL }, },
  
  { { "toggle_scripts_uri_tmp", "Toggle block content for current url for this session" },   CP_COMMANDLINE, 
    (Func) commands_toggle_scripts, NULL,       POST_SM,    
    { .n = ALLOW_URI | ALLOW_TMP }, EP_NONE, { "tuscript", NULL }, },
  
  { { "toggle_plugins_host", "Toggle plugin blocker for current host" },   CP_COMMANDLINE, 
    (Func) commands_toggle_plugin_blocker, NULL,                  POST_SM,    
    { .n = ALLOW_HOST }, EP_NONE, { "hplugin", NULL }, },
  
  { { "toggle_plugins_uri",    "Toggle plugin blocker for current url" }, CP_COMMANDLINE, 
    (Func) commands_toggle_plugin_blocker, NULL,                POST_SM,    
    { .n = ALLOW_URI }, EP_NONE, { "uplugin", NULL }, },
  
  { { "toggle_plugins_host_tmp", "Toggle block content for current domain for this session" },  CP_COMMANDLINE, 
    (Func) commands_toggle_plugin_blocker, NULL,      POST_SM,    
    { .n = ALLOW_HOST | ALLOW_TMP }, EP_NONE, { "thplugin", NULL }, },
  
  { { "toggle_plugins_uri_tmp", "Toggle block content for current url for this session" },   CP_COMMANDLINE, 
    (Func) commands_toggle_plugin_blocker, NULL,       POST_SM,    
    { .n = ALLOW_URI | ALLOW_TMP }, EP_NONE, { "tuplugin", NULL }, },
  
  { { "toggle_hidden_files",   "Toggle hidden files in directory listing" },  CP_COMMANDLINE, 
    (Func) commands_toggle_hidden_files, NULL,                  ALWAYS_SM,    
    { 0 }, EP_NONE, { "hidden", NULL }, },
  
  { { "print",                 "Print current page" },                         CP_COMMANDLINE, 
    (Func) commands_print, NULL,                             POST_SM,    
    { 0 }, EP_NONE, { "ha", NULL }, },
  
  { { "execute_userscript",    "Execute userscript" },                 CP_COMMANDLINE, 
    (Func) commands_execute_userscript, "No userscripts available",     NEVER_SM,    
    { 0 }, EP_NONE, { NULL }, },
  
  { { "fullscreen",    "Toggle fullscreen" },                 CP_COMMANDLINE, 
    (Func) commands_fullscreen, NULL,     ALWAYS_SM,    
    { 0 }, EP_NONE, { "fs", NULL }, },

  { { "sanitize",    "Clear all private data" },                 CP_COMMANDLINE, 
    (Func) commands_sanitize, "Invalid option for sanitize",     POST_SM,    
    { 0 }, EP_NONE, { NULL }, },
  
  { { "open_editor",    "Open external editor" },                 CP_COMMANDLINE | CP_OVERRIDE_INSERT, 
    (Func) commands_open_editor, "No input focused",     POST_SM,    
    { 0 }, EP_NONE, { "editor", NULL }, },
  
};/*}}}*/

/* SETTINGS_ARRAY {{{*/
  /* { name,    description, builtin, global, type,  argument,  set-function */
static WebSettings DWB_SETTINGS[] = {
  { { "auto-load-images",			                   "Load images automatically", },                                         
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "auto-resize-window",			                 "Autoresize window", },                                       
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "auto-shrink-images",			                 "Automatically shrink standalone images to fit", },                                       
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "cursive-font-family",			               "Cursive font family used to display text", },                                     
    SETTING_BUILTIN,  CHAR,    { .p = "serif"           }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "default-encoding",			                   "Default encoding used to display text", },                                        
    SETTING_BUILTIN,  CHAR,    { .p = NULL      }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "default-font-family",			               "Default font family used to display text", },                                     
    SETTING_BUILTIN,  CHAR,    { .p = "sans-serif"      }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "default-font-size",			                 "Default font size used to display text", },                                       
    SETTING_BUILTIN,  INTEGER, { .i = 12                }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "default-monospace-font-size",			       "Default monospace font size used to display text", },                             
    SETTING_BUILTIN,  INTEGER, { .i = 10                }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-caret-browsing",			             "Whether to enable caret browsing", },                                          
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-default-context-menu",			       "Whether to enable the right click context menu", },                             
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-developer-extras",			           "Whether developer extensions should be enabled",    },                              
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-dns-prefetching",			           "Whether webkit prefetches domain names",    },                              
    SETTING_BUILTIN,  BOOLEAN, { .b = true             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-dom-paste",			                   "Whether to enable DOM paste", },                                        
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-frame-flattening",			           "Whether to enable Frame Flattening", },                                        
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-file-access-from-file-uris",			 "Whether file access from file uris is allowed", },                              
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-html5-database",			             "Enable HTML5 client side SQL-database support" },                                    
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-html5-local-storage",			         "Enable HTML5 local storage", },                              
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-java-applet",			                 "Whether to enable java applets", },                                            
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-offline-web-application-cache",		 "Enable HTML5 offline web application cache", },                           
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-page-cache",			                 "Whether to enable page cache", },                                              
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-plugins",			                     "Whether to enable plugins", },                                                 
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-private-browsing",			           "Whether to enable private browsing mode", },                                        
    SETTING_BUILTIN | SETTING_ONINIT,  BOOLEAN, { .b = false             }, (S_Func) dwb_set_private_browsing,  { 0 }, },
  { { "enable-scripts",			                     "Enable embedded scripting languages", },                                                  
    SETTING_PER_VIEW,  BOOLEAN, { .b = true              }, (S_Func) dwb_set_scripts,  { 0 }, },
  { { "enable-site-specific-quirks",			       "Enable site-specific compatibility workarounds", },                                    
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-spatial-navigation",			         "Spatial navigation", },                                      
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-spell-checking",			             "Whether to enable spell checking", },                                          
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-universal-access-from-file-uris",	 "Whether to allow files loaded through file:", },                        
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enable-xss-auditor",			                 "Whether to enable the XSS auditor", },                                             
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "enforce-96-dpi",			                     "Enforce a resolution of 96 dpi", },                                          
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "fantasy-font-family",			               "Default fantasy font family used to display text", },                                     
    SETTING_BUILTIN,  CHAR,    { .p = "serif"           }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "javascript-can-access-clipboard",			   "Whether javascript can access clipboard", },                         
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "javascript-can-open-windows-automatically", "Whether javascript can open windows", },             
    SETTING_BUILTIN,  BOOLEAN, { .b = false             }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "minimum-font-size",			                 "Minimum font size to display text", },                                       
    SETTING_BUILTIN,  INTEGER, { .i = 5                 }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "minimum-logical-font-size",			         "Minimum logical font size used to display text", },                               
    SETTING_BUILTIN,  INTEGER, { .i = 5                 }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "monospace-font-family",			             "Monospace font family used to display text", },                                   
    SETTING_BUILTIN,  CHAR,    { .p = "monospace"       }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "print-backgrounds",			                 "Whether background images should be printed", },                                       
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "resizable-text-areas",			               "Whether text areas are resizable", },                                    
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "sans-serif-font-family",			             "Sans serif font family used to display text", },                                  
    SETTING_BUILTIN,  CHAR,    { .p = "sans-serif"      }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "serif-font-family",			                 "Serif font family used to display text", },                                       
    SETTING_BUILTIN,  CHAR,    { .p = "serif"           }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "spell-checking-languages",			           "Language used for spellchecking sperated by commas", },                                
    SETTING_BUILTIN,  CHAR,    { .p = NULL              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "tab-key-cycles-through-elements",			   "Tab cycles through elements in insert mode", },              
    SETTING_BUILTIN,  BOOLEAN, { .b = true              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "user-agent",			                         "The user agent string", },                                              
    SETTING_PER_VIEW,                CHAR,    { .p = NULL              }, (S_Func) dwb_set_user_agent,  { 0 }, },
  { { "user-stylesheet-uri",			               "The uri of a stylsheet applied to every page", },                                     
    SETTING_BUILTIN,  CHAR,    { .p = NULL              }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "zoom-step",			                         "The zoom step", },                                               
    SETTING_BUILTIN,  DOUBLE,  { .d = 0.1               }, (S_Func) dwb_webkit_setting,  { 0 }, },
  { { "custom-encoding",                         "The custom encoding of the tab", },                                         
    SETTING_PER_VIEW,                CHAR,    { .p = NULL           }, (S_Func) dwb_webview_property,  { 0 }, },
  { { "editable",                                "Whether content can be modified", },                                        
    SETTING_PER_VIEW,                BOOLEAN, { .b = false             }, (S_Func) dwb_webview_property,  { 0 }, },
  { { "full-content-zoom",                       "Whether the full content is scaled when zooming", },                                       
    SETTING_PER_VIEW,                BOOLEAN, { .b = false             }, (S_Func) dwb_webview_property,  { 0 }, },
  { { "zoom-level",                              "The default zoom level", },
    SETTING_PER_VIEW,                DOUBLE,  { .d = 1.0               }, (S_Func) dwb_webview_property,  { 0 }, },
  { { "proxy",                                   "Whether to use a HTTP-proxy", },                                              
    SETTING_GLOBAL,      BOOLEAN, { .b = false              },  (S_Func) dwb_set_proxy,  { 0 }, },
  { { "proxy-url",                               "The HTTP-proxy url", },                                          
    SETTING_GLOBAL,      CHAR,    { .p = NULL              },   (S_Func) dwb_soup_init_proxy,  { 0 }, },
  { { "ssl-strict",                               "Whether to allow only save certificates", },                                          
    SETTING_GLOBAL,      BOOLEAN,    { .b = true            },   (S_Func) dwb_soup_init_session_features,  { 0 }, },
#ifdef WITH_LIBSOUP_2_38
  { { "ssl-use-system-ca-file",                               "Whether to use the system certification file", },                                          
    SETTING_GLOBAL,      BOOLEAN,    { .b = true            },   (S_Func) dwb_soup_init_session_features,  { 0 }, },
#else
  { { "ssl-ca-cert",                               "Path to ssl-certificate", },                                          
    SETTING_GLOBAL,      CHAR,    { .p = NULL            },   (S_Func) dwb_soup_init_session_features,  { 0 }, },
#endif
  { { "use-ntlm",                               "Whether to use ntlm-authentication", },                                          
    SETTING_GLOBAL,      BOOLEAN,    { .b = false            },   (S_Func) dwb_set_ntlm,  { 0 }, },
  { { "cookies-store-policy",                                  "Whether to store cookies", },                                     
    SETTING_GLOBAL | SETTING_ONINIT,      CHAR, { .p = "session"             }, (S_Func) dwb_set_cookies,  { 0 }, },
  { { "cookies-accept-policy",                     "Cookies to accept, always never or nothirdparty", },                                     
    SETTING_GLOBAL,      CHAR, { .p = "always"          }, (S_Func) dwb_set_cookie_accept_policy,  { 0 }, },
  { { "background-tabs",			                     "Whether to open tabs in background", },                                 
    SETTING_GLOBAL | SETTING_ONINIT,      BOOLEAN,    { .b = false         }, (S_Func) dwb_set_background_tab,  { 0 }, },
  { { "scroll-step",			                     "Whether to open tabs in background", },                                 
    SETTING_GLOBAL | SETTING_ONINIT,      DOUBLE,    { .d = 0         }, (S_Func) dwb_set_scroll_step,  { 0 }, },

  { { "foreground-color",                         "Foreground color of the active tab", },                              
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ffffff"         },    (S_Func) dwb_reload_layout,   { 0 }, },
  { { "background-color",                         "Background color of the active tab", },                              
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#000000"         },    (S_Func) dwb_reload_layout,  { 0 }, },

  { { "tab-active-fg-color",                     "Foreground color of the active tab", },                           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ffffff"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-active-bg-color",                     "Background color of the active tab", },                           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#000000"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-normal-fg-color-1",                     "Foreground color of inactive tabs", },                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#cccccc"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-normal-bg-color-1",                     "Background color of inactive tabs", },                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#505050"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-normal-fg-color-2",                     "Foreground color of inactive tabs", },                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#dddddd"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-normal-bg-color-2",                     "Background color of inactive tabs", },                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#707070"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-number-color",                        "Color of the number in the tab", },                      
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#7ac5cd"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tab-protected-color",                        "Color of the number in the tab", },                      
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ff0000"         },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "tabbed-browsing",                         "Whether to enable tabbed browsing", },                                  
    SETTING_GLOBAL,  BOOLEAN,      { .b = true         },      NULL,  { 0 }, },
  { { "enable-favicon",                         "Whether to show favicons", },                                  
    SETTING_GLOBAL,  BOOLEAN,      { .b = true         },      (S_Func)dwb_set_favicon,  { 0 }, },
  { { "sync-files",                            "Interval to save history and cookies to hdd or 0 to directly write to hdd", },                                  
    SETTING_GLOBAL|SETTING_ONINIT,  INTEGER,      { .i = 120         },      (S_Func) dwb_set_sync_interval,  { 0 }, },

  { { "active-completion-fg-color",                    "Foreground color of the active tabcompletion item", },                        
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#53868b"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "active-completion-bg-color",                    "Background color of the active tabcompletion item", },                        
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#000000"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "normal-completion-fg-color",                    "Foreground color of an inactive tabcompletion item", },                      
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#eeeeee"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "normal-completion-bg-color",                    "Background color of an inactive tabcompletion item", },                      
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#151515"         }, (S_Func) dwb_init_style,  { 0 }, },

  { { "ssl-trusted-color",                         "Color for ssl-encrypted sites, trusted certificate", },                 
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#00ff00"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "ssl-untrusted-color",                       "Color for ssl-encrypted sites, untrusted certificate", },                 
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ff0000"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "error-color",                             "Color for error messages", },                                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ff0000"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "prompt-color",                             "Color for prompt messages", },                                         
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#00ff00"         }, (S_Func) dwb_init_style,  { 0 }, },
  { { "status-allowed-color",                        "Color of allowed elements in the statusbar", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#00ff00"       },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "status-blocked-color",                        "Color of blocked elements in the statusbar", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ffffff"       },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "download-bg-color",                            "Background color of the download label", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#000000"       },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "download-fg-color",                            "Background color of the download label", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#ffffff"       },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "download-gradient-start",                        "Download start gradient color", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#0000aa"       },    (S_Func) dwb_reload_layout,  { 0 }, },
  { { "download-gradient-end",                        "Download end gradient color", },           
    SETTING_GLOBAL,  COLOR_CHAR, { .p = "#00aa00"       },    (S_Func) dwb_reload_layout,  { 0 }, },

  { { "font",                                    "Default font used for the ui", },                                       
    SETTING_GLOBAL,  CHAR, { .p = "monospace 8"          },   (S_Func) dwb_reload_layout,  { 0 }, },
  { { "font-entry",                              "Font of the addressbar", },                            
    SETTING_GLOBAL,  CHAR, { .p = NULL                   },   (S_Func) dwb_reload_layout,  { 0 }, },
  { { "font-completion",                         "Font for tab-completion", },                            
    SETTING_GLOBAL,  CHAR, { .p = NULL                   },   (S_Func) dwb_reload_layout,  { 0 }, },
  { { "font-nofocus",                           "Font of tabs/completion items without focus", },                  
    SETTING_GLOBAL,  CHAR, { .p = NULL                   },   (S_Func) dwb_reload_layout,  { 0 }, },
  { { "font-hidden-statusbar",                           "Font for status elements if statusbar is hidden", },                  
    SETTING_GLOBAL,  CHAR, { .p = "normal 10px helvetica"              },   (S_Func) NULL,  { 0 }, }, 
   
  { { "hint-style",                              "Whether to use 'letter' or 'number' hints", },                     
    SETTING_GLOBAL,  CHAR, { .p = "letter"            },     (S_Func) dwb_init_hints,  { 0 }, },
  { { "hint-letter-seq",                       "Letter sequence for letter hints", },             
    SETTING_GLOBAL,  CHAR, { .p = "FDSARTGBVECWXQYIOPMNHZULKJ"  }, (S_Func) dwb_init_hints,  { 0 }, },
  { { "hint-highlight-links",                  "Whether to highlight links in hintmode", },             
    SETTING_GLOBAL,  BOOLEAN, { .b = false  }, (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-font",                          "Font size of hints", },                                        
    SETTING_GLOBAL,  CHAR, { .p = "bold 10px monospace"             },     (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-fg-color",                           "Foreground color of hints", },                                 
    SETTING_GLOBAL,  CHAR, { .p = "#000000"      },     (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-bg-color",                           "Background color of hints", },                                 
    SETTING_GLOBAL,  CHAR, { .p = "#ffffff"      },     (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-active-color",                       "Color of the active link in hintmode", },                                
    SETTING_GLOBAL,  CHAR, { .p = "#00ff00"      },     (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-normal-color",                       "Color of inactive links in hintmode", },                              
    SETTING_GLOBAL,  CHAR, { .p = "#ffff99"      },     (S_Func) dwb_init_hints,  { 0 }, },
  { { "hint-border",                             "Border used for hints", },                                      
    SETTING_GLOBAL,  CHAR, { .p = "1px solid #000000"    }, (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-opacity",                            "The opacity of hints", },                                     
    SETTING_GLOBAL,  DOUBLE, { .d = 0.8         },          (S_Func) dwb_init_hints, { 0 }, },
  { { "hint-autofollow",                            "Whether to follow hints automatically if one hint matches", },                                     
    SETTING_GLOBAL,  BOOLEAN, { .b = true         },          (S_Func) dwb_init_hints,  { 0 }, },

  { { "auto-completion",                         "Show possible shortcuts", },                                
    SETTING_GLOBAL | SETTING_ONINIT,  BOOLEAN, { .b = false         },     (S_Func)completion_set_autcompletion,  { 0 }, },
  { { "startpage",                               "The default homepage", },                                        
    SETTING_GLOBAL | SETTING_ONINIT,  CHAR,    { .p = "dwb:bookmarks" },        (S_Func)dwb_set_startpage,  { 0 }, }, 
  { { "update-search-delay",                               "The delay when searching between every keypress", },                                        
    SETTING_GLOBAL | SETTING_ONINIT,  INTEGER,    { .i = 200 },        (S_Func)dwb_set_find_delay,  { 0 }, }, 
  { { "single-instance",                         "Whether to have only on instance", },                                         
    SETTING_GLOBAL,  BOOLEAN,    { .b = true },          NULL,  { 0 }, }, 
  { { "save-session",                            "Whether to automatically save sessions", },                                       
    SETTING_GLOBAL,  BOOLEAN,    { .b = true },          NULL,  { 0 }, }, 
  { { "widget-packing",                            "Packing of the main widgets", },                                       
    SETTING_GLOBAL,  CHAR,    { .p = "dtws" },           (S_Func)dwb_set_widget_packing,  { 0 }, }, 
  { { "cache-model",                            "Packing of the main widgets", },                                       
    SETTING_GLOBAL,  CHAR,    { .p = "webbrowser" },           NULL,  { 0 }, }, 
  { { "javascript-schemes",                    "Whether to allow loading urls with 'javascript' scheme", },                                       
    SETTING_GLOBAL,  BOOLEAN,    { .b = true },           NULL,  { 0 }, }, 
  

  /* downloads */
  { { "download-external-command",                        "External program used for downloads", },                               
    SETTING_GLOBAL,  CHAR, { .p = "xterm -e wget dwb_uri -O dwb_output --load-cookies dwb_cookies"   },     NULL,  { 0 }, },
  { { "download-no-confirm",                        "Whether to confirm download directory", },
    SETTING_GLOBAL,  BOOLEAN, { .b = false   },     NULL,  { 0 }, },
  { { "download-directory",                        "Default download directory", },                               
    SETTING_GLOBAL,  CHAR, { .p = NULL   },     NULL,  { 0 }, },
  { { "download-use-external-program",           "Whether to use an external download program", },                           
    SETTING_GLOBAL,  BOOLEAN, { .b = false         },    NULL,  { 0 }, },

  { { "complete-history",                        "Whether to complete browsing history with tab", },                              
    SETTING_GLOBAL,  BOOLEAN, { .b = true         },     NULL,  { 0 }, },
  { { "complete-bookmarks",                        "Whether to complete bookmarks with tab", },                                     
    SETTING_GLOBAL,  BOOLEAN, { .b = true         },     NULL,  { 0 }, },
  { { "complete-searchengines",                   "Whether to complete searchengines with tab", },                                     
    SETTING_GLOBAL,  BOOLEAN, { .b = false         },     NULL,  { 0 }, },
  { { "complete-userscripts",                        "Whether to complete userscripts", },                                     
    SETTING_GLOBAL,  BOOLEAN, { .b = false         },     NULL,  { 0 }, },

  { { "default-width",                           "Default width of the window", },                                           
    SETTING_GLOBAL,  INTEGER, { .i = 800          }, NULL,  { 0 }, },
  { { "default-height",                          "Default height of the window", },                                           
    SETTING_GLOBAL,  INTEGER, { .i = 600          }, NULL,  { 0 }, },
  { { "message-delay",                           "Time in seconds, messages are shown", },                                           
    SETTING_GLOBAL | SETTING_ONINIT,  INTEGER, { .i = 2          }, (S_Func) dwb_set_message_delay,  { 0 }, },
  { { "history-length",                          "Length of the browsing history", },                                          
    SETTING_GLOBAL | SETTING_ONINIT,  INTEGER, { .i = 500          }, (S_Func) dwb_set_history_length,  { 0 }, },
  { { "navigation-history-max",                          "Length of the navigation history", },                                          
    SETTING_GLOBAL,  INTEGER, { .i = 500          }, (S_Func) NULL,  { 0 }, },
  { { "scrollbars",                                  "Whether scrollbars should be enabled", },     
    SETTING_GLOBAL,  BOOLEAN, { .b = false },  NULL,  { 0 }, },
  { { "scheme-handler",                            "Handler script for unsupported schemes", },                                            
    SETTING_GLOBAL,  CHAR, { .p = NULL }, NULL,  { 0 }, }, 
  { { "editor",                            "External editor", },                                            
    SETTING_GLOBAL,  CHAR, { .p = "xterm -e vim dwb_uri" }, NULL,   { 0 }, }, 
  { { "adblocker",                               "Whether to block advertisements via a filterlist", },                   
    SETTING_GLOBAL,  BOOLEAN, { .b = false }, (S_Func)dwb_set_adblock,   { 0 }, }, 
  { { "adblocker-filterlist",                    "Path to a filterlist", },                   
    SETTING_GLOBAL,  CHAR, { .p = NULL }, NULL,   { 0 }, }, 
#ifdef WITH_LIBSOUP_2_38 
  { { "addressbar-dns-lookup",                               "Whether to perform a dns check for text typed into the address bar", },                   
    SETTING_GLOBAL | SETTING_ONINIT,  BOOLEAN, { .b = false }, (S_Func)dwb_set_dns_lookup,   { 0 }, }, 
#endif
  { { "plugin-blocker",                         "Whether to block flash plugins and replace them with a clickable element", },                   
    SETTING_PER_VIEW,  BOOLEAN, { .b = true }, (S_Func)dwb_set_plugin_blocker,   { 0 }, }, 
  { { "plugin-blocker",                         "Whether to block flash plugins and replace them with a clickable element", },                   
    SETTING_PER_VIEW,  BOOLEAN, { .b = true }, (S_Func)dwb_set_plugin_blocker,   { 0 }, }, 
  { { "auto-insert-mode",                         "Whether go automatically in insert mode if input or textarea has focus", },                   
    SETTING_GLOBAL | SETTING_ONINIT,  BOOLEAN, { .b = false }, (S_Func)dwb_set_auto_insert_mode,   { 0 }, }, 
  { { "tabbar-visible",                         "Number of seconds the tabbar is shown when switching tabs", },                   
    SETTING_GLOBAL | SETTING_ONINIT,  INTEGER, { .i = 2 }, (S_Func)dwb_set_tabbar_delay,   { 0 }, }, 
  { { "new-tab-position-policy",                         "Number of seconds the tabbar is shown when switching tabs", },                   
    SETTING_GLOBAL | SETTING_ONINIT,  CHAR, { .p = "right", .n = CLOSE_TAB_POSITION_MASK, .i = 0 }, (S_Func)dwb_set_new_tab_position_policy,   { 0 }, }, 
  { { "close-tab-focus-policy",                         "Number of seconds the tabbar is shown when switching tabs", },                   
    SETTING_GLOBAL | SETTING_ONINIT,  CHAR, { .p = "left" }, (S_Func)dwb_set_close_tab_position_policy,   { 0 }, }, 
  { { "close-last-tab",                         "Whether close_tab closes the last tab", },                   
    SETTING_GLOBAL,  BOOLEAN, { .b = false }, NULL,   { 0 }, },
};/*}}}*/
