/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

#ifndef PARSER_OPS_h
#define PARSER_OPS_h

/*
 * parser_ops.h
 *
 * The operational routines in the parser/symbolic ds package
 */

#include <stdlib.h>

#include "parser_defs.h"

int p_scanner(s_ds ds,char* s, int flag);
int p_convert_eq_node( s_ds ds, eq_node* node, node_name type);
int p_convert_eq_node_list( s_ds ds, eq_node* node, node_name type);
int p_convert_token_strings( s_ds ds);
int p_build_temp_fn( s_ds ds);
int p_build_tree_at_node( eq_node* node);
int p_build_node_list( eq_node* node);
int p_build_tree( s_ds ds);
int p_eval_tree(token* eqn, 
                 double* value, 
                 double* x, 
                 double* p, 
                 double* tempf, 
                 double* stack);
int p_eval_node_list(s_ds ds, 
                      double* f, 
                      double* x, 
                      double* p, 
                      node_name node_indx);
int p_check_tree( token* tree);
int p_check_node( eq_node* n);
int p_scan_built_tree( s_ds ds);
int p_writeC(s_ds ds, eq_node* nd, int temp_flag, char* name, FILE* fp);
int p_write(s_ds ds, eq_node* nd, char* str, FILE* fp);

#endif
/* ! PARSER_OPS_h */

