/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * vector.c
 */

#include <stdio.h>
#include <math.h>

#include <math_utils.h>

/*  ------------------------------------------------------------------------
      copies a vector, x, into another vector, y.
   
    ------------------------------------------------------------------------ */

void
dcopy(int n, double *dx, int incx, double *dy, int incy)
{
	int	i, ix, iy; 
	if(n < 0) return;
	ix = iy = 0;
 	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for(i=0; i<n; i++) 
	   {dy[iy] = dx[ix];
	    ix += incx;
	    iy += incy; }
	return;
 
}



/*  ------------------------------------------------------------------------
    compute vector dot product

    ------------------------------------------------------------------------ */

double
ddot(int n, double *dx, int incx, double *dy, int incy)
{
	double	dtemp; 
	int	i,ix,iy;
 
	dtemp = 0.0;				
	if(n < 0) return(0.0);		
	ix = iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for( i=0; i<n; i++)
	   {dtemp += dx[ix]*dy[iy];
	    ix += incx;
	    iy += incy;}
	return( dtemp );
}           




 
/*  ------------------------------------------------------------------------
      constant times a vector plus a vector.

    ------------------------------------------------------------------------ */
void
daxpy(int n, double da, double *dx, int incx, double *dy, int incy)
{
	int	i, ix, iy;

	if(n < 0 || da == 0.0) return;
	
	ix = iy = 0;
	if(incx < 0)ix = (-n+1)*incx;
	if(incy < 0)iy = (-n+1)*incy;
	for(i=0; i<n; i++)
	   {dy[iy] = dy[iy] + da*dx[ix];
	    ix += incx;
	    iy += incy;}
}


/*  ------------------------------------------------------------------------
     interchanges two vectors 
   
    ------------------------------------------------------------------------ */

void
dswap (int n, double *dx, int incx, double *dy, int incy)
{
	double	dtemp;
	int	i, ix, iy;
 
	if(n < 0) return;

	ix = iy = 0;
	if(incx < 0) ix = (-n+1)*incx;
	if(incy < 0) iy = (-n+1)*incy;
	for( i=0; i<n; i++)
    	   {dtemp = dx[ix];
    	    dx[ix] = dy[iy];
    	    dy[iy] = dtemp;
    	    ix += incx;
    	    iy += incy;}
}



/*  ------------------------------------------------------------------------
    scales a vector by a constant
   
    ------------------------------------------------------------------------ */
void
dscal(int n, double da, double *dx, int incx)
{
	int	i;

	if(n < 0) return;
	for(i=0; i<n; i++) 
	   dx[i] *= da;
}


/*
	finds the index of element having max. absolute value.
*/

int
idamax(int n, double *dx, int incx)
{
      double	dmax;
      int	i,ix,result; 
 
      result = -1;
      if( n < 1 ) return(result);
      result = 0;
      if(n == 1) return(result);
 
      ix = 0;
      dmax = fabs(dx[0]);
      ix = ix + incx;
      for(i=1; i<n; i++)
         {if(fabs(dx[ix]) > dmax) 
             {result = i;
              dmax = fabs(dx[ix]);}
          ix = ix + incx;
         }       
      return(result);
}


/*
 * sup_norm - computes the sup norm of a vector
 */
double
sup_norm(double *v, int n)
{
  double result = 0.0, temp;
  int i;

  for (i=0; i<n; i++)
    {
      temp = fabs(v[i]);
      if (temp > result) result = temp;
    }
  return( result );
}
