/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * stop.c
 */

#include <stdio.h>
#include <stdlib.h>

#include "version.h"
#include "init_local.h"

/*
 * stop_execution()
 *
 * This procedure is called when an unrecoverable error is encountered.
 *
 * Output to stderr is something like:
 *
 *    DsTool: ERROR MESSAGE HERE
 *    DsTool: exiting.
 *
 * This routine directly accesses PROGRAM_TITLE since we do not wish
 * to assume that the postmaster has been initialized.
 *
 */
void
stop_execution(char *s)
{
  fprintf(stderr, "%s: %s\n", PROGRAM_TITLE, s);
  fprintf(stderr, "%s: exiting.\n", PROGRAM_TITLE);
  exit(1);
}


