<?xml version="1.0" encoding="iso-8859-1" ?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output
version="1.0"
method="html"
indent="yes"
encoding="iso-8859-1"/>

<xsl:template match="index">
<html>
<head><title>Index du paquet doc-debian-fr</title></head>
<body bgcolor="#c0c0c0">
<div align="center"><h1>Index du paquet doc-debian-fr</h1></div>
<p>
Le paquet doc-debian-fr contient
de nombreuses documentations sur Debian :
</p>
<p><h2>Le projet Debian</h2>
</p>
<br/>
<xsl:for-each select="texte[@categorie='hist']">
<xsl:apply-templates/>
</xsl:for-each>
<p><h2>Rdaction de documentation et traduction</h2></p>
<br/>
<xsl:for-each select="texte[@categorie='format']">
<xsl:apply-templates/>
</xsl:for-each>
<p><h2>Utilisation</h2></p>
<br/>
<xsl:for-each select="texte[@categorie='util']">
<xsl:apply-templates/>
</xsl:for-each>
<p><h2>Dveloppement</h2></p>
<br/>
<xsl:for-each select="texte[@categorie='devel']">
<xsl:apply-templates/>
</xsl:for-each>
<br/><hr width="100%"/>
<a href="mailto:philippe.batailler@free.fr">Philippe Batailler</a>
3 Jan 2003 10:10:09 +0100
</body>
</html>
</xsl:template>

<xsl:template match="titre">
<xsl:param name="fichier">
<xsl:value-of select="following-sibling::fichier"/>
</xsl:param>
<p>
<div align="center">
<a href="{$fichier}/index.html"><b><xsl:value-of select="."/></b></a>
</div>
</p>
</xsl:template>

<xsl:template match="fichier"/>

<xsl:template match="traducteur">
<b>Traducteur : </b>
<br/>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="auteur">
<b>Auteur : </b>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="adresse">
<xsl:param name="ad">
<xsl:value-of select="."/>
</xsl:param>
<a href="mailto:{$ad}"><xsl:value-of select="."/></a>
<br/>
</xsl:template>

<xsl:template match="version">
<b>Version : </b>
<xsl:apply-templates/>
<br/><br/>
</xsl:template>

<xsl:template match="description">
<xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="remarques">
<br/><i>Note : </i><xsl:apply-templates/><br/>
</xsl:template>

</xsl:stylesheet>

 
