/*****************************************************************

  lirc.c -- routines for lirc remote input

  Copyright (c) 1999-2002 by Mike Oliphant - oliphant@gtk.org

    http://www.nostatic.org/grip

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

*****************************************************************/

#include <config.h>
#ifdef HAVE_LIRC_LIRC_CLIENT_H

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <lirc/lirc_client.h>

struct lirc_config *config;

/* Initialize lirc, and return the file descriptor */  
int init_lirc(void)
{
  int lirc_fd;

  /*  if(lirc_readconfig(NULL,&config,NULL)!=0) {
    printf("unable to read ~/.lircrc\n");

    return(-1);
    }*/

  lirc_fd=lirc_init("ddj",1);

  if(lirc_fd==-1) {
    printf("unable to init lirc\n");

    return(-1);
  }

  /* Set the lirc socket to not block */
  fcntl(lirc_fd,F_SETFL,O_NONBLOCK);

  return lirc_fd;
}

/* Return a single lirc command string. Return of -1 indicates no command
   was received */
int lirc_get_event(int lirc_fd,char *cmd)
{
  char *code;
  int ret;
  char *lirc_cmd;

  while(lirc_nextcode(&code)==0) {
    if(code==NULL) {
      return -1;
    }

    /* For some reason I need to re-read the config file each time
       to get it to work reliably. Blah. */
    if(lirc_readconfig(NULL,&config,NULL)!=0) {
      printf("unable to read ~/.lircrc\n");
      
      return(-1);
    }
    
    if((ret=lirc_code2char(config,code,&lirc_cmd))==0 && lirc_cmd!=NULL) {
      strcpy(cmd,lirc_cmd);

      lirc_freeconfig(config);
      free(code);
      return 0;
    }

    lirc_freeconfig(config);
    free(code);
    
    if(ret==-1) break;
  }

  return -1;
}

/* Shut down the lirc connection */
void close_lirc(void)
{
  /*  lirc_freeconfig(config);*/
  lirc_deinit();
}

#endif /* HAVE_LIRC_LIRC_CLIENT_H */
